/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEvent;
import de.schlichtherle.truezip.fs.FsFederatingController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsTouchedListener;
import de.schlichtherle.truezip.util.Link;
import de.schlichtherle.truezip.util.Links;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FsDefaultManager
extends FsManager {
    private final Map<FsMountPoint, Link<Scheduler>> schedulers = new WeakHashMap<FsMountPoint, Link<Scheduler>>();
    private final Link.Type optionalScheduleType;
    private static final Comparator<FsController<?>> BOTTOM_UP_COMPARATOR = new Comparator<FsController<?>>(){

        @Override
        public int compare(FsController<?> l, FsController<?> r) {
            return ((FsModel)r.getModel()).getMountPoint().hierarchicalize().compareTo(((FsModel)l.getModel()).getMountPoint().hierarchicalize());
        }
    };

    public FsDefaultManager() {
        this(Link.Type.WEAK);
    }

    FsDefaultManager(Link.Type optionalScheduleType) {
        assert (null != optionalScheduleType);
        this.optionalScheduleType = optionalScheduleType;
    }

    @Override
    @NonNull
    public synchronized FsController<?> getController(@NonNull FsMountPoint mountPoint, @NonNull FsCompositeDriver driver) {
        return this.getController(mountPoint, null, driver);
    }

    private FsController<?> getController(FsMountPoint mountPoint, FsController<?> parent, FsCompositeDriver driver) {
        if (null == mountPoint.getParent()) {
            if (null != parent) {
                throw new IllegalArgumentException("Parent/member mismatch!");
            }
            return driver.newController(mountPoint, null);
        }
        Scheduler scheduler = Links.getTarget(this.schedulers.get(mountPoint));
        if (null == scheduler) {
            if (null == parent) {
                parent = this.getController(mountPoint.getParent(), null, driver);
            }
            scheduler = new Scheduler(driver.newController(mountPoint, parent));
        }
        return scheduler.controller;
    }

    @Override
    public synchronized int getSize() {
        return this.schedulers.size();
    }

    @Override
    public synchronized Iterator<FsController<?>> iterator() {
        return this.getControllers().iterator();
    }

    private Set<FsController<?>> getControllers() {
        TreeSet snapshot = new TreeSet(BOTTOM_UP_COMPARATOR);
        for (Link<Scheduler> link : this.schedulers.values()) {
            Scheduler scheduler = Links.getTarget(link);
            FsFederatingController controller = null == scheduler ? null : scheduler.controller;
            if (null == controller) continue;
            snapshot.add(controller);
        }
        return snapshot;
    }

    private final class Scheduler
    implements FsTouchedListener {
        final FsFederatingController controller;

        Scheduler(FsController<?> prospect) {
            this.controller = new FsFederatingController(prospect);
            ((FsModel)this.controller.getModel()).addFileSystemTouchedListener(this);
            this.touchedChanged(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void touchedChanged(FsEvent event) {
            Object model = this.controller.getModel();
            assert (null == event || event.getSource() == model);
            FsDefaultManager fsDefaultManager = FsDefaultManager.this;
            synchronized (fsDefaultManager) {
                FsDefaultManager.this.schedulers.put(((FsModel)model).getMountPoint(), (((FsModel)model).isTouched() ? Link.Type.STRONG : FsDefaultManager.this.optionalScheduleType).newLink(this));
            }
        }
    }
}

