/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TContainsFileException;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@DefaultAnnotation(value={NonNull.class})
@Immutable
final class TIO {
    static final FsManager MANAGER = FsManagerLocator.SINGLETON.getManager();

    private TIO() {
    }

    public static void moveAll(File src, File dst, TArchiveDetector detector) throws IOException {
        if (TIO.contains(src, dst)) {
            throw new TContainsFileException(src, dst);
        }
        TIO.moveAll0(src, dst, detector);
    }

    private static void moveAll0(File src, File dst, TArchiveDetector detector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcIsArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstIsArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcIsArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstIsArchived && TFile.isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new IOException(dst + " (not a directory)");
            }
            Object[] members = src.list();
            if (!srcIsArchived && dstIsArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TIO.moveAll0(new TFile(src, (String)member, detector), new TFile(dst, (String)member, detector), detector);
            }
            if (!srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new IOException(dst + " (cannot set last modification time)");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new IOException(dst + " (not a file)");
            }
            TIO.copy0(true, src, dst);
        } else {
            if (src.isFile()) {
                throw new IOException(src + " (cannot copy special file)");
            }
            throw new IOException(src + " (missing file)");
        }
        if (!src.delete()) {
            throw new IOException(src + " (cannot delete)");
        }
    }

    public static void copyAll(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        if (TIO.contains(src, dst)) {
            throw new TContainsFileException(src, dst);
        }
        TIO.copyAll0(preserve, src, dst, srcDetector, dstDetector);
    }

    private static void copyAll0(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcIsArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstIsArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcIsArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstIsArchived && TFile.isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new IOException(dst + " (not a directory)");
            }
            Object[] members = src.list();
            if (!srcIsArchived && dstIsArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TIO.copyAll0(preserve, new TFile(src, (String)member, srcDetector), new TFile(dst, (String)member, dstDetector), srcDetector, dstDetector);
            }
            if (preserve && !srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new IOException(dst + " (cannot set last modification time)");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new IOException(dst + " (not a file)");
            }
            TIO.copy0(preserve, src, dst);
        } else {
            if (src.isFile()) {
                throw new IOException(src + " (cannot copy special file)");
            }
            throw new IOException(src + " (missing file)");
        }
    }

    public static void copy(boolean preserve, File src, File dst) throws IOException {
        if (TIO.contains(src, dst)) {
            throw new TContainsFileException(src, dst);
        }
        TIO.copy0(preserve, src, dst);
    }

    private static void copy0(boolean preserve, File src, File dst) throws IOException {
        InputSocket<?> input = TIO.getInputSocket(src, BitField.noneOf(FsInputOption.class));
        OutputSocket<?> output = TIO.getOutputSocket(dst, BitField.noneOf(FsOutputOption.class).set(FsOutputOption.CREATE_PARENTS, TFile.isLenient()), preserve ? (Entry)input.getLocalTarget() : null);
        IOSocket.copy(input, output);
    }

    static InputSocket<?> getInputSocket(File src, BitField<FsInputOption> options) {
        TFile file;
        TFile archive;
        if (src instanceof TFile && null != (archive = (file = (TFile)src).getInnerArchive())) {
            return archive.getController().getInputSocket(file.getInnerEntryName0(), options);
        }
        FsPath path = new FsPath(src);
        return MANAGER.getController(path.getMountPoint(), TFile.getDefaultArchiveDetector()).getInputSocket(path.getEntryName(), options);
    }

    static OutputSocket<?> getOutputSocket(File dst, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        TFile file;
        TFile archive;
        if (dst instanceof TFile && null != (archive = (file = (TFile)dst).getInnerArchive())) {
            return archive.getController().getOutputSocket(file.getInnerEntryName0(), options, template);
        }
        FsPath path = new FsPath(dst);
        return MANAGER.getController(path.getMountPoint(), TFile.getDefaultArchiveDetector()).getOutputSocket(path.getEntryName(), options, template);
    }

    public static void deleteAll(File node) throws IOException {
        if (node.isDirectory()) {
            for (File member : node.listFiles()) {
                TIO.deleteAll(member);
            }
        }
        if (!node.delete()) {
            throw new IOException(node + " (cannot delete)");
        }
    }

    public static boolean contains(File a, File b) {
        return Paths.contains(a.getAbsolutePath(), b.getAbsolutePath(), File.separatorChar);
    }
}

