/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.xmlparser.FilterBuilder;
import org.apache.lucene.xmlparser.FilterBuilderFactory;
import org.apache.lucene.xmlparser.FilteredQueryBuilder;
import org.apache.lucene.xmlparser.ParserException;
import org.apache.lucene.xmlparser.QueryBuilder;
import org.apache.lucene.xmlparser.QueryBuilderFactory;
import org.apache.lucene.xmlparser.builders.BooleanQueryBuilder;
import org.apache.lucene.xmlparser.builders.ConstantScoreQueryBuilder;
import org.apache.lucene.xmlparser.builders.RangeFilterBuilder;
import org.apache.lucene.xmlparser.builders.SpanFirstBuilder;
import org.apache.lucene.xmlparser.builders.SpanNearBuilder;
import org.apache.lucene.xmlparser.builders.SpanNotBuilder;
import org.apache.lucene.xmlparser.builders.SpanOrBuilder;
import org.apache.lucene.xmlparser.builders.SpanOrTermsBuilder;
import org.apache.lucene.xmlparser.builders.SpanQueryBuilderFactory;
import org.apache.lucene.xmlparser.builders.SpanTermBuilder;
import org.apache.lucene.xmlparser.builders.TermQueryBuilder;
import org.apache.lucene.xmlparser.builders.UserInputQueryBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoreParser
implements QueryBuilder {
    protected Analyzer analyzer;
    protected QueryParser parser;
    protected QueryBuilderFactory queryFactory;
    protected FilterBuilderFactory filterFactory;

    public CoreParser(Analyzer analyzer, QueryParser parser) {
        this.analyzer = analyzer;
        this.parser = parser;
        this.filterFactory = new FilterBuilderFactory();
        this.filterFactory.addBuilder("RangeFilter", new RangeFilterBuilder());
        this.queryFactory = new QueryBuilderFactory();
        this.queryFactory.addBuilder("TermQuery", new TermQueryBuilder());
        this.queryFactory.addBuilder("BooleanQuery", new BooleanQueryBuilder(this.queryFactory));
        this.queryFactory.addBuilder("UserQuery", new UserInputQueryBuilder(new QueryParser("contents", analyzer)));
        this.queryFactory.addBuilder("FilteredQuery", new FilteredQueryBuilder(this.filterFactory, this.queryFactory));
        this.queryFactory.addBuilder("ConstantScoreQuery", new ConstantScoreQueryBuilder(this.filterFactory));
        SpanQueryBuilderFactory sqof = new SpanQueryBuilderFactory();
        SpanNearBuilder snb = new SpanNearBuilder(sqof);
        sqof.addBuilder("SpanNear", snb);
        this.queryFactory.addBuilder("SpanNear", snb);
        SpanTermBuilder snt = new SpanTermBuilder();
        sqof.addBuilder("SpanTerm", snt);
        this.queryFactory.addBuilder("SpanTerm", snt);
        SpanOrBuilder sot = new SpanOrBuilder(sqof);
        sqof.addBuilder("SpanOr", sot);
        this.queryFactory.addBuilder("SpanOr", sot);
        SpanOrTermsBuilder sots = new SpanOrTermsBuilder(analyzer);
        sqof.addBuilder("SpanOrTerms", sots);
        this.queryFactory.addBuilder("SpanOrTerms", sots);
        SpanFirstBuilder sft = new SpanFirstBuilder(sqof);
        sqof.addBuilder("SpanFirst", sft);
        this.queryFactory.addBuilder("SpanFirst", sft);
        SpanNotBuilder snot = new SpanNotBuilder(sqof);
        sqof.addBuilder("SpanNot", snot);
        this.queryFactory.addBuilder("SpanNot", snot);
    }

    public Query parse(InputStream xmlStream) throws ParserException {
        return this.getQuery(CoreParser.parseXML(xmlStream).getDocumentElement());
    }

    public void addQueryBuilder(String nodeName, QueryBuilder builder) {
        this.queryFactory.addBuilder(nodeName, builder);
    }

    public void addFilterBuilder(String nodeName, FilterBuilder builder) {
        this.filterFactory.addBuilder(nodeName, builder);
    }

    private static Document parseXML(InputStream pXmlFile) throws ParserException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception se) {
            throw new ParserException("XML Parser configuration error", se);
        }
        Document doc = null;
        try {
            doc = db.parse(pXmlFile);
        }
        catch (Exception se) {
            throw new ParserException("Error parsing XML stream:" + se, se);
        }
        return doc;
    }

    public Query getQuery(Element e) throws ParserException {
        return this.queryFactory.getQuery(e);
    }
}

