/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.FilterIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.ThreadInterruptedException;

public class ThrottledIndexOutput
extends FilterIndexOutput {
    public static final int DEFAULT_MIN_WRITTEN_BYTES = 1024;
    private final int bytesPerSecond;
    private long flushDelayMillis;
    private long closeDelayMillis;
    private long seekDelayMillis;
    private long pendingBytes;
    private long minBytesWritten;
    private long timeElapsed;
    private final byte[] bytes = new byte[1];

    public ThrottledIndexOutput newFromDelegate(IndexOutput out) {
        return new ThrottledIndexOutput(this.bytesPerSecond, this.flushDelayMillis, this.closeDelayMillis, this.seekDelayMillis, this.minBytesWritten, out);
    }

    public ThrottledIndexOutput(int bytesPerSecond, long delayInMillis, IndexOutput out) {
        this(bytesPerSecond, delayInMillis, delayInMillis, delayInMillis, 1024L, out);
    }

    public ThrottledIndexOutput(int bytesPerSecond, long delays, int minBytesWritten, IndexOutput out) {
        this(bytesPerSecond, delays, delays, delays, minBytesWritten, out);
    }

    public static final int mBitsToBytes(int mbits) {
        return mbits * 125000000;
    }

    public ThrottledIndexOutput(int bytesPerSecond, long flushDelayMillis, long closeDelayMillis, long seekDelayMillis, long minBytesWritten, IndexOutput out) {
        super("ThrottledIndexOutput(" + String.valueOf(out) + ")", out == null ? "n/a" : out.getName(), out);
        assert (bytesPerSecond > 0);
        this.bytesPerSecond = bytesPerSecond;
        this.flushDelayMillis = flushDelayMillis;
        this.closeDelayMillis = closeDelayMillis;
        this.seekDelayMillis = seekDelayMillis;
        this.minBytesWritten = minBytesWritten;
    }

    public void close() throws IOException {
        try {
            ThrottledIndexOutput.sleep(this.closeDelayMillis + this.getDelay(true));
        }
        finally {
            this.out.close();
        }
    }

    public void writeByte(byte b) throws IOException {
        this.bytes[0] = b;
        this.writeBytes(this.bytes, 0, 1);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        long before = System.nanoTime();
        this.out.writeBytes(b, offset, length);
        this.timeElapsed += System.nanoTime() - before;
        this.pendingBytes += (long)length;
        ThrottledIndexOutput.sleep(this.getDelay(false));
    }

    protected long getDelay(boolean closing) {
        long actualBps;
        if (this.pendingBytes > 0L && (closing || this.pendingBytes > this.minBytesWritten) && (actualBps = this.timeElapsed / this.pendingBytes * 1000000000L) > (long)this.bytesPerSecond) {
            long expected = this.pendingBytes * 1000L / (long)this.bytesPerSecond;
            long delay = expected - TimeUnit.NANOSECONDS.toMillis(this.timeElapsed);
            this.pendingBytes = 0L;
            this.timeElapsed = 0L;
            return delay;
        }
        return 0L;
    }

    @SuppressForbidden(reason="Thread sleep")
    private static void sleep(long ms) {
        if (ms <= 0L) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(e);
        }
    }
}

