/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public class PointRangeQueryBuilder
implements QueryBuilder {
    @Override
    public Query getQuery(Element e) throws ParserException {
        String field = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String lowerTerm = DOMUtils.getAttributeOrFail(e, "lowerTerm");
        String upperTerm = DOMUtils.getAttributeOrFail(e, "upperTerm");
        String type = DOMUtils.getAttribute(e, "type", "int");
        try {
            if (type.equalsIgnoreCase("int")) {
                return IntPoint.newRangeQuery((String)field, (int)Integer.valueOf(lowerTerm), (int)Integer.valueOf(upperTerm));
            }
            if (type.equalsIgnoreCase("long")) {
                return LongPoint.newRangeQuery((String)field, (long)Long.valueOf(lowerTerm), (long)Long.valueOf(upperTerm));
            }
            if (type.equalsIgnoreCase("double")) {
                return DoublePoint.newRangeQuery((String)field, (double)Double.valueOf(lowerTerm), (double)Double.valueOf(upperTerm));
            }
            if (type.equalsIgnoreCase("float")) {
                return FloatPoint.newRangeQuery((String)field, (float)Float.valueOf(lowerTerm).floatValue(), (float)Float.valueOf(upperTerm).floatValue());
            }
            throw new ParserException("type attribute must be one of: [long, int, double, float]");
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Could not parse lowerTerm or upperTerm into a number", nfe);
        }
    }
}

