/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.nodes;

import org.apache.lucene.document.NumericField;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.standard.config.NumericConfig;
import org.apache.lucene.queryParser.standard.nodes.AbstractRangeQueryNode;
import org.apache.lucene.queryParser.standard.nodes.NumericQueryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRangeQueryNode
extends AbstractRangeQueryNode<NumericQueryNode> {
    public NumericConfig numericConfig;

    public NumericRangeQueryNode(NumericQueryNode lower, NumericQueryNode upper, boolean lowerInclusive, boolean upperInclusive, NumericConfig numericConfig) throws QueryNodeException {
        this.setBounds(lower, upper, lowerInclusive, upperInclusive, numericConfig);
    }

    private static NumericField.DataType getNumericDataType(Number number) throws QueryNodeException {
        if (number instanceof Long) {
            return NumericField.DataType.LONG;
        }
        if (number instanceof Integer) {
            return NumericField.DataType.INT;
        }
        if (number instanceof Double) {
            return NumericField.DataType.DOUBLE;
        }
        if (number instanceof Float) {
            return NumericField.DataType.FLOAT;
        }
        throw new QueryNodeException(new MessageImpl(QueryParserMessages.NUMBER_CLASS_NOT_SUPPORTED_BY_NUMERIC_RANGE_QUERY, number.getClass()));
    }

    public void setBounds(NumericQueryNode lower, NumericQueryNode upper, boolean lowerInclusive, boolean upperInclusive, NumericConfig numericConfig) throws QueryNodeException {
        if (numericConfig == null) {
            throw new IllegalArgumentException("numericConfig cannot be null!");
        }
        NumericField.DataType lowerNumberType = lower != null && lower.getValue() != null ? NumericRangeQueryNode.getNumericDataType(lower.getValue()) : null;
        NumericField.DataType upperNumberType = upper != null && upper.getValue() != null ? NumericRangeQueryNode.getNumericDataType(upper.getValue()) : null;
        if (lowerNumberType != null && !lowerNumberType.equals((Object)numericConfig.getType())) {
            throw new IllegalArgumentException("lower value's type should be the same as numericConfig type: " + lowerNumberType + " != " + numericConfig.getType());
        }
        if (upperNumberType != null && !upperNumberType.equals((Object)numericConfig.getType())) {
            throw new IllegalArgumentException("upper value's type should be the same as numericConfig type: " + upperNumberType + " != " + numericConfig.getType());
        }
        super.setBounds(lower, upper, lowerInclusive, upperInclusive);
        this.numericConfig = numericConfig;
    }

    public NumericConfig getNumericConfig() {
        return this.numericConfig;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<numericRange lowerInclusive='");
        sb.append(this.isLowerInclusive()).append("' upperInclusive='").append(this.isUpperInclusive()).append("' precisionStep='" + this.numericConfig.getPrecisionStep()).append("' type='" + this.numericConfig.getType()).append("'>\n");
        sb.append(this.getLowerBound()).append('\n');
        sb.append(this.getUpperBound()).append('\n');
        sb.append("</numericRange>");
        return sb.toString();
    }
}

