/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.util.List;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.config.FieldConfig;
import org.apache.lucene.queryParser.core.config.QueryConfigHandler;
import org.apache.lucene.queryParser.core.nodes.BoostQueryNode;
import org.apache.lucene.queryParser.core.nodes.FieldableNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.standard.config.BoostAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoostQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof FieldableNode && (node.getParent() == null || !(node.getParent() instanceof FieldableNode))) {
            FieldConfig fieldConfig;
            FieldableNode fieldNode = (FieldableNode)node;
            QueryConfigHandler config = this.getQueryConfigHandler();
            if (config != null && (fieldConfig = config.getFieldConfig(fieldNode.getField())) != null && fieldConfig.hasAttribute(BoostAttribute.class)) {
                BoostAttribute boostAttr = (BoostAttribute)fieldConfig.getAttribute(BoostAttribute.class);
                return new BoostQueryNode(node, boostAttr.getBoost());
            }
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

