/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import java.util.List;
import org.apache.lucene.queryParser.core.nodes.GroupQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanQueryNode
extends QueryNodeImpl {
    private static final long serialVersionUID = -2206623652088638072L;

    public BooleanQueryNode(List<QueryNode> clauses) {
        this.setLeaf(false);
        this.allocate();
        this.set(clauses);
    }

    @Override
    public String toString() {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return "<boolean operation='default'/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<boolean operation='default'>");
        for (QueryNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(((Object)child).toString());
        }
        sb.append("\n</boolean>");
        return sb.toString();
    }

    @Override
    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String filler = "";
        for (QueryNode child : this.getChildren()) {
            sb.append(filler).append(child.toQueryString(escapeSyntaxParser));
            filler = " ";
        }
        if (this.getParent() != null && this.getParent() instanceof GroupQueryNode || this.isRoot()) {
            return sb.toString();
        }
        return "( " + sb.toString() + " )";
    }

    @Override
    public QueryNode cloneTree() throws CloneNotSupportedException {
        BooleanQueryNode clone = (BooleanQueryNode)super.cloneTree();
        return clone;
    }
}

