/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import org.apache.lucene.queryParser.core.nodes.FieldQueryNode;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

public class ParametricQueryNode
extends FieldQueryNode {
    private static final long serialVersionUID = -5770038129741218116L;
    private CompareOperator operator;

    public ParametricQueryNode(CharSequence field, CompareOperator comp, CharSequence value, int begin, int end) {
        super(field, value, begin, end);
        this.operator = comp;
        this.setLeaf(true);
    }

    public CharSequence getOperand() {
        return this.getText();
    }

    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        return this.field + "" + this.operator.toString() + "\"" + this.text + "\"";
    }

    public String toString() {
        return "<parametric field='" + this.field + "' operator='" + this.operator.toString() + "' text='" + this.text + "'/>";
    }

    public ParametricQueryNode cloneTree() throws CloneNotSupportedException {
        ParametricQueryNode clone = (ParametricQueryNode)super.cloneTree();
        clone.operator = this.operator;
        return clone;
    }

    public CompareOperator getOperator() {
        return this.operator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompareOperator {
        LE,
        LT,
        GE,
        GT,
        EQ,
        NE;


        public String toString() {
            if (LE.equals((Object)this)) {
                return "<=";
            }
            if (LT.equals((Object)this)) {
                return "<";
            }
            if (GE.equals((Object)this)) {
                return ">=";
            }
            if (GT.equals((Object)this)) {
                return ">";
            }
            if (EQ.equals((Object)this)) {
                return "=";
            }
            if (NE.equals((Object)this)) {
                return "!=";
            }
            throw new IllegalArgumentException("Unknown operator");
        }
    }
}

