/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.nodes.FieldQueryNode;
import org.apache.lucene.queryParser.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryParser.core.nodes.GroupQueryNode;
import org.apache.lucene.queryParser.core.nodes.NoTokenFoundQueryNode;
import org.apache.lucene.queryParser.core.nodes.ParametricQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.TextableQueryNode;
import org.apache.lucene.queryParser.core.nodes.TokenizedPhraseQueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.standard.config.AnalyzerAttribute;
import org.apache.lucene.queryParser.standard.config.PositionIncrementsAttribute;
import org.apache.lucene.queryParser.standard.nodes.MultiPhraseQueryNode;
import org.apache.lucene.queryParser.standard.nodes.StandardBooleanQueryNode;
import org.apache.lucene.queryParser.standard.nodes.WildcardQueryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private Analyzer analyzer;
    private boolean positionIncrementsEnabled;

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        if (this.getQueryConfigHandler().hasAttribute(AnalyzerAttribute.class)) {
            this.analyzer = ((AnalyzerAttribute)this.getQueryConfigHandler().getAttribute(AnalyzerAttribute.class)).getAnalyzer();
            this.positionIncrementsEnabled = false;
            if (this.getQueryConfigHandler().hasAttribute(PositionIncrementsAttribute.class) && ((PositionIncrementsAttribute)this.getQueryConfigHandler().getAttribute(PositionIncrementsAttribute.class)).isPositionIncrementsEnabled()) {
                this.positionIncrementsEnabled = true;
            }
            if (this.analyzer != null) {
                return super.process(queryTree);
            }
        }
        return queryTree;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof TextableQueryNode && !(node instanceof WildcardQueryNode) && !(node instanceof FuzzyQueryNode) && !(node instanceof ParametricQueryNode)) {
            FieldQueryNode fieldNode = (FieldQueryNode)node;
            String text = fieldNode.getTextAsString();
            String field = fieldNode.getFieldAsString();
            TokenStream source = this.analyzer.tokenStream(field, (Reader)new StringReader(text));
            CachingTokenFilter buffer = new CachingTokenFilter(source);
            PositionIncrementAttribute posIncrAtt = null;
            int numTokens = 0;
            int positionCount = 0;
            boolean severalTokensAtSamePosition = false;
            if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
                posIncrAtt = (PositionIncrementAttribute)buffer.getAttribute(PositionIncrementAttribute.class);
            }
            try {
                while (buffer.incrementToken()) {
                    int positionIncrement;
                    ++numTokens;
                    int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                        continue;
                    }
                    severalTokensAtSamePosition = true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                buffer.reset();
                source.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!buffer.hasAttribute(TermAttribute.class)) {
                return new NoTokenFoundQueryNode();
            }
            TermAttribute termAtt = (TermAttribute)buffer.getAttribute(TermAttribute.class);
            if (numTokens == 0) {
                return new NoTokenFoundQueryNode();
            }
            if (numTokens == 1) {
                String term = null;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.term();
                }
                catch (IOException e) {
                    // empty catch block
                }
                fieldNode.setText(term);
                return fieldNode;
            }
            if (severalTokensAtSamePosition) {
                if (positionCount == 1) {
                    LinkedList<QueryNode> children = new LinkedList<QueryNode>();
                    for (int i = 0; i < numTokens; ++i) {
                        String term = null;
                        try {
                            boolean hasNext = buffer.incrementToken();
                            assert (hasNext);
                            term = termAtt.term();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        children.add(new FieldQueryNode(field, term, -1, -1));
                    }
                    return new GroupQueryNode(new StandardBooleanQueryNode(children, true));
                }
                MultiPhraseQueryNode mpq = new MultiPhraseQueryNode();
                ArrayList<FieldQueryNode> multiTerms = new ArrayList<FieldQueryNode>();
                int position = -1;
                int termGroupCount = 0;
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    int positionIncrement = 1;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.term();
                        if (posIncrAtt != null) {
                            positionIncrement = posIncrAtt.getPositionIncrement();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (positionIncrement > 0 && multiTerms.size() > 0) {
                        for (FieldQueryNode termNode : multiTerms) {
                            if (this.positionIncrementsEnabled) {
                                termNode.setPositionIncrement(position);
                            } else {
                                termNode.setPositionIncrement(termGroupCount);
                            }
                            mpq.add(termNode);
                        }
                        ++termGroupCount;
                        multiTerms.clear();
                    }
                    position += positionIncrement;
                    multiTerms.add(new FieldQueryNode(field, term, -1, -1));
                }
                for (FieldQueryNode termNode : multiTerms) {
                    if (this.positionIncrementsEnabled) {
                        termNode.setPositionIncrement(position);
                    } else {
                        termNode.setPositionIncrement(termGroupCount);
                    }
                    mpq.add(termNode);
                }
                return mpq;
            }
            TokenizedPhraseQueryNode pq = new TokenizedPhraseQueryNode();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.term();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                FieldQueryNode newFieldNode = new FieldQueryNode(field, term, -1, -1);
                if (this.positionIncrementsEnabled) {
                    newFieldNode.setPositionIncrement(position += positionIncrement);
                } else {
                    newFieldNode.setPositionIncrement(i);
                }
                pq.add(newFieldNode);
            }
            return pq;
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

