/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.SegmentInfoWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public class SimpleTextSegmentInfoWriter
extends SegmentInfoWriter {
    static final BytesRef SI_VERSION = new BytesRef((CharSequence)"    version ");
    static final BytesRef SI_DOCCOUNT = new BytesRef((CharSequence)"    number of documents ");
    static final BytesRef SI_USECOMPOUND = new BytesRef((CharSequence)"    uses compound file ");
    static final BytesRef SI_NUM_DIAG = new BytesRef((CharSequence)"    diagnostics ");
    static final BytesRef SI_DIAG_KEY = new BytesRef((CharSequence)"      key ");
    static final BytesRef SI_DIAG_VALUE = new BytesRef((CharSequence)"      value ");
    static final BytesRef SI_NUM_FILES = new BytesRef((CharSequence)"    files ");
    static final BytesRef SI_FILE = new BytesRef((CharSequence)"      file ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory dir, SegmentInfo si, FieldInfos fis, IOContext ioContext) throws IOException {
        block9: {
            IndexOutput output;
            block8: {
                String segFileName = IndexFileNames.segmentFileName((String)si.name, (String)"", (String)"si");
                si.addFile(segFileName);
                boolean success = false;
                output = dir.createOutput(segFileName, ioContext);
                try {
                    Set files;
                    BytesRefBuilder scratch = new BytesRefBuilder();
                    SimpleTextUtil.write((DataOutput)output, SI_VERSION);
                    SimpleTextUtil.write((DataOutput)output, si.getVersion().toString(), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    SimpleTextUtil.write((DataOutput)output, SI_DOCCOUNT);
                    SimpleTextUtil.write((DataOutput)output, Integer.toString(si.getDocCount()), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    SimpleTextUtil.write((DataOutput)output, SI_USECOMPOUND);
                    SimpleTextUtil.write((DataOutput)output, Boolean.toString(si.getUseCompoundFile()), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    Map diagnostics = si.getDiagnostics();
                    int numDiagnostics = diagnostics == null ? 0 : diagnostics.size();
                    SimpleTextUtil.write((DataOutput)output, SI_NUM_DIAG);
                    SimpleTextUtil.write((DataOutput)output, Integer.toString(numDiagnostics), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    if (numDiagnostics > 0) {
                        for (Map.Entry diagEntry : diagnostics.entrySet()) {
                            SimpleTextUtil.write((DataOutput)output, SI_DIAG_KEY);
                            SimpleTextUtil.write((DataOutput)output, (String)diagEntry.getKey(), scratch);
                            SimpleTextUtil.writeNewline((DataOutput)output);
                            SimpleTextUtil.write((DataOutput)output, SI_DIAG_VALUE);
                            SimpleTextUtil.write((DataOutput)output, (String)diagEntry.getValue(), scratch);
                            SimpleTextUtil.writeNewline((DataOutput)output);
                        }
                    }
                    int numFiles = (files = si.files()) == null ? 0 : files.size();
                    SimpleTextUtil.write((DataOutput)output, SI_NUM_FILES);
                    SimpleTextUtil.write((DataOutput)output, Integer.toString(numFiles), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    if (numFiles > 0) {
                        for (String fileName : files) {
                            SimpleTextUtil.write((DataOutput)output, SI_FILE);
                            SimpleTextUtil.write((DataOutput)output, fileName, scratch);
                            SimpleTextUtil.writeNewline((DataOutput)output);
                        }
                    }
                    SimpleTextUtil.writeChecksum(output, scratch);
                    success = true;
                    if (success) break block8;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
                        IOUtils.deleteFilesIgnoringExceptions((Directory)dir, (String[])new String[]{segFileName});
                    } else {
                        output.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
                IOUtils.deleteFilesIgnoringExceptions((Directory)dir, (String[])new String[]{segFileName});
                break block9;
            }
            output.close();
        }
    }
}

