/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.visit;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Named;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.Strings;

public class PluginValueVisitor
implements NodeVisitor {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Function<String, String> stringSubstitutionStrategy;

    @Inject
    public PluginValueVisitor(@Named(value={"StringSubstitutor"}) @Named(value={"StringSubstitutor"}) Function<String, String> stringSubstitutionStrategy) {
        this.stringSubstitutionStrategy = stringSubstitutionStrategy;
    }

    private String parseValue(Node node, String name, Collection<String> aliases, StringBuilder debugLog) {
        String rawValue;
        String elementValue = node.getValue();
        Optional<String> attributeValue = node.removeMatchingAttribute(name, aliases).filter(Strings::isNotEmpty);
        if (Strings.isNotEmpty((CharSequence)elementValue)) {
            attributeValue.ifPresent(value -> LOGGER.error("Configuration contains {} with both attribute value ({}) AND element value ({}). Please specify only one value. Using the element value.", (Object)node.getName(), value, (Object)elementValue));
            rawValue = elementValue;
        } else {
            rawValue = attributeValue.orElse(null);
        }
        String value2 = this.stringSubstitutionStrategy.apply(rawValue);
        StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)"value", (Object)value2, (CharSequence)", ");
        return value2;
    }

    @Override
    public Object visitField(Field field, Node node, StringBuilder debugLog) {
        String name = Keys.getName(field);
        Collection<String> aliases = Keys.getAliases(field);
        return Cast.cast((Object)this.parseValue(node, name, aliases, debugLog));
    }

    @Override
    public Object visitParameter(Parameter parameter, Node node, StringBuilder debugLog) {
        String name = Keys.getName(parameter);
        Collection<String> aliases = Keys.getAliases(parameter);
        return Cast.cast((Object)this.parseValue(node, name, aliases, debugLog));
    }
}

