/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import java.util.function.Supplier;

public final class PluginEntry {
    private final String key;
    private final String className;
    private final String name;
    private final String elementType;
    private final boolean printable;
    private final boolean deferChildren;
    private final String namespace;

    private PluginEntry(Builder builder) {
        this.key = builder.getKey();
        this.className = builder.getClassName();
        this.name = builder.getName();
        this.elementType = builder.getElementType();
        this.printable = builder.isPrintable();
        this.deferChildren = builder.isDeferChildren();
        this.namespace = builder.getNamespace();
    }

    public String getKey() {
        return this.key;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getElementType() {
        return this.elementType;
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public boolean isDeferChildren() {
        return this.deferChildren;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        return "PluginEntry [key=" + this.key + ", className=" + this.className + ", name=" + this.name + ", printable=" + this.printable + ", defer=" + this.deferChildren + ", namespace=" + this.namespace + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<PluginEntry> {
        private String key;
        private String className;
        private String name;
        private String elementType = "";
        private boolean printable;
        private boolean deferChildren;
        private String namespace = "";

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getClassName() {
            return this.className;
        }

        public Builder setClassName(String className) {
            this.className = className;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getElementType() {
            return this.elementType;
        }

        public Builder setElementType(String elementType) {
            this.elementType = elementType;
            return this;
        }

        public boolean isPrintable() {
            return this.printable;
        }

        public Builder setPrintable(boolean printable) {
            this.printable = printable;
            return this;
        }

        public boolean isDeferChildren() {
            return this.deferChildren;
        }

        public Builder setDeferChildren(boolean deferChildren) {
            this.deferChildren = deferChildren;
            return this;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public PluginEntry get() {
            return new PluginEntry(this);
        }
    }
}

