/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.ExitMessage;
import org.apache.logging.log4j.message.FlowMessage;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.spi.LoggingSystem;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.Strings;

public class DefaultFlowMessageFactory
implements FlowMessageFactory {
    private static final String EXIT_DEFAULT_PREFIX = "Exit";
    private static final String ENTRY_DEFAULT_PREFIX = "Enter";
    private final String entryText;
    private final String exitText;
    private final MessageFactory messageFactory;

    public DefaultFlowMessageFactory() {
        this(ENTRY_DEFAULT_PREFIX, EXIT_DEFAULT_PREFIX);
    }

    public DefaultFlowMessageFactory(String entryText, String exitText) {
        this.entryText = entryText;
        this.exitText = exitText;
        this.messageFactory = LoggingSystem.getMessageFactory();
    }

    public String getEntryText() {
        return this.entryText;
    }

    public String getExitText() {
        return this.exitText;
    }

    @Override
    public EntryMessage newEntryMessage(String format, Object ... params) {
        Message message;
        boolean hasFormat = Strings.isNotEmpty(format);
        if (params == null || params.length == 0) {
            message = hasFormat ? this.messageFactory.newMessage(format) : null;
        } else if (hasFormat) {
            message = this.messageFactory.newMessage(format, params);
        } else {
            StringBuilder sb = new StringBuilder("params(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("{}");
            }
            sb.append(")");
            message = this.messageFactory.newMessage(sb.toString(), params);
        }
        return this.newEntryMessage(message);
    }

    @Override
    public EntryMessage newEntryMessage(Message message) {
        return new SimpleEntryMessage(this.entryText, this.makeImmutable(message));
    }

    private Message makeImmutable(Message message) {
        if (message instanceof ReusableMessage) {
            return ((ReusableMessage)message).memento();
        }
        return message;
    }

    @Override
    public ExitMessage newExitMessage(String format, Object result) {
        boolean hasFormat = Strings.isNotEmpty(format);
        Message message = result == null ? (hasFormat ? this.messageFactory.newMessage(format) : null) : this.messageFactory.newMessage(hasFormat ? format : "with({})", result);
        return this.newExitMessage(message);
    }

    @Override
    public ExitMessage newExitMessage(Message message) {
        return new SimpleExitMessage(this.exitText, message);
    }

    @Override
    public ExitMessage newExitMessage(EntryMessage message) {
        return new SimpleExitMessage(this.exitText, message);
    }

    @Override
    public ExitMessage newExitMessage(Object result, EntryMessage message) {
        return new SimpleExitMessage(this.exitText, result, message);
    }

    @Override
    public ExitMessage newExitMessage(Object result, Message message) {
        return new SimpleExitMessage(this.exitText, result, message);
    }

    private static final class SimpleExitMessage
    extends AbstractFlowMessage
    implements ExitMessage {
        private final Object result;
        private final boolean isVoid;

        SimpleExitMessage(String exitText, EntryMessage message) {
            this(exitText, message.getMessage());
        }

        SimpleExitMessage(String exitText, Message message) {
            super(exitText, message);
            this.result = null;
            this.isVoid = true;
        }

        SimpleExitMessage(String exitText, Object result, EntryMessage message) {
            this(exitText, result, message.getMessage());
        }

        SimpleExitMessage(String exitText, Object result, Message message) {
            super(exitText, message);
            this.result = result;
            this.isVoid = false;
        }

        @Override
        public String getFormattedMessage() {
            String formattedMessage = super.getFormattedMessage();
            if (this.isVoid) {
                return formattedMessage;
            }
            return formattedMessage + ": " + this.result;
        }
    }

    private static final class SimpleEntryMessage
    extends AbstractFlowMessage
    implements EntryMessage {
        SimpleEntryMessage(String entryText, Message message) {
            super(entryText, message);
        }
    }

    private static class AbstractFlowMessage
    implements FlowMessage,
    StringBuilderFormattable {
        private final Message message;
        private final String text;

        AbstractFlowMessage(String text, Message message) {
            this.message = message;
            this.text = text;
        }

        @Override
        public String getFormattedMessage() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormattedMessage();
            }
            return this.text;
        }

        @Override
        public String getFormat() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormat();
            }
            return this.text;
        }

        @Override
        public Object[] getParameters() {
            if (this.message != null) {
                return this.message.getParameters();
            }
            return null;
        }

        @Override
        public Throwable getThrowable() {
            if (this.message != null) {
                return this.message.getThrowable();
            }
            return null;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void formatTo(StringBuilder buffer) {
            buffer.append(this.text);
            if (this.message != null) {
                buffer.append(" ");
                StringBuilders.appendValue(buffer, this.message);
            }
        }
    }
}

