/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.layout;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.util.Transform;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.Strings;

@Configurable(elementType="layout", printObject=true)
@Plugin
public final class Log4j1XmlLayout
extends AbstractStringLayout {
    private static final String EOL = "\r\n";
    private final boolean locationInfo;
    private final boolean properties;

    @PluginFactory
    public static Log4j1XmlLayout createLayout(@PluginConfiguration Configuration configuration, @PluginAttribute(value="locationInfo") @PluginAttribute(value="locationInfo") boolean locationInfo, @PluginAttribute(value="properties") @PluginAttribute(value="properties") boolean properties) {
        return new Log4j1XmlLayout(configuration, locationInfo, properties);
    }

    private Log4j1XmlLayout(Configuration configuration, boolean locationInfo, boolean properties) {
        super(configuration, StandardCharsets.UTF_8);
        this.locationInfo = locationInfo;
        this.properties = properties;
    }

    public boolean isLocationInfo() {
        return this.locationInfo;
    }

    public boolean isProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(LogEvent event, ByteBufferDestination destination) {
        StringBuilder text = (StringBuilder)this.stringBuilderRecycler.acquire();
        try {
            this.formatTo(event, text);
            Encoder stringBuilderEncoder = (Encoder)this.stringBuilderEncoderRecycler.acquire();
            try {
                stringBuilderEncoder.encode((Object)text, destination);
            }
            finally {
                this.stringBuilderEncoderRecycler.release((Object)stringBuilderEncoder);
            }
        }
        finally {
            this.stringBuilderRecycler.release((Object)text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toSerializable(LogEvent event) {
        StringBuilder text = (StringBuilder)this.stringBuilderRecycler.acquire();
        try {
            this.formatTo(event, text);
            String string = text.toString();
            return string;
        }
        finally {
            this.stringBuilderRecycler.release((Object)text);
        }
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="The throwable is formatted into a log file, which should be private.")
    private void formatTo(LogEvent event, StringBuilder buf) {
        ReadOnlyStringMap contextMap;
        StackTraceElement source;
        Throwable thrown;
        buf.append("<log4j:event logger=\"");
        buf.append(Transform.escapeHtmlTags((String)event.getLoggerName()));
        buf.append("\" timestamp=\"");
        buf.append(event.getTimeMillis());
        buf.append("\" level=\"");
        buf.append(Transform.escapeHtmlTags((String)String.valueOf(event.getLevel())));
        buf.append("\" thread=\"");
        buf.append(Transform.escapeHtmlTags((String)event.getThreadName()));
        buf.append("\">");
        buf.append(EOL);
        buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCData((StringBuilder)buf, (String)event.getMessage().getFormattedMessage());
        buf.append("]]></log4j:message>");
        buf.append(EOL);
        List ndc = event.getContextStack().asList();
        if (!ndc.isEmpty()) {
            buf.append("<log4j:NDC><![CDATA[");
            Transform.appendEscapingCData((StringBuilder)buf, (String)Strings.join((Iterable)ndc, (char)' '));
            buf.append("]]></log4j:NDC>");
            buf.append(EOL);
        }
        if ((thrown = event.getThrown()) != null) {
            buf.append("<log4j:throwable><![CDATA[");
            StringWriter w = new StringWriter();
            thrown.printStackTrace(new PrintWriter(w));
            Transform.appendEscapingCData((StringBuilder)buf, (String)w.toString());
            buf.append("]]></log4j:throwable>");
            buf.append(EOL);
        }
        if (this.locationInfo && (source = event.getSource()) != null) {
            buf.append("<log4j:locationInfo class=\"");
            buf.append(Transform.escapeHtmlTags((String)source.getClassName()));
            buf.append("\" method=\"");
            buf.append(Transform.escapeHtmlTags((String)source.getMethodName()));
            buf.append("\" file=\"");
            buf.append(Transform.escapeHtmlTags((String)source.getFileName()));
            buf.append("\" line=\"");
            buf.append(source.getLineNumber());
            buf.append("\"/>");
            buf.append(EOL);
        }
        if (this.properties && !(contextMap = event.getContextData()).isEmpty()) {
            buf.append("<log4j:properties>\r\n");
            contextMap.forEach((key, val) -> {
                if (val != null) {
                    buf.append("<log4j:data name=\"");
                    buf.append(Transform.escapeHtmlTags((String)key));
                    buf.append("\" value=\"");
                    buf.append(Transform.escapeHtmlTags((String)Objects.toString(val, null)));
                    buf.append("\"/>");
                    buf.append(EOL);
                }
            });
            buf.append("</log4j:properties>");
            buf.append(EOL);
        }
        buf.append("</log4j:event>");
        buf.append(EOL);
        buf.append(EOL);
    }
}

