/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.security;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.RSAUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.conf.SessionHAConfiguration$;
import org.apache.linkis.server.exception.IllegalUserTicketException;
import org.apache.linkis.server.exception.LoginExpireException;
import org.apache.linkis.server.exception.NonLoginException;
import org.apache.linkis.server.security.ProxyUserSSOUtils$;
import org.apache.linkis.server.security.SSOUtils$;
import org.apache.linkis.server.ticket.UserTicketService;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class SSOUtils$
implements Logging {
    public static SSOUtils$ MODULE$;
    private final String USER_TICKET_ID_STRING;
    private final long org$apache$linkis$server$security$SSOUtils$$sessionTimeout;
    private final ConcurrentHashMap<String, Object> org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime;
    private final boolean sslEnable;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SSOUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SSOUtils$ sSOUtils$ = this;
        synchronized (sSOUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String USER_TICKET_ID_STRING() {
        return this.USER_TICKET_ID_STRING;
    }

    public long org$apache$linkis$server$security$SSOUtils$$sessionTimeout() {
        return this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout;
    }

    public ConcurrentHashMap<String, Object> org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime() {
        return this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime;
    }

    public boolean sslEnable() {
        return this.sslEnable;
    }

    public ConcurrentHashMap<String, Object> getUserTicketIdMap() {
        if (SessionHAConfiguration$.MODULE$.SsoRedis()) {
            return new UserTicketService();
        }
        return new ConcurrentHashMap<String, Object>();
    }

    public String decryptLogin(String passwordString) {
        if (this.sslEnable()) {
            return new String(RSAUtils$.MODULE$.decrypt(passwordString), (String)Configuration$.MODULE$.BDP_ENCODING().getValue());
        }
        return passwordString;
    }

    public Option<Tuple2<String, Object>> getUserAndLoginTime(String userTicketId) {
        return ServerConfiguration$.MODULE$.getUsernameByTicket(userTicketId).map((Function1 & Serializable & scala.Serializable)userAndLoginTime -> {
            if (userAndLoginTime.indexOf(",") < 0) {
                throw new IllegalUserTicketException("Illegal user token information(\u975e\u6cd5\u7684\u7528\u6237token\u4fe1\u606f).");
            }
            int index = userAndLoginTime.lastIndexOf(",");
            return new Tuple2((Object)userAndLoginTime.substring(0, index), (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(userAndLoginTime.substring(index + 1))).toLong()));
        });
    }

    private String getUserTicketId(String username) {
        String timeoutUser = new StringBuilder(1).append(username).append(",").append(System.currentTimeMillis()).toString();
        return ServerConfiguration$.MODULE$.getTicketByUsername(timeoutUser);
    }

    public void setLoginUser(Function1<Cookie, BoxedUnit> addCookie, String username, boolean updateSession) {
        this.logger().info(new StringBuilder(37).append("add login userTicketCookie for user ").append(username).append(".").toString());
        String userTicketId = this.getUserTicketId(username);
        Object object = updateSession ? this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().put(userTicketId, BoxesRunTime.boxToLong((long)System.currentTimeMillis())) : BoxedUnit.UNIT;
        Cookie cookie = new Cookie(this.USER_TICKET_ID_STRING(), userTicketId);
        cookie.setMaxAge(-1);
        if (this.sslEnable()) {
            cookie.setSecure(true);
        }
        cookie.setPath("/");
        addCookie.apply((Object)cookie);
    }

    public void setLoginUser(Function2<String, String, BoxedUnit> addUserTicketKV, String username) {
        this.logger().info(new StringBuilder(31).append("add login userTicket for user ").append(username).append(".").toString());
        Tuple2<String, String> userTicketId = this.getUserTicketKV(username);
        this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().put((String)userTicketId._2(), BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        addUserTicketKV.apply(userTicketId._1(), userTicketId._2());
    }

    public boolean setLoginUser$default$3() {
        return true;
    }

    public Tuple2<String, String> getUserTicketKV(String username) {
        String userTicketId = this.getUserTicketId(username);
        return new Tuple2((Object)this.USER_TICKET_ID_STRING(), (Object)userTicketId);
    }

    public void removeLoginUser(Function0<Cookie[]> getCookies) {
        Cookie[] cookies = (Cookie[])getCookies.apply();
        if (cookies != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SSOUtils$.$anonfun$removeLoginUser$1(x$2))).foreach((Function1 & Serializable & scala.Serializable)cookie -> {
                SSOUtils$.$anonfun$removeLoginUser$2(cookie);
                return BoxedUnit.UNIT;
            });
        }
        ProxyUserSSOUtils$.MODULE$.removeProxyUser((Function0<Cookie[]>)(Function0 & Serializable & scala.Serializable)() -> cookies);
    }

    public void removeLoginUserByAddCookie(Function1<Cookie, BoxedUnit> addEmptyCookie) {
        Cookie cookie = new Cookie(this.USER_TICKET_ID_STRING(), null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        if (this.sslEnable()) {
            cookie.setSecure(true);
        }
        addEmptyCookie.apply((Object)cookie);
        ProxyUserSSOUtils$.MODULE$.removeLoginUserByAddCookie(addEmptyCookie);
    }

    public void removeLoginUser(Function1<String, Option<String>> removeKeyReturnValue) {
        ((Option)removeKeyReturnValue.apply((Object)this.USER_TICKET_ID_STRING())).foreach((Function1 & Serializable & scala.Serializable)t -> {
            if (MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().containsKey(t)) {
                return MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().remove(t);
            }
            return BoxedUnit.UNIT;
        });
    }

    public String getLoginUsername(Function0<Cookie[]> getCookies) {
        return (String)this.getLoginUser(getCookies).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NonLoginException("You are not logged in, please login first(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55!)");
        });
    }

    public Option<String> getLoginUser(Function0<Cookie[]> getCookies) {
        return this.getLoginUser((Function1<String, Option<String>>)(Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.apply(getCookies.apply()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4)).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SSOUtils$.$anonfun$getLoginUser$3(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getValue())));
    }

    public Option<String> getLoginUser(Function1<String, Option<String>> getUserTicketId) {
        return ((Option)getUserTicketId.apply((Object)this.USER_TICKET_ID_STRING())).map((Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.isTimeoutOrNot((String)t);
            return (String)((Tuple2)MODULE$.getUserAndLoginTime((String)t).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalUserTicketException("Illegal user token information(\u975e\u6cd5\u7684\u7528\u6237token\u4fe1\u606f).");
            }))._1();
        });
    }

    public String getLoginUsername(Function1<String, Option<String>> getUserTicketId) {
        return (String)this.getLoginUser(getUserTicketId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NonLoginException("You are not logged in, please login first(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55!)");
        });
    }

    public Option<String> getLoginUserIgnoreTimeout(Function1<String, Option<String>> getUserTicketId) {
        return ((Option)getUserTicketId.apply((Object)this.USER_TICKET_ID_STRING())).map((Function1 & Serializable & scala.Serializable)userTicketId -> MODULE$.getUserAndLoginTime((String)userTicketId)).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8._1()));
    }

    public void updateLastAccessTime(Function0<Cookie[]> getCookies) {
        this.updateLastAccessTime((Function1<String, Option<String>>)(Function1 & Serializable & scala.Serializable)x$9 -> Option$.MODULE$.apply(getCookies.apply()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$10)).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SSOUtils$.$anonfun$updateLastAccessTime$3(x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getValue())));
    }

    public void updateLastAccessTime(Function1<String, Option<String>> getUserTicketId) {
        ((Option)getUserTicketId.apply((Object)this.USER_TICKET_ID_STRING())).foreach((Function1 & Serializable & scala.Serializable)userTicketId -> {
            SSOUtils$.MODULE$.isTimeoutOrNot(userTicketId);
            return BoxedUnit.UNIT;
        });
    }

    private void isTimeoutOrNot(String userTicketId) throws LoginExpireException {
        if (!this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().containsKey(userTicketId)) {
            throw new LoginExpireException("You are not logged in, please login first!(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55!)");
        }
        long lastAccessTime = BoxesRunTime.unboxToLong((Object)this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().get(userTicketId));
        if (System.currentTimeMillis() - lastAccessTime > this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout() && !BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
            if (this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().containsKey(userTicketId) && System.currentTimeMillis() - BoxesRunTime.unboxToLong((Object)this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().get(userTicketId)) > this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout()) {
                this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().remove(userTicketId);
                throw new LoginExpireException("Login has expired, please log in again!(\u767b\u5f55\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01)");
            }
            return;
        }
        if ((double)(System.currentTimeMillis() - lastAccessTime) >= (double)this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout() * 0.5) {
            this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().put(userTicketId, BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
            return;
        }
    }

    public long getSessionTimeOut() {
        return this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout();
    }

    public static final /* synthetic */ boolean $anonfun$removeLoginUser$1(Cookie x$2) {
        String string = x$2.getName();
        String string2 = MODULE$.USER_TICKET_ID_STRING();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$removeLoginUser$2(Cookie cookie) {
        Object object = MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().containsKey(cookie.getValue()) ? MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().remove(cookie.getValue()) : BoxedUnit.UNIT;
        cookie.setValue(null);
        cookie.setMaxAge(0);
    }

    public static final /* synthetic */ boolean $anonfun$getLoginUser$3(Cookie x$5) {
        String string = x$5.getName();
        String string2 = MODULE$.USER_TICKET_ID_STRING();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateLastAccessTime$3(Cookie x$11) {
        String string = x$11.getName();
        String string2 = MODULE$.USER_TICKET_ID_STRING();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private SSOUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.USER_TICKET_ID_STRING = (String)ServerConfiguration$.MODULE$.LINKIS_SERVER_SESSION_TICKETID_KEY().getValue();
        this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout = ((TimeType)ServerConfiguration$.MODULE$.BDP_SERVER_WEB_SESSION_TIMEOUT().getValue()).toLong();
        this.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime = this.getUserTicketIdMap();
        this.sslEnable = BoxesRunTime.unboxToBoolean((Object)ServerConfiguration$.MODULE$.BDP_SERVER_SECURITY_SSL().getValue());
        Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(){

            public void run() {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(SSOUtils$.MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$run$2(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        long v = tuple2._2$mcJ$sp();
                        if (SSOUtils$.MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().containsKey(k)) {
                            if (SSOUtils$.MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().containsKey(k) && System.currentTimeMillis() - BoxesRunTime.unboxToLong((Object)SSOUtils$.MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().get(k)) > SSOUtils$.MODULE$.org$apache$linkis$server$security$SSOUtils$$sessionTimeout()) {
                                SSOUtils$.MODULE$.logger().info(new StringBuilder(59).append("remove timeout userTicket ").append(k).append(", since the last access time is ").append(DateFormatUtils.format((long)v, (String)"yyyy-MM-dd HH:mm:ss")).append(".").toString());
                                return SSOUtils$.MODULE$.org$apache$linkis$server$security$SSOUtils$$userTicketIdToLastAccessTime().remove(k);
                            }
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                }), (Function1 & Serializable & scala.Serializable)t -> {
                    anon.1.$anonfun$run$4(t);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ boolean $anonfun$run$2(Tuple2 x$1) {
                return System.currentTimeMillis() - x$1._2$mcJ$sp() > SSOUtils$.MODULE$.org$apache$linkis$server$security$SSOUtils$$sessionTimeout();
            }

            public static final /* synthetic */ void $anonfun$run$4(Throwable t) {
                SSOUtils$.MODULE$.logger().error("failed to do remove", t);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$4$adapted(java.lang.Throwable ), $anonfun$run$2$adapted(scala.Tuple2 ), $anonfun$run$3(scala.Tuple2 )}, serializedLambda);
            }
        }, this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout(), this.org$apache$linkis$server$security$SSOUtils$$sessionTimeout() / 10L, TimeUnit.MILLISECONDS);
    }
}

