/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.sqoop.params;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.datasource.client.DataSourceRemoteClient;
import org.apache.linkis.datasource.client.request.GetConnectParamsByDataSourceNameAction;
import org.apache.linkis.datasource.client.request.GetConnectParamsByDataSourceNameAction$;
import org.apache.linkis.datasource.client.response.GetConnectParamsByDataSourceNameResult;
import org.apache.linkis.datasourcemanager.common.protocol.DsInfoQueryRequest;
import org.apache.linkis.datasourcemanager.common.protocol.DsInfoResponse;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconnplugin.sqoop.client.RemoteClientHolder;
import org.apache.linkis.engineconnplugin.sqoop.context.SqoopEnvConfiguration$;
import org.apache.linkis.engineconnplugin.sqoop.context.SqoopParamsConfiguration$;
import org.apache.linkis.engineconnplugin.sqoop.exception.DataSourceRpcErrorException;
import org.apache.linkis.engineconnplugin.sqoop.params.SqoopParamsResolver;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0002\u0004\u0001'!)a\u0005\u0001C\u0001O!)\u0011\u0006\u0001C!U!)!\n\u0001C\u0001\u0017\")A\u000b\u0001C\u0001+\ni2+]8pa\u0012\u000bG/Y*pkJ\u001cW\rU1sC6\u001c(+Z:pYZ,'O\u0003\u0002\b\u0011\u00051\u0001/\u0019:b[NT!!\u0003\u0006\u0002\u000bM\fxn\u001c9\u000b\u0005-a\u0011\u0001E3oO&tWmY8o]BdWoZ5o\u0015\tia\"\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!\"D\b\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"\u0001\u0004\n\u0005u1!aE*r_>\u0004\b+\u0019:b[N\u0014Vm]8mm\u0016\u0014\bCA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0015)H/\u001b7t\u0015\t\u0019C\"\u0001\u0004d_6lwN\\\u0005\u0003K\u0001\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u00111\u0004A\u0001\be\u0016\u001cx\u000e\u001c<f)\rYch\u0010\t\u0005YE\u001a4'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u00121!T1q!\t!4H\u0004\u00026sA\u0011aGF\u0007\u0002o)\u0011\u0001HE\u0001\u0007yI|w\u000e\u001e \n\u0005i2\u0012A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!A\u000f\f\t\u000b\u001d\u0011\u0001\u0019A\u0016\t\u000b\u0001\u0013\u0001\u0019A!\u0002\u000f\r|g\u000e^3yiB\u0011!\tS\u0007\u0002\u0007*\u0011A)R\u0001\tGJ,\u0017\r^5p]*\u00111E\u0012\u0006\u0003\u000f2\t!\"\u001a8hS:,7m\u001c8o\u0013\tI5IA\u000bF]\u001eLg.Z\"sK\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0015\rd\u0017.\u001a8u\u0007\u0006dG\u000eF\u0002M!J\u0003B\u0001L\u00194\u001bB\u0011QCT\u0005\u0003\u001fZ\u00111!\u00118z\u0011\u0015\t6\u00011\u00014\u0003)!\u0017\r^1T_V\u00148-\u001a\u0005\u0006'\u000e\u0001\raM\u0001\u0005kN,'/A\u0004sa\u000e\u001c\u0015\r\u001c7\u0015\u0005Y{\u0006CA,^\u001b\u0005A&BA-[\u0003!\u0001(o\u001c;pG>d'BA\u0012\\\u0015\taF\"A\teCR\f7o\\;sG\u0016l\u0017M\\1hKJL!A\u0018-\u0003\u001d\u0011\u001b\u0018J\u001c4p%\u0016\u001c\bo\u001c8tK\")\u0001\r\u0002a\u0001g\u0005qA-\u0019;b'>,(oY3OC6,\u0007")
public class SqoopDataSourceParamsResolver
implements SqoopParamsResolver,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SqoopDataSourceParamsResolver sqoopDataSourceParamsResolver = this;
        synchronized (sqoopDataSourceParamsResolver) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Map<String, String> resolve(Map<String, String> params, EngineCreationContext context) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invoke resolver: ").append(this.getClass().getSimpleName()).toString());
        Option$.MODULE$.apply((Object)params.get(SqoopParamsConfiguration$.MODULE$.SQOOP_PARAM_DATA_SOURCE().getValue())).foreach((Function1 & Serializable & scala.Serializable)dataSourceName -> {
            SqoopDataSourceParamsResolver.$anonfun$resolve$2(this, params, dataSourceName);
            return BoxedUnit.UNIT;
        });
        return params;
    }

    public Map<String, Object> clientCall(String dataSource, String user) {
        RemoteClientHolder clientHolder = new RemoteClientHolder(user, "sqoop");
        DataSourceRemoteClient client = clientHolder.getDataSourceClient();
        GetConnectParamsByDataSourceNameResult getConnectParamsByDataSourceNameResult = (GetConnectParamsByDataSourceNameResult)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            GetConnectParamsByDataSourceNameResult result = null;
            try {
                GetConnectParamsByDataSourceNameAction action = GetConnectParamsByDataSourceNameAction$.MODULE$.builder().setDataSourceName(dataSource).setSystem("sqoop").setUser(user).build();
                result = (GetConnectParamsByDataSourceNameResult)clientHolder.executeDataSource((Action)action);
            }
            catch (Exception e) {
                throw new DataSourceRpcErrorException("Unable to access to the data source server in client", e);
            }
            return result;
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> client.close());
        if (getConnectParamsByDataSourceNameResult != null) {
            GetConnectParamsByDataSourceNameResult getConnectParamsByDataSourceNameResult2 = getConnectParamsByDataSourceNameResult;
            return getConnectParamsByDataSourceNameResult2.connectParams();
        }
        throw new DataSourceRpcErrorException("Empty response from data source server in client", null);
    }

    public DsInfoResponse rpcCall(String dataSourceName) {
        Sender sender = Sender$.MODULE$.getSender((String)SqoopEnvConfiguration$.MODULE$.LINKIS_DATASOURCE_SERVICE_NAME().getValue());
        Object rpcResult = null;
        try {
            rpcResult = sender.ask((Object)new DsInfoQueryRequest(null, dataSourceName, "sqoop"));
        }
        catch (Exception e) {
            throw new DataSourceRpcErrorException(new StringBuilder(40).append("Send rpc to data source service [").append(SqoopEnvConfiguration$.MODULE$.LINKIS_DATASOURCE_SERVICE_NAME().getValue()).append("] error").toString(), e);
        }
        Object object = rpcResult;
        if (object instanceof DsInfoResponse) {
            DsInfoResponse dsInfoResponse = (DsInfoResponse)object;
            if (!Predef$.MODULE$.Boolean2boolean(dsInfoResponse.status())) {
                throw new DataSourceRpcErrorException("Exception happened in data source manager server, please check the log in instance", null);
            }
            String dsType = dsInfoResponse.dsType();
            if (StringUtils.isBlank((CharSequence)dsType)) {
                throw new DataSourceRpcErrorException(new StringBuilder(50).append("Data source type cannot be null for [").append(dataSourceName).append("], creator:[").append(dsInfoResponse.creator()).append("]").toString(), null);
            }
            return dsInfoResponse;
        }
        return null;
    }

    public static final /* synthetic */ void $anonfun$resolve$3(SqoopDataSourceParamsResolver $this, Map params$1, String dataSourceName$1, DsInfoResponse response) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.params()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String paramKey = (String)tuple2._1();
                Object paramValue = tuple2._2();
                return params$1.put(new StringBuilder(0).append(SqoopParamsConfiguration$.MODULE$.SQOOP_PARAM_PREFIX().getValue()).append(paramKey).toString(), String.valueOf(Option$.MODULE$.apply(paramValue).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
            }
            return BoxedUnit.UNIT;
        });
        if (response.params().isEmpty()) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append(" Note: params from data source [").append(dataSourceName$1).append("] is empty, have you published it ?").toString());
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Fetch ").append(response.params().size()).append(" params from data source [").append(dataSourceName$1).append("]").toString());
    }

    public static final /* synthetic */ void $anonfun$resolve$2(SqoopDataSourceParamsResolver $this, Map params$1, String dataSourceName) {
        Option$.MODULE$.apply((Object)$this.rpcCall(dataSourceName)).foreach((Function1 & Serializable & scala.Serializable)response -> {
            SqoopDataSourceParamsResolver.$anonfun$resolve$3($this, params$1, dataSourceName, response);
            return BoxedUnit.UNIT;
        });
    }

    public SqoopDataSourceParamsResolver() {
        Logging.$init$((Logging)this);
    }
}

