/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.service.strategy;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.spark.datacalc.service.strategy.DataSourceStrategy;

public class SqlServerStrategy
extends DataSourceStrategy {
    @Override
    public String getJdbcUrl(String address, Map<String, String> paramsJson, String paramsStr) {
        String databaseName = paramsJson.getOrDefault("databaseName", "");
        String instanceName = paramsJson.getOrDefault("instance", "");
        StringBuilder builder = new StringBuilder("jdbc:sqlserver://");
        if (StringUtils.isNotBlank((CharSequence)address)) {
            builder.append(address);
        }
        if (StringUtils.isNotBlank((CharSequence)instanceName)) {
            builder.append(";instanceName=").append(instanceName);
        }
        if (StringUtils.isNotBlank((CharSequence)databaseName)) {
            builder.append(";databaseName=").append(databaseName);
        }
        if (!paramsStr.isEmpty()) {
            builder.append(this.getConnectParams(paramsStr));
        }
        return builder.toString();
    }

    @Override
    public String defaultDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String defaultPort() {
        return "1433";
    }

    @Override
    protected String getParamsStartCharacter() {
        return ";";
    }

    @Override
    protected String getParamsSplitCharacter() {
        return ";";
    }
}

