/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.repl.executor;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.LinkOption;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.repl.errorcode.ReplErrorCodeSummary;
import org.apache.linkis.engineplugin.repl.exception.ReplException;
import org.apache.linkis.engineplugin.repl.executor.ReplAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.ILoop;

public class ScalaReplAdapter
extends ReplAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ScalaReplAdapter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executorCode(String code, String classpathDir, String methodName) {
        block5: {
            StringReader stringReader = new StringReader(code);
            StringWriter stringWriter = new StringWriter();
            ILoop repl = new ILoop(new BufferedReader(stringReader), new PrintWriter(stringWriter));
            try {
                logger.info("Scala repl start executor");
                Settings settings = new Settings();
                settings.usejavacp().tryToSetFromPropertyValue("true");
                if (StringUtils.isNotBlank((CharSequence)classpathDir) && FileUtils.isDirectory((File)new File(classpathDir), (LinkOption[])new LinkOption[0])) {
                    settings.classpath().value_$eq((Object)classpathDir);
                }
                boolean process = repl.process(settings);
                String scalaReplLog = stringWriter.toString();
                logger.info("Scala repl log: {}", (Object)scalaReplLog);
                if (process) {
                    logger.info("Scala repl executor success");
                    break block5;
                }
                logger.error("Scala repl executor failed");
                throw new ReplException(ReplErrorCodeSummary.REPL_SCALA_TASK_EXECUTOR_FAILED.getErrorCode(), ReplErrorCodeSummary.REPL_SCALA_TASK_EXECUTOR_FAILED.getErrorDesc());
            }
            finally {
                repl.closeInterpreter();
            }
        }
    }
}

