/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.repl.executor;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.repl.conf.ReplType;
import org.apache.linkis.engineplugin.repl.errorcode.ReplErrorCodeSummary;
import org.apache.linkis.engineplugin.repl.exception.ReplException;
import org.apache.linkis.engineplugin.repl.executor.JavaReplAdapter;
import org.apache.linkis.engineplugin.repl.executor.ReplAdapter;
import org.apache.linkis.engineplugin.repl.executor.ScalaReplAdapter;

public class ReplAdapterFactory {
    public static ReplAdapter create(String replType) {
        if (StringUtils.isBlank((CharSequence)replType) || !ReplType.isSupportReplType(replType)) {
            throw new ReplException(ReplErrorCodeSummary.NOT_SUPPORT_REPL_TYPE.getErrorCode(), ReplErrorCodeSummary.NOT_SUPPORT_REPL_TYPE.getErrorDesc());
        }
        ReplAdapter replAdapter = null;
        if ("java".equalsIgnoreCase(replType)) {
            replAdapter = new JavaReplAdapter();
        } else if ("scala".equalsIgnoreCase(replType)) {
            replAdapter = new ScalaReplAdapter();
        }
        return replAdapter;
    }
}

