/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.monitor.impl;

import io.trino.jdbc.QueryStats;
import io.trino.jdbc.TrinoStatement;
import java.sql.Statement;
import java.util.function.Consumer;
import org.apache.linkis.manager.engineplugin.jdbc.monitor.ProgressMonitor;
import org.apache.linkis.protocol.engine.JobProgressInfo;

public class TrinoProgressMonitor
extends ProgressMonitor<QueryStats> {
    private volatile Runnable callback;
    private volatile double sqlProgress = 0.0;
    private volatile int completedSplits = 0;
    private volatile int totalSplits = 0;
    private volatile int runningSplits = 0;

    @Override
    public void accept(QueryStats stats) {
        this.sqlProgress = stats.getProgressPercentage().orElse(0.0) / 100.0;
        this.completedSplits = stats.getCompletedSplits();
        this.totalSplits = stats.getTotalSplits();
        this.runningSplits = stats.getRunningSplits();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    @Override
    public void attach(Statement statement) {
        if (statement instanceof TrinoStatement) {
            ((TrinoStatement)statement).setProgressMonitor((Consumer)this);
        }
    }

    @Override
    public void callback(Runnable callback) {
        this.callback = callback;
    }

    @Override
    public float getSqlProgress() {
        return Double.valueOf(this.sqlProgress).floatValue();
    }

    @Override
    public int getSucceedTasks() {
        return this.completedSplits;
    }

    @Override
    public int getTotalTasks() {
        return this.totalSplits;
    }

    @Override
    public int getRunningTasks() {
        return this.runningSplits;
    }

    @Override
    public int getFailedTasks() {
        return 0;
    }

    @Override
    public JobProgressInfo jobProgressInfo(String id) {
        return new JobProgressInfo(id, this.totalSplits, this.runningSplits, 0, this.completedSplits);
    }
}

