/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.executor;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.engineplugin.jdbc.conf.JDBCConfiguration$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JDBCSQLCodeParser$ {
    public static JDBCSQLCodeParser$ MODULE$;
    private final String separator;
    private final int defaultLimit;

    static {
        new JDBCSQLCodeParser$();
    }

    public String separator() {
        return this.separator;
    }

    public int defaultLimit() {
        return this.defaultLimit;
    }

    public String[] parse(String code) {
        ArrayBuffer codeBuffer = new ArrayBuffer();
        if (StringUtils.contains((CharSequence)code, (CharSequence)this.separator())) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])StringUtils.split((String)code, (String)";"))).foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                JDBCSQLCodeParser$.$anonfun$parse$1(codeBuffer, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            String string = code;
            if (StringUtils.isBlank((CharSequence)string)) {
            } else if (this.isSelectCmdNoLimit(string)) {
                JDBCSQLCodeParser$.appendStatement$1(new StringBuilder(7).append(string).append(" limit ").append(this.defaultLimit()).toString(), codeBuffer);
            } else {
                JDBCSQLCodeParser$.appendStatement$1(string, codeBuffer);
            }
        }
        return (String[])codeBuffer.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean isSelectCmdNoLimit(String cmd) {
        int limitNum;
        String code = cmd.trim();
        if (!cmd.split("\\s+")[0].equalsIgnoreCase("select")) {
            return false;
        }
        if (code.contains("limit")) {
            code = code.substring(code.lastIndexOf("limit")).trim();
        } else if (code.contains("LIMIT")) {
            code = code.substring(code.lastIndexOf("LIMIT")).trim().toLowerCase(Locale.getDefault());
        } else {
            return true;
        }
        boolean hasLimit = code.matches("limit\\s+\\d+\\s*;?");
        if (hasLimit && (limitNum = new StringOps(Predef$.MODULE$.augmentString(code = code.indexOf(";") > 0 ? code.substring(5, code.length() - 1).trim() : code.substring(5).trim())).toInt()) > this.defaultLimit()) {
            throw new IllegalArgumentException(new StringBuilder(70).append("We at most allowed to limit ").append(this.defaultLimit()).append(", but your SQL has been over the max rows.").toString());
        }
        return !hasLimit;
    }

    private static final void appendStatement$1(String sqlStatement, ArrayBuffer codeBuffer$1) {
        codeBuffer$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sqlStatement}));
    }

    public static final /* synthetic */ void $anonfun$parse$1(ArrayBuffer codeBuffer$1, String x0$1) {
        String string = x0$1;
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        if (MODULE$.isSelectCmdNoLimit(string)) {
            JDBCSQLCodeParser$.appendStatement$1(new StringBuilder(7).append(string).append(" limit ").append(MODULE$.defaultLimit()).toString(), codeBuffer$1);
            return;
        }
        JDBCSQLCodeParser$.appendStatement$1(string, codeBuffer$1);
    }

    private JDBCSQLCodeParser$() {
        MODULE$ = this;
        this.separator = ";";
        this.defaultLimit = BoxesRunTime.unboxToInt((Object)JDBCConfiguration$.MODULE$.ENGINE_DEFAULT_LIMIT().getValue());
    }
}

