/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCDataSourceConfigurations {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCDataSourceConfigurations.class);
    private final Map<String, Statement> taskIdStatementMap = new ConcurrentHashMap<String, Statement>();

    public void initTaskIdStatementMap() throws SQLException {
        for (Statement statement : this.taskIdStatementMap.values()) {
            if (statement == null || statement.isClosed()) continue;
            statement.close();
        }
        this.taskIdStatementMap.clear();
        LOG.info("The jdbc task statement map has be cleared successfully!");
    }

    public void saveStatement(String taskId, Statement statement) {
        this.taskIdStatementMap.put(taskId, statement);
    }

    public void cancelStatement(String taskId) throws SQLException {
        LOG.info("Starting to cancel the statement of task {} ...", (Object)taskId);
        Statement statement = this.taskIdStatementMap.get(taskId);
        if (statement != null) {
            statement.cancel();
        }
        LOG.info("Finished cancel the statement of task {}.", (Object)taskId);
    }

    public void removeStatement(String taskId) {
        this.taskIdStatementMap.remove(taskId);
        LOG.info("Finished remove the statement of task {}", (Object)taskId);
    }
}

