/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.doris.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisUtils {
    private static final Logger logger = LoggerFactory.getLogger(DorisUtils.class);
    private static final String JDBC_URL = "jdbc:mysql://%s:%s/%s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDorisCloumns(String host, Integer port, String username, String password, String database, String table) {
        String url = String.format(JDBC_URL, host, port, database);
        Connection connecion = DorisUtils.getConnecion(username, password, url);
        if (connecion == null) {
            return Collections.emptyList();
        }
        String columnSql = "SELECT * FROM `" + database + "`.`" + table + "` WHERE 1 = 2";
        PreparedStatement ps = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        ArrayList<String> columns = new ArrayList<String>();
        try {
            ps = connecion.prepareStatement(columnSql);
            rs = ps.executeQuery();
            meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                columns.add(meta.getColumnName(i));
            }
        }
        catch (SQLException e) {
            ArrayList<String> arrayList;
            try {
                logger.error("getDorisCloumns failed", (Throwable)e);
                arrayList = columns;
            }
            catch (Throwable throwable) {
                DorisUtils.closeResource(connecion, ps, rs);
                throw throwable;
            }
            DorisUtils.closeResource(connecion, ps, rs);
            return arrayList;
        }
        DorisUtils.closeResource(connecion, ps, rs);
        return columns;
    }

    public static void closeResource(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (null != resultSet && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (null != statement && !statement.isClosed()) {
                statement.close();
            }
            if (null != connection && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Fail to release resource [" + e.getMessage() + "]", (Throwable)e);
        }
    }

    private static Connection getConnecion(String username, String password, String url) {
        Connection connection = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException ex) {
                logger.warn("The mysql driver does not exist, mysql driver is used to fetch the table column. If you need to use this feature, you need to place the mysql jar into the doris ec lib.  ClassNotFoundException: {}", (Object)ex.getMessage());
                return connection;
            }
        }
        try {
            connection = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            logger.warn("getConnecion failed,please check whether the connection parameters are correct.", (Throwable)e);
        }
        return connection;
    }
}

