/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.doris.executor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.log.LogUtils;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.common.utils.OverloadUtils;
import org.apache.linkis.engineconn.computation.executor.entity.EngineConnTask;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject;
import org.apache.linkis.engineplugin.doris.conf.DorisConfiguration;
import org.apache.linkis.engineplugin.doris.conf.DorisEngineConf;
import org.apache.linkis.engineplugin.doris.constant.DorisConstant;
import org.apache.linkis.engineplugin.doris.errorcode.DorisErrorCodeSummary;
import org.apache.linkis.engineplugin.doris.exception.DorisException;
import org.apache.linkis.engineplugin.doris.exception.DorisParameterException;
import org.apache.linkis.engineplugin.doris.exception.DorisStreamLoadFileException;
import org.apache.linkis.engineplugin.doris.executor.DorisDatasourceParser;
import org.apache.linkis.engineplugin.doris.util.DorisUtils;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import scala.Tuple2;

public class DorisEngineConnExecutor
extends ConcurrentComputationExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DorisEngineConnExecutor.class);
    private int id;
    private List<Label<?>> executorLabels = new ArrayList(2);
    private Map<String, Thread> threadCache = new ConcurrentHashMap<String, Thread>();
    private Map<String, String> configMap = new HashMap<String, String>();
    private static final String DORIS_LABEL_PREFIX = "linkis_doris_";
    public static final String DORIS_URL_BOOTSTRAP = "http://%s:%s/api/bootstrap";
    public static final String DORIS_URL_STREAM_LOAD = "http://%s:%s/api/%s/%s/_stream_load";
    public static final String DORIS_URL_STREAM_LOAD_2PC = "http://%s:%s/api/%s/%s/_stream_load_2pc";
    private String dorisHost;
    private String dorisDatabase;
    private String datasourceDatabase;
    private String dorisTable;
    private String dorisUsername;
    private String dorisPassword;
    private String dorisStreamLoadFilePath;
    private Integer dorisHttpPort;
    private Integer dorisJdbcPort;
    private CloseableHttpClient client;

    public DorisEngineConnExecutor(int outputPrintLimit, int id) {
        super(outputPrintLimit);
        this.id = id;
    }

    public void init() {
        super.init();
    }

    public ExecuteResponse execute(EngineConnTask engineConnTask) {
        Map taskParams;
        EngineTypeLabel engineTypeLabel;
        UserCreatorLabel userCreatorLabel;
        Map cacheMap;
        Optional<Label> userCreatorLabelOp = Arrays.stream(engineConnTask.getLables()).filter(label -> label instanceof UserCreatorLabel).findFirst();
        Optional<Label> engineTypeLabelOp = Arrays.stream(engineConnTask.getLables()).filter(label -> label instanceof EngineTypeLabel).findFirst();
        if (userCreatorLabelOp.isPresent() && engineTypeLabelOp.isPresent() && org.apache.commons.collections4.MapUtils.isNotEmpty((Map)(cacheMap = new DorisEngineConf().getCacheMap(new Tuple2((Object)(userCreatorLabel = (UserCreatorLabel)userCreatorLabelOp.get()), (Object)(engineTypeLabel = (EngineTypeLabel)engineTypeLabelOp.get())))))) {
            this.configMap.putAll(cacheMap);
        }
        if (org.apache.commons.collections4.MapUtils.isNotEmpty((Map)(taskParams = engineConnTask.getProperties()))) {
            taskParams.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> this.configMap.put((String)entry.getKey(), String.valueOf(entry.getValue())));
        }
        this.client = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            protected boolean isRedirectable(String method) {
                return true;
            }
        }).build();
        return super.execute(engineConnTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        this.checkParameter(engineExecutorContext);
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new DorisException(DorisErrorCodeSummary.DORIS_CODE_IS_NOT_BLANK.getErrorCode(), DorisErrorCodeSummary.DORIS_CODE_IS_NOT_BLANK.getErrorDesc());
        }
        String realCode = code.trim();
        logger.info("Doris engine begins to run code:\n {}", (Object)realCode);
        this.checkRequiredParameter(realCode);
        String testConnectionUrl = String.format(DORIS_URL_BOOTSTRAP, this.dorisHost, this.dorisHttpPort);
        if (!this.testConnection(testConnectionUrl)) {
            logger.error("Test connection failed: {}", (Object)testConnectionUrl);
            throw new DorisException(DorisErrorCodeSummary.DORIS_TEST_CONNECTION_FAILED.getErrorCode(), DorisErrorCodeSummary.DORIS_TEST_CONNECTION_FAILED.getErrorDesc());
        }
        String taskId = (String)engineExecutorContext.getJobId().get();
        this.initialStatusUpdates(taskId, engineExecutorContext);
        this.threadCache.put(taskId, Thread.currentThread());
        CloseableHttpResponse response = null;
        Boolean executeResponse = false;
        try {
            response = this.streamLoad(engineExecutorContext);
        }
        catch (Exception e) {
            String errorMessage = ExceptionUtils.getStackTrace((Throwable)e);
            logger.error("Doris engine execute failed : {}", (Object)errorMessage);
            engineExecutorContext.appendStdout(LogUtils.generateERROR((String)errorMessage));
            return new ErrorExecuteResponse(errorMessage, null);
        }
        String resultMessage = DorisEngineConnExecutor.entitytoString(response);
        StringBuilder resultMessageStringBuilder = new StringBuilder();
        resultMessageStringBuilder.append(resultMessage);
        logger.info("Doris stream load execution result: {}", (Object)resultMessage);
        Map<String, String> resultMap = this.responseToMap(resultMessage);
        int statusCode = response.getStatusLine().getStatusCode();
        Boolean enabled2PC = (Boolean)DorisConfiguration.DORIS_RECONNECT_ENABLED.getValue(this.configMap);
        if (statusCode == DorisConstant.HTTP_SUCCEED && this.isSuccess(resultMap)) {
            executeResponse = true;
            if (enabled2PC.booleanValue() && resultMap.containsKey("TxnId")) {
                String commitMessage = "doris begin commit";
                logger.info(commitMessage);
                engineExecutorContext.appendStdout(commitMessage);
                executeResponse = this.dorisCommitOrAbort(resultMap.get("TxnId"), "commit", resultMessageStringBuilder);
            }
        } else {
            executeResponse = false;
            if (enabled2PC.booleanValue() && resultMap.containsKey("TxnId")) {
                String abortMessage = "doris stream load failed, begin abort";
                logger.error(abortMessage);
                engineExecutorContext.appendStdout(abortMessage);
                this.dorisCommitOrAbort(resultMap.get("TxnId"), "abort", resultMessageStringBuilder);
            }
        }
        engineExecutorContext.appendStdout(resultMessageStringBuilder.toString());
        ResultSetWriter resultSetWriter = engineExecutorContext.createResultSetWriter(ResultSetFactory$.MODULE$.TEXT_TYPE());
        try {
            resultSetWriter.addMetaData((MetaData)new LineMetaData(null));
            resultSetWriter.addRecord((Record)new LineRecord(resultMessageStringBuilder.toString()));
        }
        catch (IOException e) {
            logger.error("Failed to get the task result");
        }
        finally {
            IOUtils.closeQuietly((Closeable)resultSetWriter);
        }
        if (executeResponse.booleanValue()) {
            return new SuccessExecuteResponse();
        }
        return new ErrorExecuteResponse(resultMessageStringBuilder.toString(), null);
    }

    private CloseableHttpResponse streamLoad(EngineExecutionContext engineExecutorContext) throws Exception {
        String dorisLabel;
        List<String> dorisCloumns;
        String loadUrl = String.format(DORIS_URL_STREAM_LOAD, this.dorisHost, this.dorisHttpPort, this.dorisDatabase, this.dorisTable);
        logger.info("Doris engine stream load begins to run loadUrl:\n {}", (Object)loadUrl);
        engineExecutorContext.appendStdout(String.format("Doris engine stream load begins to run loadUrl:\n %s", loadUrl));
        HttpPut httpPut = new HttpPut(loadUrl);
        String dorisConf = (String)DorisConfiguration.DORIS_CONF.getValue(this.configMap);
        if (StringUtils.isNotBlank((CharSequence)dorisConf)) {
            String[] confs;
            for (String conf : confs = dorisConf.split(",")) {
                String[] keyValue = conf.split(":");
                if (keyValue.length != 2) continue;
                String key = keyValue[0];
                String value = keyValue[1];
                httpPut.setHeader(key, value);
                logger.info("doris set param {} : {}", (Object)key, (Object)value);
            }
        }
        this.addCommonHeader(httpPut);
        String dorisColumns = (String)DorisConfiguration.DORIS_COLUMNS.getValue(this.configMap);
        if (StringUtils.isBlank((CharSequence)dorisColumns) && org.apache.commons.collections.CollectionUtils.isNotEmpty(dorisCloumns = DorisUtils.getDorisCloumns(this.dorisHost, this.dorisJdbcPort, this.dorisUsername, this.dorisPassword, this.dorisDatabase, this.dorisTable))) {
            dorisColumns = String.join((CharSequence)",", dorisCloumns.stream().map(f -> String.format("`%s`", f)).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)dorisColumns)) {
            httpPut.setHeader("columns", dorisColumns);
            logger.info("doris set param {} : {}", (Object)"columns", (Object)dorisColumns);
        }
        if (StringUtils.isBlank((CharSequence)(dorisLabel = (String)DorisConfiguration.DORIS_LABEL.getValue(this.configMap)))) {
            dorisLabel = DORIS_LABEL_PREFIX + UUID.randomUUID();
        }
        httpPut.setHeader("label", dorisLabel);
        logger.info("doris set param {} : {}", (Object)"label", (Object)dorisLabel);
        File dorisStreamLoadFile = new File(this.dorisStreamLoadFilePath);
        if (!dorisStreamLoadFile.isFile()) {
            throw new DorisStreamLoadFileException(DorisErrorCodeSummary.DORIS_STREAM_LOAD_FILE_PATH_NOT_FILE.getErrorCode(), DorisErrorCodeSummary.DORIS_STREAM_LOAD_FILE_PATH_NOT_FILE.getErrorDesc());
        }
        String fileExtension = FilenameUtils.getExtension((String)this.dorisStreamLoadFilePath);
        if (!this.isSupportedType(fileExtension)) {
            logger.error("The supported types are csv, json, parquet, and orc,This file type is not currently supported: {}", (Object)fileExtension);
            throw new DorisStreamLoadFileException(DorisErrorCodeSummary.DORIS_STREAM_LOAD_FILE_PATH_NOT_SUPPORTED_TYPE_FILE.getErrorCode(), DorisErrorCodeSummary.DORIS_STREAM_LOAD_FILE_PATH_NOT_SUPPORTED_TYPE_FILE.getErrorDesc());
        }
        httpPut.setHeader("format", fileExtension);
        Boolean enabled2PC = (Boolean)DorisConfiguration.DORIS_RECONNECT_ENABLED.getValue(this.configMap);
        httpPut.setHeader("two_phase_commit", String.valueOf(enabled2PC));
        logger.info("doris set param {} : {}", (Object)"two_phase_commit", (Object)enabled2PC);
        if (fileExtension.equals("json")) {
            Boolean stripOuterArray = (Boolean)DorisConfiguration.DORIS_STRIP_OUTER_ARRAY.getValue(this.configMap);
            httpPut.setHeader("strip_outer_array", String.valueOf(stripOuterArray));
            logger.info("doris set param {} : {}", (Object)"strip_outer_array", (Object)stripOuterArray);
        }
        String dorisColumnSeparator = (String)DorisConfiguration.DORIS_COLUMN_SEPARATOR.getValue(this.configMap);
        httpPut.setHeader("column_separator", dorisColumnSeparator);
        logger.info("doris set param {} : {}", (Object)"column_separator", (Object)dorisColumnSeparator);
        String dorisLineDelimiter = (String)DorisConfiguration.DORIS_LINE_DELIMITER.getValue(this.configMap);
        httpPut.setHeader("line_delimiter", dorisLineDelimiter);
        logger.info("doris set param {} : {}", (Object)"line_delimiter", (Object)dorisLineDelimiter);
        FileEntity entity = new FileEntity(dorisStreamLoadFile);
        httpPut.setEntity((HttpEntity)entity);
        engineExecutorContext.appendStdout(String.format("doris stread load file path: %s", dorisStreamLoadFile.getAbsolutePath()));
        String allHeaders = Arrays.toString(httpPut.getAllHeaders());
        logger.info("doris param: {}", (Object)allHeaders);
        engineExecutorContext.appendStdout(String.format("doris param: %s", allHeaders));
        return this.client.execute((HttpUriRequest)httpPut);
    }

    private boolean isSupportedType(String fileExtension) {
        if (StringUtils.isBlank((CharSequence)fileExtension)) {
            return false;
        }
        return fileExtension.equals("csv") || fileExtension.equals("json") || fileExtension.equals("parquet") || fileExtension.equals("orc");
    }

    private void checkParameter(EngineExecutionContext engineExecutorContext) {
        this.dorisHost = (String)DorisConfiguration.DORIS_HOST.getValue(this.configMap);
        this.dorisUsername = (String)DorisConfiguration.DORIS_USER_NAME.getValue(this.configMap);
        this.dorisHttpPort = (Integer)DorisConfiguration.DORIS_HTTP_PORT.getValue(this.configMap);
        this.dorisPassword = (String)DorisConfiguration.DORIS_PASSWORD.getValue(this.configMap);
        this.dorisJdbcPort = (Integer)DorisConfiguration.DORIS_JDBC_PORT.getValue(this.configMap);
        String dorisDatasourceName = (String)DorisConfiguration.DORIS_DATASOURCE.getValue(this.configMap);
        try {
            if (StringUtils.isNotBlank((CharSequence)dorisDatasourceName)) {
                String dorisSystemQueryParam = (String)DorisConfiguration.DORIS_DATASOURCE_SYSTEM_QUERY_PARAM.getValue(this.configMap);
                String execSqlUser = this.getExecSqlUser(engineExecutorContext);
                Map<String, String> dataSourceParamMap = DorisDatasourceParser.queryDatasourceInfoByName(dorisDatasourceName, execSqlUser, dorisSystemQueryParam);
                if (org.apache.commons.collections4.MapUtils.isNotEmpty(dataSourceParamMap)) {
                    if (dataSourceParamMap.containsKey("host") && StringUtils.isNotBlank((CharSequence)dataSourceParamMap.get("host"))) {
                        this.dorisHost = dataSourceParamMap.get("host");
                    }
                    if (dataSourceParamMap.containsKey("username") && StringUtils.isNotBlank((CharSequence)dataSourceParamMap.get("username"))) {
                        this.dorisUsername = dataSourceParamMap.get("username");
                    }
                    if (dataSourceParamMap.containsKey("password")) {
                        this.dorisPassword = dataSourceParamMap.get("password");
                    }
                    if (dataSourceParamMap.containsKey("port") && StringUtils.isNotBlank((CharSequence)dataSourceParamMap.get("port"))) {
                        this.dorisJdbcPort = Integer.valueOf(dataSourceParamMap.get("port"));
                    }
                    if (dataSourceParamMap.containsKey("databaseName") && StringUtils.isNotBlank((CharSequence)dataSourceParamMap.get("databaseName"))) {
                        this.datasourceDatabase = dataSourceParamMap.get("databaseName");
                    }
                } else {
                    logger.warn("Doris dataSource {} param is null, Skip get doris dataSource parameters", (Object)dorisDatasourceName);
                }
            }
        }
        catch (Exception e) {
            logger.error("get doris dataSource {} param failed", (Object)dorisDatasourceName, (Object)e);
        }
        if (StringUtils.isBlank((CharSequence)this.dorisHost) || StringUtils.isBlank((CharSequence)this.dorisUsername) || this.dorisHttpPort == null) {
            logger.error("Doris check param failed.");
            throw new DorisParameterException(DorisErrorCodeSummary.CHECK_DORIS_PARAMETER_FAILED.getErrorCode(), DorisErrorCodeSummary.CHECK_DORIS_PARAMETER_FAILED.getErrorDesc());
        }
        logger.info("Doris parameter dorisHost: {}, dorisUsername: {}, dorisPassword: {}, dorisHttpPort: {}, dorisJdbcPort: {}.", new Object[]{this.dorisHost, this.dorisUsername, "******", this.dorisHttpPort, this.dorisJdbcPort});
    }

    private String getExecSqlUser(EngineExecutionContext engineExecutionContext) {
        UserCreatorLabel userCreatorLabel = Arrays.stream(engineExecutionContext.getLabels()).filter(label -> label instanceof UserCreatorLabel).findFirst().orElse(null);
        if (userCreatorLabel != null) {
            return userCreatorLabel.getUser();
        }
        return null;
    }

    private void checkRequiredParameter(String code) {
        Map codeMap = new HashMap();
        try {
            codeMap = (Map)JsonUtils.jackson().readValue(code, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            throw new DorisException(DorisErrorCodeSummary.DORIS_CODE_FAILED_TO_CONVERT_JSON.getErrorCode(), DorisErrorCodeSummary.DORIS_CODE_FAILED_TO_CONVERT_JSON.getErrorDesc());
        }
        this.dorisStreamLoadFilePath = codeMap.getOrDefault(DorisConfiguration.DORIS_STREAM_LOAD_FILE_PATH.key(), "");
        this.dorisTable = codeMap.getOrDefault(DorisConfiguration.DORIS_TABLE.key(), "");
        this.dorisDatabase = codeMap.getOrDefault(DorisConfiguration.DORIS_DATABASE.key(), "");
        String dorisDatasourceName = (String)DorisConfiguration.DORIS_DATASOURCE.getValue(this.configMap);
        if (StringUtils.isNotBlank((CharSequence)dorisDatasourceName) && StringUtils.isNotBlank((CharSequence)this.datasourceDatabase)) {
            this.dorisDatabase = this.datasourceDatabase;
        }
        if (StringUtils.isBlank((CharSequence)this.dorisStreamLoadFilePath) || StringUtils.isBlank((CharSequence)this.dorisDatabase) || StringUtils.isBlank((CharSequence)this.dorisTable)) {
            logger.error("Check whether `{}`, `{}`, and `{}` are included in code json", new Object[]{DorisConfiguration.DORIS_STREAM_LOAD_FILE_PATH.key(), DorisConfiguration.DORIS_DATABASE.key(), DorisConfiguration.DORIS_TABLE.key()});
            throw new DorisException(DorisErrorCodeSummary.DORIS_REQUIRED_PARAMETER_IS_NOT_BLANK.getErrorCode(), DorisErrorCodeSummary.DORIS_REQUIRED_PARAMETER_IS_NOT_BLANK.getErrorDesc());
        }
        logger.info("Doris parameter dorisStreamLoadFilePath: {}, dorisDatabase: {}, dorisTable: {}.", new Object[]{this.dorisStreamLoadFilePath, this.dorisDatabase, this.dorisTable});
    }

    private boolean isSuccess(Map<String, String> map) {
        if (MapUtils.isEmpty(map)) {
            return false;
        }
        if (map.containsKey("Status") && map.get("Status").equalsIgnoreCase("Success")) {
            return true;
        }
        return map.containsKey("Status".toLowerCase()) && map.get("Status".toLowerCase()).equalsIgnoreCase("Success");
    }

    private boolean dorisCommitOrAbort(String id, String type, StringBuilder resultMessageStringBuilder) {
        String load2PCUrl = String.format(DORIS_URL_STREAM_LOAD_2PC, this.dorisHost, this.dorisHttpPort, this.dorisDatabase, this.dorisTable);
        HttpPut commmitHttpPut = new HttpPut(load2PCUrl);
        this.addCommonHeader(commmitHttpPut);
        commmitHttpPut.setHeader("txn_id", id);
        commmitHttpPut.setHeader("txn_operation", type);
        CloseableHttpResponse commmitResponse = null;
        try {
            commmitResponse = this.client.execute((HttpUriRequest)commmitHttpPut);
        }
        catch (IOException e) {
            logger.error("doris {} failed", (Object)type, (Object)e);
            return false;
        }
        String commmitLoadResult = DorisEngineConnExecutor.entitytoString(commmitResponse);
        logger.info("Doris stream load {} execution result: {}", (Object)type, (Object)commmitLoadResult);
        resultMessageStringBuilder.append("\r\n").append(commmitLoadResult);
        Map<String, String> commmitResultMap = this.responseToMap(commmitLoadResult);
        int statusCode = commmitResponse.getStatusLine().getStatusCode();
        return statusCode == DorisConstant.HTTP_SUCCEED && this.isSuccess(commmitResultMap);
    }

    private static String entitytoString(CloseableHttpResponse response) {
        String loadResult = "";
        if (response.getEntity() != null) {
            try {
                loadResult = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                logger.error("Doris httpResponse entity conversion to string failed", (Throwable)e);
            }
        }
        return loadResult;
    }

    private void addCommonHeader(HttpPut httpPut) {
        if (httpPut == null) {
            return;
        }
        httpPut.setHeader("Expect", "100-continue");
        httpPut.setHeader("Authorization", this.basicAuthHeader(this.dorisUsername, this.dorisPassword));
    }

    private Map<String, String> responseToMap(String response) {
        Map<String, String> resultMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)response)) {
            return resultMap;
        }
        try {
            resultMap = (Map)JsonUtils.jackson().readValue(response, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            logger.error("doris response to map failed", (Throwable)e);
            return resultMap;
        }
        return resultMap;
    }

    private boolean testConnection(String testUrl) {
        try {
            URL url = new URL(testUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == DorisConstant.HTTP_SUCCEED) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String basicAuthHeader(String username, String password) {
        String tobeEncode = username + ":" + password;
        byte[] encoded = Base64.encodeBase64((byte[])tobeEncode.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encoded);
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        return null;
    }

    public float progress(String taskID) {
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        return new JobProgressInfo[0];
    }

    public void killTask(String taskId) {
        Thread thread = this.threadCache.remove(taskId);
        if (null != thread) {
            thread.interrupt();
        }
        super.killTask(taskId);
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels;
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (!CollectionUtils.isEmpty(labels)) {
            this.executorLabels.clear();
            this.executorLabels.addAll(labels);
        }
    }

    public boolean supportCallBackLogs() {
        return false;
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        NodeResourceUtils.appendMemoryUnitIfMissing((Map)EngineConnObject.getEngineCreationContext().getOptions());
        CommonNodeResource resource = new CommonNodeResource();
        LoadResource usedResource = new LoadResource(OverloadUtils.getProcessMaxMemory(), 1);
        resource.setUsedResource((Resource)usedResource);
        return resource;
    }

    public String getId() {
        return Sender.getThisServiceInstance().getInstance() + "_" + this.id;
    }

    public int getConcurrentLimit() {
        return (Integer)DorisConfiguration.ENGINE_CONCURRENT_LIMIT.getValue();
    }

    private void initialStatusUpdates(String taskId, EngineExecutionContext engineExecutorContext) {
        engineExecutorContext.pushProgress(this.progress(taskId), this.getProgressInfo(taskId));
    }

    public void killAll() {
        for (Thread thread : this.threadCache.values()) {
            if (thread == null) continue;
            thread.interrupt();
        }
        this.threadCache.clear();
    }

    public void close() {
        this.killAll();
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            logger.warn("close doris HttpClient failed");
        }
        super.close();
    }
}

