/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.hbase.shell;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.linkis.manager.engineplugin.hbase.HBaseConnectionManager;
import org.apache.linkis.manager.engineplugin.hbase.shell.HBaseShellSession;
import org.apache.linkis.manager.engineplugin.hbase.shell.HBaseShellSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseShellSessionManager {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseShellSessionManager.class);
    private final ConcurrentHashMap<String, HBaseShellSession> shellSessionMap;
    private static volatile HBaseShellSessionManager instance = null;
    private final ReentrantLock lock = new ReentrantLock();

    private HBaseShellSessionManager() {
        this.shellSessionMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HBaseShellSessionManager getInstance() {
        if (instance != null) return instance;
        Class<HBaseShellSessionManager> clazz = HBaseShellSessionManager.class;
        synchronized (HBaseShellSessionManager.class) {
            if (instance != null) return instance;
            instance = new HBaseShellSessionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseShellSession getHBaseShellSession(Map<String, String> prop) {
        String sessionId = HBaseConnectionManager.getInstance().generateUniqueConnectionKey(prop);
        LOG.info("Start to create session {} for cluster.", (Object)sessionId);
        if (this.shellSessionMap.containsKey(sessionId)) {
            return this.shellSessionMap.get(sessionId);
        }
        try {
            this.lock.lock();
            HBaseShellSession shellSession = HBaseShellSession.sessionBuilder().sessionId(sessionId).sessionInitMaxTimes(HBaseShellSessionConfig.maxRetryTimes(prop)).sessionInitRetryInterval(HBaseShellSessionConfig.initRetryInterval(prop)).sessionInitTimeout(HBaseShellSessionConfig.initTimeout(prop)).sessionIdle(HBaseShellSessionConfig.idleTimeMs(prop)).sessionDebugLog(HBaseShellSessionConfig.openDebugLog(prop)).properties(prop).build();
            shellSession.open();
            this.shellSessionMap.put(sessionId, shellSession);
            HBaseShellSession hBaseShellSession = shellSession;
            return hBaseShellSession;
        }
        finally {
            this.lock.unlock();
        }
    }
}

