/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.hbase.errorcode;

import org.apache.linkis.common.errorcode.ErrorCodeUtils;
import org.apache.linkis.common.errorcode.LinkisErrorCode;

public enum HBaseErrorCodeSummary implements LinkisErrorCode
{
    KERBEROS_PRINCIPAL_NOT_NULL(27000, "In the hbase authentication mode of kerberos, the kerberos principal cannot be empty(kerberos\u7684hbase\u8ba4\u8bc1\u65b9\u5f0f\u4e0b\uff0ckerberos principal\u4e0d\u80fd\u4e3a\u7a7a)"),
    KERBEROS_KEYTAB_NOT_NULL(27001, "In the hbase authentication mode of kerberos, the kerberos keytab cannot be empty(kerberos\u7684hbase\u8ba4\u8bc1\u65b9\u5f0f\u4e0b\uff0ckerberos keytab\u4e0d\u80fd\u4e3a\u7a7a)"),
    KERBEROS_KEYTAB_FILE_NOT_EXISTS(27002, "The kerberos keytab file must exists(kerberos keytab\u6587\u4ef6\u5fc5\u987b\u5b58\u5728)"),
    KERBEROS_KEYTAB_NOT_FILE(27003, "The kerberos keytab file must be a file(kerberos keytab\u6587\u4ef6\u5fc5\u987b\u662f\u4e2a\u6587\u4ef6)"),
    KERBEROS_AUTH_FAILED(27004, "kerberos authentication failed(kerberos \u8ba4\u8bc1\u5931\u8d25)"),
    REGION_SERVER_KERBEROS_PRINCIPAL_NOT_NULL(27005, "In the hbase authentication mode of kerberos, the region server kerberos principal cannot be empty(kerberos\u7684hbase\u8ba4\u8bc1\u65b9\u5f0f\u4e0b\uff0cregion server kerberos principal\u4e0d\u80fd\u4e3a\u7a7a)"),
    MASTER_KERBEROS_PRINCIPAL_NOT_NULL(27006, "In the hbase authentication mode of kerberos, the hmaster kerberos principal cannot be empty(kerberos\u7684hbase\u8ba4\u8bc1\u65b9\u5f0f\u4e0b\uff0chmaster kerberos principal\u4e0d\u80fd\u4e3a\u7a7a)"),
    HBASE_CLIENT_CONN_CREATE_FAILED(27007, "HBase client connection failed to be created(HBase\u5ba2\u6237\u7aef\u8fde\u63a5\u521b\u5efa\u5931\u8d25)"),
    HBASE_SHELL_ENV_INIT_FAILED(27008, "HBase shell environment initialization failed(HBase shell\u73af\u5883\u521d\u59cb\u5316\u5931\u8d25)");

    private final int errorCode;
    private final String errorDesc;

    private HBaseErrorCodeSummary(int errorCode, String errorDesc) {
        ErrorCodeUtils.validateErrorCode((int)errorCode, (int)26000, (int)29999);
        this.errorCode = errorCode;
        this.errorDesc = errorDesc;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }
}

