/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.hbase;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.manager.engineplugin.hbase.HBasePropertiesParser;
import org.apache.linkis.manager.engineplugin.hbase.errorcode.HBaseErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.hbase.exception.HBaseParamsIllegalException;
import org.apache.linkis.manager.engineplugin.hbase.exception.JobExecutorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseConnectionManager.class);
    private final ConcurrentHashMap<String, Connection> connectionMap;
    private final ReentrantLock lock = new ReentrantLock();
    private static final AtomicBoolean kerberosEnvInit = new AtomicBoolean(false);
    private static final int KERBEROS_RE_LOGIN_MAX_RETRY = 5;
    private static final long KERBEROS_RE_LOGIN_INTERVAL = 1800000L;
    private static volatile HBaseConnectionManager instance = null;

    private HBaseConnectionManager() {
        this.connectionMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HBaseConnectionManager getInstance() {
        if (instance != null) return instance;
        Class<HBaseConnectionManager> clazz = HBaseConnectionManager.class;
        synchronized (HBaseConnectionManager.class) {
            if (instance != null) return instance;
            instance = new HBaseConnectionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Configuration getConfiguration(Properties prop) {
        Map<String, String> propMap = this.getPropMap(prop);
        return this.buildConfiguration(propMap);
    }

    public Connection getConnection(Properties prop) {
        Map<String, String> propMap = this.getPropMap(prop);
        return this.getConnection(propMap);
    }

    public Connection getConnection(Configuration configuration) {
        String clusterConnUniqueKey = this.generateUniqueConnectionKey(configuration);
        LOG.info("Start to get connection for cluster {}.", (Object)clusterConnUniqueKey);
        if (this.connectionMap.containsKey(clusterConnUniqueKey)) {
            return this.connectionMap.get(clusterConnUniqueKey);
        }
        try {
            Connection connection;
            this.lock.lock();
            if (this.isKerberosAuthType(configuration) && kerberosEnvInit.compareAndSet(false, true)) {
                this.doKerberosLogin(configuration);
            }
            String proxyUser = this.getKerberosProxyUser(configuration);
            UserGroupInformation kerberosLoginUser = UserGroupInformation.getLoginUser();
            String kerberosLoginShortUserName = kerberosLoginUser.getShortUserName();
            if (StringUtils.isNotBlank((CharSequence)proxyUser) && !proxyUser.equals(kerberosLoginShortUserName)) {
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)kerberosLoginUser);
                connection = (Connection)ugi.doAs(() -> {
                    try {
                        return ConnectionFactory.createConnection((Configuration)configuration);
                    }
                    catch (IOException e) {
                        LOG.error(HBaseErrorCodeSummary.HBASE_CLIENT_CONN_CREATE_FAILED.getErrorDesc(), (Throwable)e);
                        throw new JobExecutorException(HBaseErrorCodeSummary.HBASE_CLIENT_CONN_CREATE_FAILED.getErrorCode(), HBaseErrorCodeSummary.HBASE_CLIENT_CONN_CREATE_FAILED.getErrorDesc());
                    }
                });
                LOG.info("Successfully create a connection {} and proxy user {}", (Object)connection, (Object)proxyUser);
            } else {
                connection = ConnectionFactory.createConnection((Configuration)configuration);
                LOG.info("Successfully create a connection {}.", (Object)connection);
            }
            this.connectionMap.put(clusterConnUniqueKey, connection);
            Connection connection2 = connection;
            return connection2;
        }
        catch (IOException e) {
            LOG.error(HBaseErrorCodeSummary.HBASE_CLIENT_CONN_CREATE_FAILED.getErrorDesc(), (Throwable)e);
            throw new JobExecutorException(HBaseErrorCodeSummary.HBASE_CLIENT_CONN_CREATE_FAILED.getErrorCode(), HBaseErrorCodeSummary.HBASE_CLIENT_CONN_CREATE_FAILED.getErrorDesc());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Connection getConnection(Map<String, String> prop) {
        Configuration configuration = this.buildConfiguration(prop);
        return this.getConnection(configuration);
    }

    private void doKerberosLogin(Configuration configuration) {
        String principal = configuration.get("linkis.hbase.kerberos.principal");
        String keytab = configuration.get("linkis.hbase.keytab.file");
        File file = new File(keytab);
        if (!file.exists()) {
            kerberosEnvInit.set(false);
            throw new HBaseParamsIllegalException(HBaseErrorCodeSummary.KERBEROS_KEYTAB_FILE_NOT_EXISTS.getErrorCode(), HBaseErrorCodeSummary.KERBEROS_KEYTAB_FILE_NOT_EXISTS.getErrorDesc());
        }
        if (!file.isFile()) {
            kerberosEnvInit.set(false);
            throw new HBaseParamsIllegalException(HBaseErrorCodeSummary.KERBEROS_KEYTAB_NOT_FILE.getErrorCode(), HBaseErrorCodeSummary.KERBEROS_KEYTAB_NOT_FILE.getErrorDesc());
        }
        try {
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            LOG.info("Login successfully via keytab: {} and principal: {}", (Object)keytab, (Object)principal);
            this.doKerberosReLogin();
        }
        catch (IOException e) {
            kerberosEnvInit.set(false);
            throw new JobExecutorException(HBaseErrorCodeSummary.KERBEROS_AUTH_FAILED.getErrorCode(), HBaseErrorCodeSummary.KERBEROS_AUTH_FAILED.getErrorDesc());
        }
    }

    private boolean runKerberosLogin() {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        try {
            if (UserGroupInformation.isLoginKeytabBased()) {
                LOG.info("Trying re login from keytab.");
                UserGroupInformation.getLoginUser().reloginFromKeytab();
                return true;
            }
            if (UserGroupInformation.isLoginTicketBased()) {
                LOG.info("Trying re login from ticket cache");
                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to run kinit.", (Throwable)e);
        }
        return false;
    }

    private void doKerberosReLogin() {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        Thread reLoginThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    int times = 0;
                    while (times < 5) {
                        if (HBaseConnectionManager.this.runKerberosLogin()) {
                            LOG.info("Run kerberos re login command successfully.");
                            break;
                        }
                        LOG.info("Run kerberos re login failed for {} time(s).", (Object)(++times));
                    }
                    try {
                        Thread.sleep(1800000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Ignore error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        reLoginThread.setName("KerberosReLoginThread");
        reLoginThread.setDaemon(true);
        reLoginThread.start();
    }

    private Configuration buildConfiguration(Map<String, String> prop) {
        Configuration configuration = HBaseConfiguration.create();
        if (prop.isEmpty()) {
            return configuration;
        }
        String zkQuorum = HBasePropertiesParser.getString(prop, "linkis.hbase.zookeeper.quorum", "localhost");
        configuration.set("hbase.zookeeper.quorum", zkQuorum);
        int zkClientPort = HBasePropertiesParser.getInt(prop, "linkis.hbase.zookeeper.property.clientPort", 2181);
        configuration.set("hbase.zookeeper.property.clientPort", String.valueOf(zkClientPort));
        String zNodeParent = HBasePropertiesParser.getString(prop, "linkis.zookeeper.znode.parent", "/hbase");
        configuration.set("zookeeper.znode.parent", zNodeParent);
        String dfsRootDir = HBasePropertiesParser.getString(prop, "linkis.hbase.rootdir", "/hbase");
        configuration.set("hbase.rootdir", dfsRootDir);
        String securityAuth = HBasePropertiesParser.getString(prop, "linkis.hbase.security.authentication", "simple");
        configuration.set("hbase.security.authentication", securityAuth);
        if (this.isKerberosAuthType(configuration)) {
            configuration.set("hadoop.security.authentication", "kerberos");
            String kerberosPrincipal = HBasePropertiesParser.getString(prop, "linkis.hbase.kerberos.principal", "");
            if (StringUtils.isBlank((CharSequence)kerberosPrincipal)) {
                throw new HBaseParamsIllegalException(HBaseErrorCodeSummary.KERBEROS_PRINCIPAL_NOT_NULL.getErrorCode(), HBaseErrorCodeSummary.KERBEROS_PRINCIPAL_NOT_NULL.getErrorDesc());
            }
            configuration.set("linkis.hbase.kerberos.principal", kerberosPrincipal);
            String keytabFile = HBasePropertiesParser.getString(prop, "linkis.hbase.keytab.file", "");
            if (StringUtils.isBlank((CharSequence)keytabFile)) {
                throw new HBaseParamsIllegalException(HBaseErrorCodeSummary.KERBEROS_KEYTAB_NOT_NULL.getErrorCode(), HBaseErrorCodeSummary.KERBEROS_KEYTAB_NOT_NULL.getErrorDesc());
            }
            configuration.set("linkis.hbase.keytab.file", keytabFile);
            String proxyUser = HBasePropertiesParser.getString(prop, "linkis.hbase.kerberos.proxy.user", "");
            configuration.set("linkis.hbase.kerberos.proxy.user", proxyUser);
            String regionServerPrincipal = HBasePropertiesParser.getString(prop, "linkis.hbase.regionserver.kerberos.principal", "");
            if (StringUtils.isBlank((CharSequence)regionServerPrincipal)) {
                throw new HBaseParamsIllegalException(HBaseErrorCodeSummary.REGION_SERVER_KERBEROS_PRINCIPAL_NOT_NULL.getErrorCode(), HBaseErrorCodeSummary.REGION_SERVER_KERBEROS_PRINCIPAL_NOT_NULL.getErrorDesc());
            }
            configuration.set("hbase.regionserver.kerberos.principal", regionServerPrincipal);
            String masterPrincipal = HBasePropertiesParser.getString(prop, "linkis.hbase.master.kerberos.principal", "");
            if (StringUtils.isBlank((CharSequence)masterPrincipal)) {
                throw new HBaseParamsIllegalException(HBaseErrorCodeSummary.MASTER_KERBEROS_PRINCIPAL_NOT_NULL.getErrorCode(), HBaseErrorCodeSummary.MASTER_KERBEROS_PRINCIPAL_NOT_NULL.getErrorDesc());
            }
            configuration.set("hbase.master.kerberos.principal", masterPrincipal);
            String krb5Conf = HBasePropertiesParser.getString(prop, "java.security.krb5.conf", "/etc/krb5.conf");
            System.setProperty("java.security.krb5.conf", krb5Conf);
        }
        return configuration;
    }

    private boolean isKerberosAuthType(Configuration configuration) {
        String authType = configuration.get("hbase.security.authentication", "simple");
        return "kerberos".equalsIgnoreCase(authType.trim());
    }

    public String generateUniqueConnectionKey(Map<String, String> prop) {
        Configuration configuration = this.buildConfiguration(prop);
        return this.generateUniqueConnectionKey(configuration);
    }

    private String generateUniqueConnectionKey(Configuration configuration) {
        String zkQuorum = configuration.get("hbase.zookeeper.quorum");
        String zkClientPort = configuration.get("hbase.zookeeper.property.clientPort");
        StringBuilder sb = new StringBuilder(zkQuorum);
        sb.append("#");
        sb.append(zkClientPort);
        if (this.supportKerberosProxyUser(configuration)) {
            sb.append("#");
            sb.append(this.getKerberosProxyUser(configuration));
        }
        return sb.toString();
    }

    private boolean supportKerberosProxyUser(Configuration configuration) {
        if (!this.isKerberosAuthType(configuration)) {
            return false;
        }
        String proxyUser = this.getKerberosProxyUser(configuration);
        return StringUtils.isNotBlank((CharSequence)proxyUser);
    }

    private String getKerberosProxyUser(Configuration configuration) {
        return configuration.get("linkis.hbase.kerberos.proxy.user", "");
    }

    public void destroy() {
        try {
            for (Connection connection : this.connectionMap.values()) {
                connection.close();
            }
            this.connectionMap.clear();
        }
        catch (IOException e) {
            LOG.warn("An exception occurred while destroy resources.", (Throwable)e);
        }
    }

    public Map<String, String> getPropMap(Properties prop) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        if (prop == null) {
            return propMap;
        }
        for (String key : prop.stringPropertyNames()) {
            propMap.put(key, prop.getProperty(key));
        }
        return propMap;
    }
}

