/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.factory;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.configuration.YarnDeploymentTarget;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration$;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.engineconnplugin.flink.client.config.FlinkVersionThreadLocal;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.Environment;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ExecutionEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.FlinkInitFailedException;
import org.apache.linkis.engineconnplugin.flink.config.FlinkEnvConfiguration$;
import org.apache.linkis.engineconnplugin.flink.config.FlinkExecutionTargetType$;
import org.apache.linkis.engineconnplugin.flink.config.FlinkResourceConfiguration$;
import org.apache.linkis.engineconnplugin.flink.context.EnvironmentContext;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;
import org.apache.linkis.engineconnplugin.flink.factory.FlinkApplicationExecutorFactory;
import org.apache.linkis.engineconnplugin.flink.factory.FlinkCodeExecutorFactory;
import org.apache.linkis.engineconnplugin.flink.factory.FlinkEngineConnFactory$;
import org.apache.linkis.engineconnplugin.flink.factory.FlinkManagerExecutorFactory;
import org.apache.linkis.engineconnplugin.flink.factory.FlinkSQLExecutorFactory;
import org.apache.linkis.engineconnplugin.flink.util.ClassUtil$;
import org.apache.linkis.engineconnplugin.flink.util.FlinkValueFormatUtil$;
import org.apache.linkis.engineconnplugin.flink.util.ManagerUtil$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.manager.engineplugin.common.conf.EnvConfiguration$;
import org.apache.linkis.manager.engineplugin.common.creation.AbstractEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.creation.ExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.creation.MultiExecutorEngineConnFactory;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.CodeLanguageLabel;
import org.apache.linkis.manager.label.entity.engine.EngineConnMode$;
import org.apache.linkis.manager.label.entity.engine.EngineConnModeLabel;
import org.apache.linkis.manager.label.entity.engine.EngineType$;
import org.apache.linkis.manager.label.entity.engine.RunType$;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001\u0002\u000b\u0016\u0001\tBQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0011\u0001\u0005R\u0005CQa\u0014\u0001\u0005\u0012ACQ\u0001\u0017\u0001\u0005\neCQa\u001a\u0001\u0005\u0012!Dq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011q\t\u0001\u0005\u0012\u0005%\u0003bBA*\u0001\u0011E\u0013Q\u000b\u0005\b\u0003[\u0002A\u0011KA8\u0011%\ty\n\u0001b\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002&\u0002\u0001\u000b\u0011BAR\u0011\u001d\t9\u000b\u0001C!\u0003C;q!!+\u0016\u0011\u0003\tYK\u0002\u0004\u0015+!\u0005\u0011Q\u0016\u0005\u0007yA!\t!a,\t\u0013\u0005E\u0006C1A\u0005\n\u0005M\u0006\u0002CAg!\u0001\u0006I!!.\u0003-\u0019c\u0017N\\6F]\u001eLg.Z\"p]:4\u0015m\u0019;pefT!AF\f\u0002\u000f\u0019\f7\r^8ss*\u0011\u0001$G\u0001\u0006M2Lgn\u001b\u0006\u00035m\t\u0001#\u001a8hS:,7m\u001c8oa2,x-\u001b8\u000b\u0005qi\u0012A\u00027j].L7O\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0005\u0001\rJS\u0007\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003UMj\u0011a\u000b\u0006\u0003Y5\n\u0001b\u0019:fCRLwN\u001c\u0006\u0003]=\naaY8n[>t'B\u0001\u00192\u00031)gnZ5oKBdWoZ5o\u0015\t\u00114$A\u0004nC:\fw-\u001a:\n\u0005QZ#AH'vYRLW\t_3dkR|'/\u00128hS:,7i\u001c8o\r\u0006\u001cGo\u001c:z!\t1$(D\u00018\u0015\tA\u0014(A\u0003vi&d7O\u0003\u0002/7%\u00111h\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\b\u0005\u0002@\u00015\tQ#A\fde\u0016\fG/Z#oO&tWmQ8o]N+7o]5p]R\u0011!)\u0012\t\u0003I\rK!\u0001R\u0013\u0003\u0007\u0005s\u0017\u0010C\u0003G\u0005\u0001\u0007q)A\u000bf]\u001eLg.Z\"sK\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005!kU\"A%\u000b\u00051R%B\u0001\u0018L\u0015\ta5$\u0001\u0006f]\u001eLg.Z2p]:L!AT%\u0003+\u0015sw-\u001b8f\u0007J,\u0017\r^5p]\u000e{g\u000e^3yi\u0006A2M]3bi\u0016,eN^5s_:lWM\u001c;D_:$X\r\u001f;\u0015\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\u0018\u0003\u001d\u0019wN\u001c;fqRL!AV*\u0003%\u0015sg/\u001b:p]6,g\u000e^\"p]R,\u0007\u0010\u001e\u0005\u0006\r\u000e\u0001\raR\u0001\u0013O\u0016$X\t\u001f;sC\u000e$(*\u0019<b\u001fB$8\u000f\u0006\u0002[KB\u00111L\u0019\b\u00039\u0002\u0004\"!X\u0013\u000e\u0003yS!aX\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\tW%\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1&\u0011\u00151G\u00011\u0001[\u0003-)gN\u001e&bm\u0006|\u0005\u000f^:\u0002!%\u001cxJ\\2f\u000b:<\u0017N\\3D_:tGCA5m!\t!#.\u0003\u0002lK\t9!i\\8mK\u0006t\u0007\"B7\u0006\u0001\u0004q\u0017A\u00027bE\u0016d7\u000fE\u0002piZl\u0011\u0001\u001d\u0006\u0003cJ\fA!\u001e;jY*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0011a\u0015n\u001d;1\u0007]\f\u0019\u0001E\u0002y{~l\u0011!\u001f\u0006\u0003un\fa!\u001a8uSRL(B\u0001?2\u0003\u0015a\u0017MY3m\u0013\tq\u0018PA\u0003MC\n,G\u000e\u0005\u0003\u0002\u0002\u0005\rA\u0002\u0001\u0003\f\u0003\u000ba\u0017\u0011!A\u0001\u0006\u0003\t9AA\u0002`IE\n2!!\u0003C!\r!\u00131B\u0005\u0004\u0003\u001b)#a\u0002(pi\"LgnZ\u0001\u0013O\u0016$8\u000b[5q\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0003\u0002\u0014\u0005e\u0001\u0003\u0002\u0013\u0002\u0016iK1!a\u0006&\u0005\u0015\t%O]1z\u0011\u001d\tYB\u0002a\u0001\u0003;\tqa\u001c9uS>t7\u000fE\u0003p\u0003?Q&,C\u0002\u0002\"A\u00141!T1q\u0003Q\tG\rZ!qa2L7-\u0019;j_:d\u0015MY3mgR!\u0011qEA\u0017!\r!\u0013\u0011F\u0005\u0004\u0003W)#\u0001B+oSRDQAR\u0004A\u0002\u001d\u000bac\u0019:fCR,W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u000b\u0007\u0003g\t\t%a\u0011\u0011\t\u0005U\u0012QH\u0007\u0003\u0003oQ1\u0001VA\u001d\u0015\r\tYdF\u0001\u0007G2LWM\u001c;\n\t\u0005}\u0012q\u0007\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!a\u0007\t\u0001\u0004\ti\u0002\u0003\u0004\u0002F!\u0001\r!U\u0001\u0013K:4\u0018N]8o[\u0016tGoQ8oi\u0016DH/\u0001\u000fde\u0016\fG/\u001a$mS:\\WI\\4j]\u0016\u001cuN\u001c8D_:$X\r\u001f;\u0015\t\u0005-\u0013\u0011\u000b\t\u0004%\u00065\u0013bAA('\n1b\t\\5oW\u0016sw-\u001b8f\u0007>tgnQ8oi\u0016DH\u000f\u0003\u0004\u0002F%\u0001\r!U\u0001\u001fO\u0016$H)\u001a4bk2$X\t_3dkR|'OR1di>\u0014\u0018p\u00117bgN,\"!a\u00161\t\u0005e\u0013\u0011\r\t\u00067\u0006m\u0013qL\u0005\u0004\u0003;\"'!B\"mCN\u001c\b\u0003BA\u0001\u0003C\"1\"a\u0019\u000b\u0003\u0003\u0005\tQ!\u0001\u0002f\t\u0019q\f\n\u001a\u0012\t\u0005%\u0011q\r\t\u0004U\u0005%\u0014bAA6W\tyQ\t_3dkR|'OR1di>\u0014\u00180A\thKR,enZ5oK\u000e{gN\u001c+za\u0016,\"!!\u001d\u0011\t\u0005M\u0014\u0011\u0014\b\u0005\u0003k\n\u0019J\u0004\u0003\u0002x\u0005=e\u0002BA=\u0003\u001bsA!a\u001f\u0002\f:!\u0011QPAE\u001d\u0011\ty(a\"\u000f\t\u0005\u0005\u0015Q\u0011\b\u0004;\u0006\r\u0015\"\u0001\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\t\u00114$\u0003\u0002}c%\u0011!p_\u0005\u0004\u0003#K\u0018AB3oO&tW-\u0003\u0003\u0002\u0016\u0006]\u0015AC#oO&tW\rV=qK*\u0019\u0011\u0011S=\n\t\u0005m\u0015Q\u0014\u0002\u000b\u000b:<\u0017N\\3UsB,'\u0002BAK\u0003/\u000bA#\u001a=fGV$xN\u001d$bGR|'/_!se\u0006LXCAAR!\u0015!\u0013QCA4\u0003U)\u00070Z2vi>\u0014h)Y2u_JL\u0018I\u001d:bs\u0002\nAcZ3u\u000bb,7-\u001e;pe\u001a\u000b7\r^8sS\u0016\u001c\u0018A\u0006$mS:\\WI\\4j]\u0016\u001cuN\u001c8GC\u000e$xN]=\u0011\u0005}\u00022c\u0001\t$kQ\u0011\u00111V\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011Q\u0017\t\u0007\u0003o\u000bi,!1\u000f\u0007\u0011\nI,C\u0002\u0002<\u0016\nq\u0001]1dW\u0006<W-C\u0002v\u0003\u007fS1!a/&!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAd/\u000591/\u001a;uS:<\u0017\u0002BAf\u0003\u000b\u0014\u0001bU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\u0002")
public class FlinkEngineConnFactory
implements MultiExecutorEngineConnFactory {
    private final ExecutorFactory[] executorFactoryArray;
    private Logger logger;
    private volatile boolean bitmap$0;

    public ExecutorFactory getDefaultExecutorFactory() {
        return MultiExecutorEngineConnFactory.getDefaultExecutorFactory$((MultiExecutorEngineConnFactory)this);
    }

    public EngineConnModeLabel getEngineConnModeLabel(List<Label<?>> labels) {
        return MultiExecutorEngineConnFactory.getEngineConnModeLabel$((MultiExecutorEngineConnFactory)this, labels);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public EngineConn createEngineConn(EngineCreationContext engineCreationContext) {
        return AbstractEngineConnFactory.createEngineConn$((AbstractEngineConnFactory)this, (EngineCreationContext)engineCreationContext);
    }

    private Logger logger$lzycompute() {
        FlinkEngineConnFactory flinkEngineConnFactory = this;
        synchronized (flinkEngineConnFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Object createEngineConnSession(EngineCreationContext engineCreationContext) {
        java.util.Map options = engineCreationContext.getOptions();
        options = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            if (string.contains((CharSequence)FlinkEnvConfiguration$.MODULE$.FLINK_PARAMS_BLANK_PLACEHOLER().getValue())) {
                this.logger().info(new StringBuilder(26).append("Transform option value: [").append(string).append("]").toString());
                return string.replace((CharSequence)FlinkEnvConfiguration$.MODULE$.FLINK_PARAMS_BLANK_PLACEHOLER().getValue(), " ");
            }
            return string;
        }).toMap(Predef$.MODULE$.$conforms())).asJava();
        engineCreationContext.setOptions(options);
        EnvironmentContext environmentContext = this.createEnvironmentContext(engineCreationContext);
        FlinkEngineConnFactory$.MODULE$.org$apache$linkis$engineconnplugin$flink$factory$FlinkEngineConnFactory$$settings().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.setEnvironmentContext(engineCreationContext, environmentContext);
            return BoxedUnit.UNIT;
        });
        FlinkEngineConnContext flinkEngineConnContext = this.createFlinkEngineConnContext(environmentContext);
        ExecutionContext executionContext = this.createExecutionContext(options, environmentContext);
        flinkEngineConnContext.setExecutionContext(executionContext);
        FlinkEngineConnFactory$.MODULE$.org$apache$linkis$engineconnplugin$flink$factory$FlinkEngineConnFactory$$settings().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.setExecutionContext(engineCreationContext, flinkEngineConnContext);
            return BoxedUnit.UNIT;
        });
        return flinkEngineConnContext;
    }

    public EnvironmentContext createEnvironmentContext(EngineCreationContext engineCreationContext) {
        Object object;
        Configuration configuration;
        String flinkMainClassJar;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        java.util.Map options = engineCreationContext.getOptions();
        String flinkExecutionTarget = (String)FlinkEnvConfiguration$.MODULE$.FLINK_EXECUTION_TARGET().getValue(options);
        Environment defaultEnv = Environment.parse((URL)this.getClass().getClassLoader().getResource("flink-sql-defaults.yaml"));
        String hadoopConfDir = (String)EnvConfiguration$.MODULE$.HADOOP_CONF_DIR().getValue(options);
        String flinkHome = (String)FlinkEnvConfiguration$.MODULE$.FLINK_HOME().getValue(options);
        String flinkConfDir = (String)FlinkEnvConfiguration$.MODULE$.FLINK_CONF_DIR().getValue(options);
        String flinkProvidedLibPath = (String)FlinkEnvConfiguration$.MODULE$.FLINK_PROVIDED_LIB_PATH().getValue(options);
        String flinkVersion = (String)FlinkEnvConfiguration$.MODULE$.FLINK_VERSION().getValue(options);
        String flinkDistJarPath = (String)FlinkEnvConfiguration$.MODULE$.FLINK_DIST_JAR_PATH().getValue(options);
        if (StringUtils.isNotBlank((CharSequence)flinkVersion) && flinkVersion.equalsIgnoreCase(FlinkEnvConfiguration$.MODULE$.FLINK_1_12_2_VERSION())) {
            flinkDistJarPath = flinkDistJarPath.replaceFirst("flink-dist", "flink-dist_2.11");
        }
        String[] providedLibDirsArray = ((String)FlinkEnvConfiguration$.MODULE$.FLINK_LIB_LOCAL_PATH().getValue(options)).split(",");
        String[] shipDirsArray = this.getShipDirectories(options);
        String flinkClientType = (String)GovernanceCommonConf$.MODULE$.EC_APP_MANAGE_MODE().getValue(options);
        HashMap<String, Object> otherParams = new HashMap<String, Object>();
        boolean isManager = ManagerUtil$.MODULE$.isManager();
        if (isManager) {
            this.logger().info(new StringBuilder(22).append("support parallelism : ").append(AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_SUPPORT_PARALLELISM().getHotValue()).toString());
        }
        otherParams.put(GovernanceCommonConf$.MODULE$.EC_APP_MANAGE_MODE().key(), flinkClientType.toLowerCase());
        FlinkVersionThreadLocal.setFlinkVersion(flinkVersion);
        EnvironmentContext context = new EnvironmentContext(defaultEnv, new Configuration(), hadoopConfDir, flinkConfDir, flinkHome, flinkDistJarPath, flinkProvidedLibPath, providedLibDirsArray, shipDirsArray, new ArrayList<URL>(), flinkExecutionTarget, flinkVersion, otherParams);
        String jobName = options.getOrDefault("flink.app.name", "EngineConn-Flink");
        String yarnQueue = (String)FlinkResourceConfiguration$.MODULE$.LINKIS_QUEUE_NAME().getValue(options);
        int parallelism = BoxesRunTime.unboxToInt((Object)FlinkResourceConfiguration$.MODULE$.FLINK_APP_DEFAULT_PARALLELISM().getValue(options));
        String jobManagerMemory = new StringBuilder(1).append(BoxesRunTime.unboxToInt((Object)FlinkResourceConfiguration$.MODULE$.LINKIS_FLINK_JOB_MANAGER_MEMORY().getValue(options))).append("M").toString();
        String taskManagerMemory = new StringBuilder(1).append(BoxesRunTime.unboxToInt((Object)FlinkResourceConfiguration$.MODULE$.LINKIS_FLINK_TASK_MANAGER_MEMORY().getValue(options))).append("M").toString();
        int numberOfTaskSlots = BoxesRunTime.unboxToInt((Object)FlinkResourceConfiguration$.MODULE$.LINKIS_FLINK_TASK_SLOTS().getValue(options));
        this.logger().info(new StringBuilder(105).append("Use yarn queue ").append(yarnQueue).append(", and set parallelism = ").append(parallelism).append(", jobManagerMemory = ").append(jobManagerMemory).append(", taskManagerMemory = ").append(taskManagerMemory).append(", numberOfTaskSlots = ").append(numberOfTaskSlots).append(".").toString());
        Configuration flinkConfig = context.getFlinkConfig();
        String[] flinkUserProvidedLibPath = ((String)FlinkEnvConfiguration$.MODULE$.FLINK_PROVIDED_USER_LIB_PATH().getValue(options)).split(",");
        ArrayList providedLibDirList = Lists.newArrayList((Object[])((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flinkUserProvidedLibPath)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$createEnvironmentContext$1(x$1)))));
        ArrayList flinkProvidedLibPathList = Lists.newArrayList((Object[])((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flinkProvidedLibPath.split(","))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$createEnvironmentContext$2(x$1)))));
        Object object2 = flinkProvidedLibPathList != null && flinkProvidedLibPathList.size() > 0 ? BoxesRunTime.boxToBoolean((boolean)providedLibDirList.addAll(flinkProvidedLibPathList)) : BoxedUnit.UNIT;
        if (!FlinkExecutionTargetType$.MODULE$.isKubernetesExecutionTargetType(flinkExecutionTarget)) {
            flinkConfig.set(YarnConfigOptions.PROVIDED_LIB_DIRS, (Object)providedLibDirList);
            flinkConfig.set(YarnConfigOptions.SHIP_FILES, context.getShipDirs());
            flinkConfig.set(YarnConfigOptions.APPLICATION_NAME, (Object)jobName);
            boxedUnit4 = flinkConfig.set(YarnConfigOptions.APPLICATION_QUEUE, (Object)yarnQueue);
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        String classpaths = (String)FlinkEnvConfiguration$.MODULE$.FLINK_APPLICATION_CLASSPATH().getValue(options);
        if (StringUtils.isNotBlank((CharSequence)classpaths)) {
            this.logger().info(new StringBuilder(36).append("Add ").append(classpaths).append(" to flink application classpath.").toString());
            boxedUnit3 = flinkConfig.set(PipelineOptions.CLASSPATHS, Arrays.asList((Object[])classpaths.split(",")));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        flinkConfig.setInteger(CoreOptions.DEFAULT_PARALLELISM, parallelism);
        flinkConfig.set(JobManagerOptions.TOTAL_PROCESS_MEMORY, (Object)MemorySize.parse((String)jobManagerMemory));
        flinkConfig.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)MemorySize.parse((String)taskManagerMemory));
        flinkConfig.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, numberOfTaskSlots);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$createEnvironmentContext$3(x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            FlinkEngineConnFactory.$anonfun$createEnvironmentContext$4(this, flinkConfig, x0$2);
            return BoxedUnit.UNIT;
        });
        if (BoxesRunTime.unboxToBoolean((Object)FlinkEnvConfiguration$.MODULE$.FLINK_KERBEROS_ENABLE().getValue(options))) {
            flinkConfig.set(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, FlinkEnvConfiguration$.MODULE$.FLINK_KERBEROS_LOGIN_CONTEXTS().getValue(options));
            flinkConfig.set(SecurityOptions.KERBEROS_KRB5_PATH, FlinkEnvConfiguration$.MODULE$.FLINK_KERBEROS_CONF_PATH().getValue(options));
            flinkConfig.set(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, FlinkEnvConfiguration$.MODULE$.FLINK_KERBEROS_LOGIN_PRINCIPAL().getValue(options));
            boxedUnit2 = flinkConfig.set(SecurityOptions.KERBEROS_LOGIN_KEYTAB, FlinkEnvConfiguration$.MODULE$.FLINK_KERBEROS_LOGIN_KEYTAB().getValue(options));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (BoxesRunTime.unboxToBoolean((Object)FlinkEnvConfiguration$.MODULE$.FLINK_REPORTER_ENABLE().getValue(options))) {
            flinkConfig.set(MetricOptions.REPORTER_CLASS, FlinkEnvConfiguration$.MODULE$.FLINK_REPORTER_CLASS().getValue(options));
            boxedUnit = flinkConfig.set(MetricOptions.REPORTER_INTERVAL, (Object)Duration.ofMillis(((TimeType)FlinkEnvConfiguration$.MODULE$.FLINK_REPORTER_INTERVAL().getValue(options)).toLong()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String savePointPath = (String)FlinkEnvConfiguration$.MODULE$.FLINK_SAVE_POINT_PATH().getValue(options);
        if (StringUtils.isNotBlank((CharSequence)savePointPath)) {
            boolean allowNonRestoredState = new StringOps(Predef$.MODULE$.augmentString((String)FlinkEnvConfiguration$.MODULE$.FLINK_APP_ALLOW_NON_RESTORED_STATUS().getValue(options))).toBoolean();
            SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.forPath((String)savePointPath, (boolean)allowNonRestoredState);
            SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)savepointRestoreSettings, (Configuration)flinkConfig);
        }
        if (StringUtils.isNotBlank((CharSequence)(flinkMainClassJar = (String)FlinkEnvConfiguration$.MODULE$.FLINK_APPLICATION_MAIN_CLASS_JAR().getValue(options))) && FlinkExecutionTargetType$.MODULE$.isYarnExecutionTargetType(flinkExecutionTarget)) {
            String flinkMainClassJarPath = new File(flinkMainClassJar).exists() ? flinkMainClassJar : this.getClass().getClassLoader().getResource(flinkMainClassJar).getPath();
            this.logger().info(new StringBuilder(62).append("Ready to use ").append(flinkMainClassJarPath).append(" as main class jar to submit application to Yarn.").toString());
            flinkConfig.set(PipelineOptions.JARS, Collections.singletonList(flinkMainClassJarPath));
            flinkConfig.set(DeploymentOptions.TARGET, (Object)YarnDeploymentTarget.APPLICATION.getName());
            flinkConfig.setBoolean(DeploymentOptions.ATTACHED, BoxesRunTime.unboxToBoolean((Object)FlinkEnvConfiguration$.MODULE$.FLINK_EXECUTION_ATTACHED().getValue(options)));
            context.setDeploymentTarget(YarnDeploymentTarget.APPLICATION.getName());
            this.addApplicationLabels(engineCreationContext);
            configuration = BoxedUnit.UNIT;
        } else {
            configuration = this.isOnceEngineConn(engineCreationContext.getLabels()) ? flinkConfig.set(DeploymentOptions.TARGET, (Object)YarnDeploymentTarget.PER_JOB.getName()) : flinkConfig.set(DeploymentOptions.TARGET, (Object)YarnDeploymentTarget.SESSION.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)flinkExecutionTarget) && FlinkExecutionTargetType$.MODULE$.isKubernetesExecutionTargetType(flinkExecutionTarget)) {
            flinkConfig.set(DeploymentOptions.TARGET, (Object)flinkExecutionTarget);
            context.setDeploymentTarget(flinkExecutionTarget);
            String kubernetesConfigFile = (String)FlinkEnvConfiguration$.MODULE$.FLINK_KUBERNETES_CONFIG_FILE().getValue(options);
            if (StringUtils.isBlank((CharSequence)kubernetesConfigFile)) {
                throw new FlinkInitFailedException(FlinkErrorCodeSummary.KUBERNETES_CONFIG_FILE_EMPTY.getErrorDesc());
            }
            flinkConfig.set(KubernetesConfigOptions.KUBE_CONFIG_FILE, (Object)kubernetesConfigFile);
            flinkConfig.set(KubernetesConfigOptions.NAMESPACE, FlinkEnvConfiguration$.MODULE$.FLINK_KUBERNETES_NAMESPACE().getValue(options));
            flinkConfig.set(KubernetesConfigOptions.CONTAINER_IMAGE, FlinkEnvConfiguration$.MODULE$.FLINK_KUBERNETES_CONTAINER_IMAGE().getValue(options));
            String kubernetesClusterId = (String)FlinkEnvConfiguration$.MODULE$.FLINK_KUBERNETES_CLUSTER_ID().getValue(options);
            Object object3 = StringUtils.isNotBlank((CharSequence)kubernetesClusterId) ? flinkConfig.set(KubernetesConfigOptions.CLUSTER_ID, (Object)kubernetesClusterId) : BoxedUnit.UNIT;
            String serviceAccount = (String)FlinkEnvConfiguration$.MODULE$.FLINK_KUBERNETES_SERVICE_ACCOUNT().getValue(options);
            flinkConfig.set(KubernetesConfigOptions.KUBERNETES_SERVICE_ACCOUNT, (Object)serviceAccount);
            String flinkMainClassJar2 = (String)FlinkEnvConfiguration$.MODULE$.FLINK_APPLICATION_MAIN_CLASS_JAR().getValue(options);
            object = StringUtils.isNotBlank((CharSequence)flinkMainClassJar2) ? flinkConfig.set(PipelineOptions.JARS, Collections.singletonList(flinkMainClassJar2)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getExtractJavaOpts(String envJavaOpts) {
        String defaultJavaOpts = "";
        String yamlFilePath = (String)FlinkEnvConfiguration$.MODULE$.FLINK_CONF_DIR().getValue();
        String yamlFile = new StringBuilder(1).append(yamlFilePath).append("/").append(FlinkEnvConfiguration$.MODULE$.FLINK_CONF_YAML().getHotValue()).toString();
        if (new File(yamlFile).exists()) {
            try (BufferedSource source = Source$.MODULE$.fromFile(yamlFile, Codec$.MODULE$.fallbackSystemCodec());){
                String yamlContent = source.mkString();
                Yaml yaml = new Yaml();
                LinkedHashMap configMap = (LinkedHashMap)yaml.loadAs(yamlContent, LinkedHashMap.class);
                if (!configMap.containsKey(FlinkEnvConfiguration$.MODULE$.FLINK_ENV_JAVA_OPTS().getValue())) return FlinkValueFormatUtil$.MODULE$.mergeAndDeduplicate(defaultJavaOpts, envJavaOpts);
                defaultJavaOpts = configMap.get(FlinkEnvConfiguration$.MODULE$.FLINK_ENV_JAVA_OPTS().getValue()).toString();
                return FlinkValueFormatUtil$.MODULE$.mergeAndDeduplicate(defaultJavaOpts, envJavaOpts);
            }
        }
        InputStream inputStream = this.getClass().getResourceAsStream(yamlFile);
        if (inputStream == null) throw new FileNotFoundException("YAML file not found in both file system and classpath.");
        try (BufferedSource source = Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.fallbackSystemCodec());){
            String yamlContent = source.mkString();
            Yaml yaml = new Yaml();
            LinkedHashMap configMap = (LinkedHashMap)yaml.loadAs(yamlContent, LinkedHashMap.class);
            if (!configMap.containsKey(FlinkEnvConfiguration$.MODULE$.FLINK_ENV_JAVA_OPTS().getValue())) return FlinkValueFormatUtil$.MODULE$.mergeAndDeduplicate(defaultJavaOpts, envJavaOpts);
            defaultJavaOpts = configMap.get(FlinkEnvConfiguration$.MODULE$.FLINK_ENV_JAVA_OPTS().getValue()).toString();
            return FlinkValueFormatUtil$.MODULE$.mergeAndDeduplicate(defaultJavaOpts, envJavaOpts);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOnceEngineConn(List<Label<?>> labels) {
        EngineConnModeLabel engineConnModeLabel = this.getEngineConnModeLabel(labels);
        if (engineConnModeLabel == null) return false;
        Enumeration.Value value = EngineConnMode$.MODULE$.toEngineConnMode(engineConnModeLabel.getEngineConnMode());
        Enumeration.Value value2 = EngineConnMode$.MODULE$.Once();
        Enumeration.Value value3 = value;
        if (value2 == null) {
            if (value3 == null) return true;
        } else if (value2.equals(value3)) {
            return true;
        }
        Enumeration.Value value4 = EngineConnMode$.MODULE$.Once_With_Cluster();
        Enumeration.Value value5 = value;
        if (value4 != null) {
            if (!value4.equals(value5)) return false;
            return true;
        }
        if (value5 == null) return true;
        return false;
    }

    private String[] getShipDirectories(java.util.Map<String, String> options) {
        String[] stringArray;
        String[] shipDirsArray = new StringBuilder(1).append((String)FlinkEnvConfiguration$.MODULE$.FLINK_SHIP_DIRECTORIES().getValue(options)).append(",").append(FlinkEnvConfiguration$.MODULE$.FLINK_SHIP_DIRECTORIES().getValue()).toString().split(",");
        String[] stringArray2 = shipDirsArray;
        if (stringArray2 != null) {
            String[] stringArray3 = stringArray2;
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray3)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$getShipDirectories$1(x$1))))).map((Function1 & Serializable & scala.Serializable)dir -> {
                if (new File((String)dir).exists()) {
                    return dir;
                }
                Option option = Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResource((String)dir));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    URL url = (URL)some.value();
                    return url.getPath();
                }
                this.logger().warn(new StringBuilder(33).append("Local file/directory [").append((String)dir).append("] not found").toString());
                return null;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$getShipDirectories$3(x$1)));
        } else {
            stringArray = new String[]{};
        }
        shipDirsArray = stringArray;
        ArrayList shipDirs = new ArrayList(Sets.newHashSet((Object[])shipDirsArray));
        String[] stringArray4 = ((String)FlinkEnvConfiguration$.MODULE$.FLINK_SHIP_REMOTE_DIRECTORIES().getValue(options)).split(",");
        if (stringArray4 == null) {
            throw new MatchError((Object)stringArray4);
        }
        String[] stringArray5 = stringArray4;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray5)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$getShipDirectories$4(x$1))))).foreach((Function1 & Serializable & scala.Serializable)remotePath -> {
            FlinkEngineConnFactory.$anonfun$getShipDirectories$5(this, shipDirs, remotePath);
            return BoxedUnit.UNIT;
        });
        return (String[])shipDirs.toArray((Object[])new String[0]);
    }

    private void addApplicationLabels(EngineCreationContext engineCreationContext) {
        Object object;
        Buffer labels = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(engineCreationContext.getLabels()).asScala();
        if (!labels.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$addApplicationLabels$1(x$3)))) {
            CodeLanguageLabel codeLanguageLabel = new CodeLanguageLabel();
            codeLanguageLabel.setCodeType(RunType$.MODULE$.JAR().toString());
            object = BoxesRunTime.boxToBoolean((boolean)engineCreationContext.getLabels().add(codeLanguageLabel));
        } else {
            object = BoxedUnit.UNIT;
        }
        if (!labels.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkEngineConnFactory.$anonfun$addApplicationLabels$2(x$4)))) {
            EngineConnModeLabel engineConnModeLabel = new EngineConnModeLabel();
            engineConnModeLabel.setEngineConnMode(EngineConnMode$.MODULE$.Once().toString());
            engineCreationContext.getLabels().add(engineConnModeLabel);
            return;
        }
    }

    public ExecutionContext createExecutionContext(java.util.Map<String, String> options, EnvironmentContext environmentContext) {
        ExecutionContext executionContext;
        block17: {
            Environment environment;
            boolean bl;
            String string = environmentContext.getDeploymentTarget();
            String string2 = FlinkExecutionTargetType$.MODULE$.YARN_PER_JOB();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = FlinkExecutionTargetType$.MODULE$.YARN_SESSION();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = FlinkExecutionTargetType$.MODULE$.KUBERNETES_SESSION();
                    String string7 = string;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
            }
            if (bl) {
                String planner = (String)FlinkEnvConfiguration$.MODULE$.FLINK_SQL_PLANNER().getValue(options);
                if (!ExecutionEntry.AVAILABLE_PLANNERS.contains(planner.toLowerCase(Locale.getDefault()))) {
                    throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.PLANNER_MUST_THESE.getErrorDesc(), String.join((CharSequence)", ", ExecutionEntry.AVAILABLE_PLANNERS)));
                }
                String executionType = (String)FlinkEnvConfiguration$.MODULE$.FLINK_SQL_EXECUTION_TYPE().getValue(options);
                if (!ExecutionEntry.AVAILABLE_EXECUTION_TYPES.contains(executionType.toLowerCase(Locale.getDefault()))) {
                    throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.EXECUTION_MUST_THESE.getErrorDesc(), String.join((CharSequence)", ", ExecutionEntry.AVAILABLE_EXECUTION_TYPES)));
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                environmentContext.getFlinkConfig().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.STREAMING);
                Object object = executionType.equalsIgnoreCase("batch") ? environmentContext.getFlinkConfig().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH) : BoxedUnit.UNIT;
                properties.put("execution.type", executionType);
                String string8 = executionType.equalsIgnoreCase("batch") ? properties.put("execution.result-mode", "table") : properties.put("execution.result-mode", "changelog");
                environment = Environment.enrich((Environment)environmentContext.getDefaultEnv(), properties, Collections.emptyMap());
            } else {
                boolean bl2;
                String string9 = FlinkExecutionTargetType$.MODULE$.YARN_APPLICATION();
                String string10 = string;
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    bl2 = true;
                } else {
                    String string11 = FlinkExecutionTargetType$.MODULE$.KUBERNETES_APPLICATION();
                    String string12 = string;
                    bl2 = !(string11 != null ? !string11.equals(string12) : string12 != null);
                }
                if (bl2) {
                    environment = null;
                } else {
                    this.logger().error(new StringBuilder(36).append("Not supported YarnDeploymentTarget ").append(string).append(".").toString());
                    throw new FlinkInitFailedException(new StringBuilder(2).append(FlinkErrorCodeSummary.NOT_SUPPORTED_YARNTARGET.getErrorDesc()).append(" ").append(string).append(".").toString());
                }
            }
            Environment environment2 = environment;
            String flinkVersion = (String)FlinkEnvConfiguration$.MODULE$.FLINK_VERSION().getValue(options);
            if (StringUtils.isBlank((CharSequence)flinkVersion)) {
                flinkVersion = FlinkEnvConfiguration$.MODULE$.FLINK_1_16_2_VERSION();
            }
            FlinkVersionThreadLocal.setFlinkVersion(flinkVersion);
            executionContext = ExecutionContext.builder(environmentContext.getDefaultEnv(), environment2, environmentContext.getDependencies(), environmentContext.getFlinkConfig(), flinkVersion).build();
            if (!BoxesRunTime.unboxToBoolean((Object)FlinkEnvConfiguration$.MODULE$.FLINK_CHECK_POINT_ENABLE().getValue(options))) break block17;
            int checkpointInterval = BoxesRunTime.unboxToInt((Object)FlinkEnvConfiguration$.MODULE$.FLINK_CHECK_POINT_INTERVAL().getValue(options));
            String checkpointMode = (String)FlinkEnvConfiguration$.MODULE$.FLINK_CHECK_POINT_MODE().getValue(options);
            int checkpointTimeout = BoxesRunTime.unboxToInt((Object)FlinkEnvConfiguration$.MODULE$.FLINK_CHECK_POINT_TIMEOUT().getValue(options));
            int checkpointMinPause = BoxesRunTime.unboxToInt((Object)FlinkEnvConfiguration$.MODULE$.FLINK_CHECK_POINT_MIN_PAUSE().getValue(options));
            this.logger().info(new StringBuilder(89).append("checkpoint is enabled, checkpointInterval is ").append(checkpointInterval).append(", checkpointMode is ").append(checkpointMode).append(", checkpointTimeout is ").append(checkpointTimeout).append(".").toString());
            executionContext.getTableEnvironment();
            executionContext.getStreamExecutionEnvironment().enableCheckpointing((long)checkpointInterval);
            CheckpointConfig checkpointConfig = executionContext.getStreamExecutionEnvironment().getCheckpointConfig();
            String string13 = checkpointMode;
            if ("EXACTLY_ONCE".equals(string13)) {
                checkpointConfig.setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);
            } else if ("AT_LEAST_ONCE".equals(string13)) {
                checkpointConfig.setCheckpointingMode(CheckpointingMode.AT_LEAST_ONCE);
            } else {
                throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.UNKNOWN_CHECKPOINT_MODE.getErrorDesc(), checkpointMode));
            }
            checkpointConfig.setCheckpointTimeout((long)checkpointTimeout);
            checkpointConfig.setMinPauseBetweenCheckpoints((long)checkpointMinPause);
            checkpointConfig.enableExternalizedCheckpoints(CheckpointConfig.ExternalizedCheckpointCleanup.RETAIN_ON_CANCELLATION);
            checkpointConfig.configure((ReadableConfig)environmentContext.getFlinkConfig());
        }
        return executionContext;
    }

    public FlinkEngineConnContext createFlinkEngineConnContext(EnvironmentContext environmentContext) {
        return new FlinkEngineConnContext(environmentContext);
    }

    public Class<? extends ExecutorFactory> getDefaultExecutorFactoryClass() {
        java.util.Map options = EngineConnServer$.MODULE$.getEngineCreationContext().getOptions();
        if (BoxesRunTime.unboxToBoolean((Object)FlinkEnvConfiguration$.MODULE$.FLINK_MANAGER_MODE_CONFIG_KEY().getValue(options))) {
            return FlinkManagerExecutorFactory.class;
        }
        return FlinkCodeExecutorFactory.class;
    }

    public Enumeration.Value getEngineConnType() {
        return EngineType$.MODULE$.FLINK();
    }

    private ExecutorFactory[] executorFactoryArray() {
        return this.executorFactoryArray;
    }

    public ExecutorFactory[] getExecutorFactories() {
        return this.executorFactoryArray();
    }

    public static final /* synthetic */ boolean $anonfun$createEnvironmentContext$1(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$createEnvironmentContext$2(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$createEnvironmentContext$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return key.startsWith(FlinkEnvConfiguration$.MODULE$.FLINK_CONFIG_PREFIX());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$createEnvironmentContext$4(FlinkEngineConnFactory $this, Configuration flinkConfig$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String value;
            String key = (String)tuple2._1();
            String flinkConfigValue = value = (String)tuple2._2();
            if (BoxesRunTime.unboxToBoolean((Object)FlinkEnvConfiguration$.MODULE$.FLINK_YAML_MERGE_ENABLE().getValue()) && key.equals(new StringBuilder(0).append(FlinkEnvConfiguration$.MODULE$.FLINK_CONFIG_PREFIX()).append(FlinkEnvConfiguration$.MODULE$.FLINK_ENV_JAVA_OPTS().getValue()).toString())) {
                flinkConfigValue = $this.getExtractJavaOpts(value);
            }
            flinkConfig$1.setString(key.substring(FlinkEnvConfiguration$.MODULE$.FLINK_CONFIG_PREFIX().length()), flinkConfigValue);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getShipDirectories$1(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getShipDirectories$3(CharSequence x$1) {
        return StringUtils.isBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getShipDirectories$4(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ void $anonfun$getShipDirectories$5(FlinkEngineConnFactory $this, List shipDirs$1, String remotePath) {
        Option option = Option$.MODULE$.apply((Object)remotePath);
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            Option$.MODULE$.apply((Object)new Path(path).toUri().getScheme()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                if ("viewfs".equals(schema) || "hdfs".equals(schema)) {
                    return BoxesRunTime.boxToBoolean((boolean)shipDirs$1.add(path));
                }
                $this.logger().warn(new StringBuilder(51).append("Unrecognized schema [").append((String)schema).append("] for remote file/directory [").append(path).append("]").toString());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$addApplicationLabels$1(Label x$3) {
        return x$3 instanceof CodeLanguageLabel;
    }

    public static final /* synthetic */ boolean $anonfun$addApplicationLabels$2(Label x$4) {
        return x$4 instanceof EngineConnModeLabel;
    }

    public FlinkEngineConnFactory() {
        AbstractEngineConnFactory.$init$((AbstractEngineConnFactory)this);
        Logging.$init$((Logging)this);
        MultiExecutorEngineConnFactory.$init$((MultiExecutorEngineConnFactory)this);
        this.executorFactoryArray = (ExecutorFactory[])((Object[])new ExecutorFactory[]{(ExecutorFactory)ClassUtil$.MODULE$.getInstance(FlinkSQLExecutorFactory.class, new FlinkSQLExecutorFactory()), (ExecutorFactory)ClassUtil$.MODULE$.getInstance(FlinkApplicationExecutorFactory.class, new FlinkApplicationExecutorFactory()), (ExecutorFactory)ClassUtil$.MODULE$.getInstance(FlinkCodeExecutorFactory.class, new FlinkCodeExecutorFactory()), (ExecutorFactory)ClassUtil$.MODULE$.getInstance(FlinkManagerExecutorFactory.class, new FlinkManagerExecutorFactory())});
    }
}

