/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.executor.interceptor;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.once.executor.OnceExecutorExecutionContext;
import org.apache.linkis.engineconnplugin.flink.config.FlinkEnvConfiguration$;
import org.apache.linkis.engineconnplugin.flink.executor.interceptor.FlinkJobSubmitInterceptor;
import org.apache.linkis.engineconnplugin.flink.resource.FlinkJobResourceCleaner;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154Aa\u0002\u0005\u0001/!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00036\u0001\u0011\u0005c\u0007C\u0003F\u0001\u0011\u0005c\tC\u0003I\u0001\u0011\u0005\u0013\nC\u0003Z\u0001\u0011%!LA\u000eGY&t7NS8c%\u0016\u001c8\t\\3b]&sG/\u001a:dKB$xN\u001d\u0006\u0003\u0013)\t1\"\u001b8uKJ\u001cW\r\u001d;pe*\u00111\u0002D\u0001\tKb,7-\u001e;pe*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\t\u0001#\u001a8hS:,7m\u001c8oa2,x-\u001b8\u000b\u0005E\u0011\u0012A\u00027j].L7O\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0005\u0001aq\"\u0005\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0001j\u0011\u0001C\u0005\u0003C!\u0011\u0011D\u00127j].TuNY*vE6LG/\u00138uKJ\u001cW\r\u001d;peB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006kRLGn\u001d\u0006\u0003OA\taaY8n[>t\u0017BA\u0015%\u0005\u001daunZ4j]\u001e\fqa\u00197fC:,'\u000f\u0005\u0002-_5\tQF\u0003\u0002/\u0019\u0005A!/Z:pkJ\u001cW-\u0003\u00021[\t9b\t\\5oW*{'MU3t_V\u00148-Z\"mK\u0006tWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M\"\u0004CA\u0010\u0001\u0011\u0015Q#\u00011\u0001,\u00031\u0011WMZ8sKN+(-\\5u)\t9$\b\u0005\u0002\u001aq%\u0011\u0011H\u0007\u0002\u0005+:LG\u000fC\u0003<\u0007\u0001\u0007A(\u0001\u000fp]\u000e,W\t_3dkR|'/\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005u\u001aU\"\u0001 \u000b\u0005-y$B\u0001!B\u0003\u0011ygnY3\u000b\u0005\t\u0003\u0012AC3oO&tWmY8o]&\u0011AI\u0010\u0002\u001d\u001f:\u001cW-\u0012=fGV$xN]#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003I\tg\r^3s'V\u0014W.\u001b;Tk\u000e\u001cWm]:\u0015\u0005]:\u0005\"B\u001e\u0005\u0001\u0004a\u0014aD1gi\u0016\u00148+\u001e2nSR4\u0015-\u001b7\u0015\u0007]R5\nC\u0003<\u000b\u0001\u0007A\bC\u0003M\u000b\u0001\u0007Q*A\u0005uQJ|w/\u00192mKB\u0011aJ\u0016\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012BA+\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0013QC'o\\<bE2,'BA+\u001b\u00039\u0019G.Z1o%\u0016\u001cx.\u001e:dKN$\"aN.\t\u000bq3\u0001\u0019A/\u0002\u000f=\u0004H/[8ogB!alY3f\u001b\u0005y&B\u00011b\u0003\u0011)H/\u001b7\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0004\u001b\u0006\u0004\bC\u00014k\u001d\t9\u0007\u000e\u0005\u0002Q5%\u0011\u0011NG\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j5\u0001")
public class FlinkJobResCleanInterceptor
implements FlinkJobSubmitInterceptor,
Logging {
    private final FlinkJobResourceCleaner cleaner;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FlinkJobResCleanInterceptor flinkJobResCleanInterceptor = this;
        synchronized (flinkJobResCleanInterceptor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public void beforeSubmit(OnceExecutorExecutionContext onceExecutorExecutionContext) {
    }

    @Override
    public void afterSubmitSuccess(OnceExecutorExecutionContext onceExecutorExecutionContext) {
        this.logger().info("Clean the flink job resource after success to submit");
        this.cleanResources(onceExecutorExecutionContext.getEngineCreationContext().getOptions());
    }

    @Override
    public void afterSubmitFail(OnceExecutorExecutionContext onceExecutorExecutionContext, Throwable throwable) {
        this.logger().info("Clean the flink job resource after fail to submit");
        this.cleanResources(onceExecutorExecutionContext.getEngineCreationContext().getOptions());
    }

    private void cleanResources(Map<String, String> options) {
        String mainClassJar = (String)FlinkEnvConfiguration$.MODULE$.FLINK_APPLICATION_MAIN_CLASS_JAR().getValue(options);
        this.logger().trace(new StringBuilder(23).append("mainClassJar to clean: ").append(mainClassJar).toString());
        if (StringUtils.isNotBlank((CharSequence)mainClassJar) && this.cleaner.accept(mainClassJar)) {
            this.cleaner.cleanup((String[])((Object[])new String[]{mainClassJar}));
        }
        String[] shipDirsArray = ((String)FlinkEnvConfiguration$.MODULE$.FLINK_SHIP_DIRECTORIES().getValue(options)).split(",");
        this.logger().trace(new StringBuilder(27).append("Ship directories to clean: ").append(shipDirsArray.length).toString());
        String[] stringArray = shipDirsArray;
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            this.cleaner.cleanup((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray2)).filter((Function1 & java.io.Serializable & Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)this.cleaner.accept(resource))));
            return;
        }
    }

    public FlinkJobResCleanInterceptor(FlinkJobResourceCleaner cleaner) {
        this.cleaner = cleaner;
        Logging.$init$((Logging)this);
    }
}

