/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.SessionState;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.Environment;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationUtil;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class SetOperation
implements NonJobOperation {
    private final FlinkEngineConnContext context;
    private final String key;
    private final String value;

    public SetOperation(FlinkEngineConnContext context, String key, String value) {
        this.context = context;
        this.key = key;
        this.value = value;
    }

    public SetOperation(FlinkEngineConnContext context) {
        this(context, null, null);
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        ExecutionContext executionContext = this.context.getExecutionContext();
        Environment env = executionContext.getEnvironment();
        if (this.key == null) {
            ArrayList<Row> data = new ArrayList<Row>();
            Tuple2 maxKeyLenAndMaxValueLen = new Tuple2((Object)1, (Object)1);
            this.buildResult(env.getExecution().asTopLevelMap(), data, (Tuple2<Integer, Integer>)maxKeyLenAndMaxValueLen);
            this.buildResult(env.getDeployment().asTopLevelMap(), data, (Tuple2<Integer, Integer>)maxKeyLenAndMaxValueLen);
            this.buildResult(env.getConfiguration().asMap(), data, (Tuple2<Integer, Integer>)maxKeyLenAndMaxValueLen);
            return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create("key", (LogicalType)new VarCharType(true, ((Integer)maxKeyLenAndMaxValueLen.f0).intValue())), ColumnInfo.create("value", (LogicalType)new VarCharType(true, ((Integer)maxKeyLenAndMaxValueLen.f1).intValue()))).data(data).build();
        }
        Environment newEnv = Environment.enrich((Environment)env, Collections.singletonMap(this.key.trim(), this.value.trim()), Collections.emptyMap());
        SessionState sessionState = executionContext.getSessionState();
        ExecutionContext.Builder builder = this.context.newExecutionContextBuilder(this.context.getEnvironmentContext().getDefaultEnv()).env(newEnv).sessionState(sessionState);
        this.context.setExecutionContext(executionContext.cloneExecutionContext(builder));
        return OperationUtil.OK;
    }

    private void buildResult(Map<String, String> properties, List<Row> data, Tuple2<Integer, Integer> maxKeyLenAndMaxValueLen) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            data.add(Row.of((Object[])new Object[]{key, value}));
            maxKeyLenAndMaxValueLen.f0 = Math.max((Integer)maxKeyLenAndMaxValueLen.f0, key.length());
            maxKeyLenAndMaxValueLen.f1 = Math.max((Integer)maxKeyLenAndMaxValueLen.f1, value.length());
        }
    }
}

