/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.deployment;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.deployment.AbstractApplicationClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.JobExecutionException;

public class YarnApplicationClusterDescriptorAdapter
extends AbstractApplicationClusterDescriptorAdapter {
    YarnApplicationClusterDescriptorAdapter(ExecutionContext executionContext) {
        super(executionContext);
    }

    @Override
    public void deployCluster(String[] programArguments, String applicationClassName) throws JobExecutionException {
        ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration(programArguments, applicationClassName);
        ClusterSpecification clusterSpecification = this.executionContext.getClusterClientFactory().getClusterSpecification(this.executionContext.getFlinkConfig());
        YarnClusterDescriptor clusterDescriptor = this.executionContext.createClusterDescriptor();
        try {
            ClusterClientProvider clusterClientProvider = clusterDescriptor.deployApplicationCluster(clusterSpecification, applicationConfiguration);
            this.clusterClient = clusterClientProvider.getClusterClient();
            this.clusterID = (ApplicationId)this.clusterClient.getClusterId();
            this.webInterfaceUrl = this.clusterClient.getWebInterfaceURL();
        }
        catch (Exception e) {
            throw new JobExecutionException(ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
        }
        this.bindApplicationId();
    }

    @Override
    public boolean initJobId() throws Exception {
        ((CompletableFuture)this.clusterClient.listJobs().thenAccept(list -> list.forEach(jobStatusMessage -> {
            if (Objects.nonNull(jobStatusMessage.getJobId())) {
                this.setJobId(jobStatusMessage.getJobId());
            }
        }))).get(CLIENT_REQUEST_TIMEOUT, TimeUnit.MILLISECONDS);
        return null != this.getJobId();
    }

    @Override
    public boolean isGloballyTerminalState() {
        return false;
    }
}

