/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.restful;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.auth.AuthContext;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceType;
import org.apache.linkis.datasourcemanager.common.domain.DatasourceVersion;
import org.apache.linkis.datasourcemanager.common.errorcode.LinkisDatasourceManagerErrorCodeSummary;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.datasourcemanager.core.formdata.FormDataTransformerFactory;
import org.apache.linkis.datasourcemanager.core.formdata.MultiPartFormDataTransformer;
import org.apache.linkis.datasourcemanager.core.restful.RestfulApiHelper;
import org.apache.linkis.datasourcemanager.core.service.DataSourceInfoService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.apache.linkis.datasourcemanager.core.service.MetadataOperateService;
import org.apache.linkis.datasourcemanager.core.service.hooks.DataSourceParamsHook;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidator;
import org.apache.linkis.datasourcemanager.core.vo.DataSourceVo;
import org.apache.linkis.metadata.query.common.MdmConfiguration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"data source core restful api"})
@RestController
@RequestMapping(value={"/data-source-manager"}, produces={"application/json"})
public class DataSourceCoreRestfulApi {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceCoreRestfulApi.class);
    @Autowired
    private DataSourceInfoService dataSourceInfoService;
    @Autowired
    private DataSourceRelateService dataSourceRelateService;
    @Autowired
    private ParameterValidator parameterValidator;
    @Autowired
    private Validator beanValidator;
    @Autowired
    private MetadataOperateService metadataOperateService;
    private MultiPartFormDataTransformer formDataTransformer;
    @Autowired
    private List<DataSourceParamsHook> dataSourceParamsHooks = new ArrayList<DataSourceParamsHook>();

    @PostConstruct
    public void initRestful() {
        this.formDataTransformer = FormDataTransformerFactory.buildCustom();
    }

    @ApiOperation(value="getAllDataSourceTypes", notes="get all data source types", response=Message.class)
    @RequestMapping(value={"/type/all"}, method={RequestMethod.GET})
    public Message getAllDataSourceTypes(HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"getAllDataSourceTypes");
            List<DataSourceType> dataSourceTypes = this.dataSourceRelateService.getAllDataSourceTypes(request.getHeader("Content-Language"));
            return Message.ok().data("typeList", dataSourceTypes);
        }, "Fail to get all types of data source[\u83b7\u53d6\u6570\u636e\u6e90\u7c7b\u578b\u5217\u8868\u5931\u8d25]");
    }

    @ApiOperation(value="getKeyDefinitionsByType", notes="get key definitions by type", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="typeId", required=true, dataType="Long")})
    @RequestMapping(value={"/key-define/type/{typeId}"}, method={RequestMethod.GET})
    public Message getKeyDefinitionsByType(@PathVariable(value="typeId") Long dataSourceTypeId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"getKeyDefinitionsByType");
            List<DataSourceParamKeyDefinition> keyDefinitions = this.dataSourceRelateService.getKeyDefinitionsByType(dataSourceTypeId, request.getHeader("Content-Language"));
            return Message.ok().data("keyDefine", keyDefinitions);
        }, "Fail to get key definitions of data source type[\u67e5\u8be2\u6570\u636e\u6e90\u53c2\u6570\u952e\u503c\u5bf9\u5931\u8d25]");
    }

    @ApiOperation(value="insertJsonInfo", notes="insert json info", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"dataSource"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="createSystem", required=true, dataType="String", example="linkis"), @ApiImplicitParam(name="dataSourceDesc", required=true, dataType="String"), @ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="dataSourceTypeId", required=true, dataType="String"), @ApiImplicitParam(name="labels", required=true, dataType="String"), @ApiImplicitParam(name="connectParams", required=true, dataType="List"), @ApiImplicitParam(name="host", dataType="String", example="127.0.0.1"), @ApiImplicitParam(name="password", dataType="String"), @ApiImplicitParam(name="port", dataType="String", example="9523"), @ApiImplicitParam(name="subSystem", dataType="String"), @ApiImplicitParam(name="username", dataType="String")})
    @RequestMapping(value={"/info/json"}, method={RequestMethod.POST})
    public Message insertJsonInfo(@RequestBody DataSource dataSource, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"insertJsonInfo");
            Set result = this.beanValidator.validate((Object)dataSource, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            dataSource.setCreateUser(userName);
            if (this.dataSourceInfoService.existDataSource(dataSource.getDataSourceName())) {
                return Message.error((String)("The data source named: " + dataSource.getDataSourceName() + " has been existed [\u6570\u636e\u6e90: " + dataSource.getDataSourceName() + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            this.insertDataSource(dataSource);
            return Message.ok().data("insertId", (Object)dataSource.getId());
        }, "Fail to insert data source[\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @ApiOperation(value="updateDataSourceInJson", notes="update data source in json", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long"), @ApiImplicitParam(name="createSystem", required=true, dataType="String", example="Linkis"), @ApiImplicitParam(name="createTime", required=true, dataType="String", example="1650426189000"), @ApiImplicitParam(name="createUser", required=true, dataType="String", example="hive"), @ApiImplicitParam(name="dataSourceDesc", required=true, dataType="String"), @ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="dataSourceTypeId", required=true, dataType="String"), @ApiImplicitParam(name="labels", required=true, dataType="String"), @ApiImplicitParam(name="connectParams", required=true, dataType="List"), @ApiImplicitParam(name="host", dataType="String", example="127.0.0.1"), @ApiImplicitParam(name="password", dataType="String"), @ApiImplicitParam(name="port", dataType="String", example="9523"), @ApiImplicitParam(name="subSystem", dataType="String"), @ApiImplicitParam(name="username", dataType="String"), @ApiImplicitParam(name="expire", dataType="boolean", example="false"), @ApiImplicitParam(name="file", dataType="String", example="adn"), @ApiImplicitParam(name="modifyTime", dataType="String", example="1657611440000"), @ApiImplicitParam(name="modifyUser", dataType="String", example="hadoop"), @ApiImplicitParam(name="versionId", dataType="String", example="18")})
    @ApiOperationSupport(ignoreParameters={"dataSource"})
    @RequestMapping(value={"/info/{dataSourceId}/json"}, method={RequestMethod.PUT})
    public Message updateDataSourceInJson(@RequestBody DataSource dataSource, @PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"updateDataSourceInJson");
            Set result = this.beanValidator.validate((Object)dataSource, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            dataSource.setId(dataSourceId);
            dataSource.setModifyUser(userName);
            dataSource.setModifyTime(Calendar.getInstance().getTime());
            DataSource storedDataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (null == storedDataSource) {
                return Message.error((String)"This data source was not found [\u66f4\u65b0\u6570\u636e\u6e90\u5931\u8d25]");
            }
            if (!AuthContext.hasPermission((DataSource)storedDataSource, (String)userName)) {
                return Message.error((String)"Don't have update permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u66f4\u65b0\u6743\u9650]");
            }
            String dataSourceName = dataSource.getDataSourceName();
            if (!Objects.equals(dataSourceName, storedDataSource.getDataSourceName()) && this.dataSourceInfoService.existDataSource(dataSourceName)) {
                return Message.error((String)("The data source named: " + dataSourceName + " has been existed [\u6570\u636e\u6e90: " + dataSourceName + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            dataSource.setKeyDefinitions(keyDefinitionList);
            Map connectParams = dataSource.getConnectParams();
            keyDefinitionList.forEach(keyDefinition -> {
                String key = keyDefinition.getKey();
                if (StringUtils.isNotBlank((CharSequence)keyDefinition.getDefaultValue()) && !connectParams.containsKey(key)) {
                    connectParams.put(key, keyDefinition.getDefaultValue());
                }
            });
            for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
                hook.beforePersist(connectParams, keyDefinitionList);
            }
            String parameter = Json.toJson((Object)connectParams, null);
            dataSource.setParameter(parameter);
            this.dataSourceInfoService.updateDataSourceInfo(dataSource);
            return Message.ok().data("updateId", (Object)dataSourceId);
        }, "Fail to update data source[\u66f4\u65b0\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @ApiOperation(value="insertJsonParameter", notes="insert json parameter", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long")})
    @ApiOperationSupport(ignoreParameters={"params"})
    @RequestMapping(value={"/parameter/{dataSourceId}/json"}, method={RequestMethod.POST})
    public Message insertJsonParameter(@PathVariable(value="dataSourceId") Long dataSourceId, @RequestBody Map<String, Object> params, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"insertJsonParameter");
            Map connectParams = (Map)params.get("connectParams");
            String comment = params.get("comment").toString();
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (null == dataSource) {
                throw new ErrorException(LinkisDatasourceManagerErrorCodeSummary.DATASOURCE_NOT_FOUND.getErrorCode(), LinkisDatasourceManagerErrorCodeSummary.DATASOURCE_NOT_FOUND.getErrorDesc());
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have update permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u66f4\u65b0\u6743\u9650]");
            }
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            this.formatConnectParams(keyDefinitionList, connectParams);
            this.parameterValidator.validate(keyDefinitionList, connectParams);
            RestfulApiHelper.encryptPasswordKey(keyDefinitionList, connectParams);
            long versionId = this.dataSourceInfoService.insertDataSourceParameter(keyDefinitionList, dataSourceId, connectParams, userName, comment);
            return Message.ok().data("version", (Object)versionId);
        }, "Fail to insert data source parameter [\u4fdd\u5b58\u6570\u636e\u6e90\u53c2\u6570\u5931\u8d25]");
    }

    @ApiOperation(value="getInfoByDataSourceId", notes="get info by data source id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long")})
    @RequestMapping(value={"/info/{dataSourceId}"}, method={RequestMethod.GET})
    public Message getInfoByDataSourceId(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getInfoByDataSourceId dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfo(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            RestfulApiHelper.decryptPasswordKey(keyDefinitionList, dataSource.getConnectParams());
            return Message.ok().data("info", (Object)dataSource);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="getInfoByDataSourceName", notes="get info by data source name", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String")})
    @RequestMapping(value={"/info/name/{dataSourceName}"}, method={RequestMethod.GET})
    public Message getInfoByDataSourceName(@PathVariable(value="dataSourceName") String dataSourceName, HttpServletRequest request) throws UnsupportedEncodingException {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getInfoByDataSourceName dataSourceName:" + dataSourceName));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfo(dataSourceName);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            RestfulApiHelper.decryptPasswordKey(keyDefinitionList, dataSource.getConnectParams());
            return Message.ok().data("info", (Object)dataSource);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="getPublishedInfoByDataSourceName", notes="get published info by data source name", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String")})
    @RequestMapping(value={"/publishedInfo/name/{dataSourceName}"}, method={RequestMethod.GET})
    public Message getPublishedInfoByDataSourceName(@PathVariable(value="dataSourceName") String dataSourceName, HttpServletRequest request) throws UnsupportedEncodingException {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getPublishedInfoByDataSourceName dataSourceName:" + dataSourceName));
            DataSource dataSource = this.dataSourceInfoService.getDataSourcePublishInfo(dataSourceName);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            RestfulApiHelper.decryptPasswordKey(keyDefinitionList, dataSource.getConnectParams());
            return Message.ok().data("info", (Object)dataSource);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="getInfoByDataSourceIdAndVersion", notes="get info by data source id and version", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long"), @ApiImplicitParam(name="version", required=true, dataType="Long")})
    @RequestMapping(value={"/info/{dataSourceId}/{version}"}, method={RequestMethod.GET})
    public Message getInfoByDataSourceIdAndVersion(@PathVariable(value="dataSourceId") Long dataSourceId, @PathVariable(value="version") Long version, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getInfoByDataSourceIdAndVersion dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfo(dataSourceId, version);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            RestfulApiHelper.decryptPasswordKey(keyDefinitionList, dataSource.getConnectParams());
            return Message.ok().data("info", (Object)dataSource);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="getVersionList", notes="get version list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long")})
    @RequestMapping(value={"/{dataSourceId}/versions"}, method={RequestMethod.GET})
    public Message getVersionList(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getVersionList dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            List<DatasourceVersion> versions = this.dataSourceInfoService.getVersionList(dataSourceId);
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            if (null != versions) {
                versions.forEach(version -> RestfulApiHelper.decryptPasswordKey(keyDefinitionList, version.getConnectParams()));
            }
            return Message.ok().data("versions", versions);
        }, "Fail to access data source[\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="publishByDataSourceId", notes="publish by datasource id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long"), @ApiImplicitParam(name="version", required=true, dataType="Long")})
    @RequestMapping(value={"/publish/{dataSourceId}/{versionId}"}, method={RequestMethod.POST})
    public Message publishByDataSourceId(@PathVariable(value="dataSourceId") Long dataSourceId, @PathVariable(value="versionId") Long versionId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("publishByDataSourceId dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have publish permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u53d1\u5e03\u6743\u9650]");
            }
            int updateResult = this.dataSourceInfoService.publishByDataSourceId(dataSourceId, versionId);
            if (0 == updateResult) {
                return Message.error((String)"publish error");
            }
            return Message.ok();
        }, "Fail to publish datasource[\u6570\u636e\u6e90\u7248\u672c\u53d1\u5e03\u5931\u8d25]");
    }

    @ApiOperation(value="removeDataSource", notes="remove datasource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long")})
    @RequestMapping(value={"/info/delete/{dataSourceId}"}, method={RequestMethod.DELETE})
    public Message removeDataSource(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("removeDataSource dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have delete permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u5220\u9664\u6743\u9650]");
            }
            Long removeId = this.dataSourceInfoService.removeDataSourceInfo(dataSourceId, "");
            if (removeId < 0L) {
                return Message.error((String)("Fail to remove data source[\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25], [id:" + dataSourceId + "]"));
            }
            return Message.ok().data("removeId", (Object)removeId);
        }, "Fail to remove data source[\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="expireDataSource", notes="expire data source", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long")})
    @RequestMapping(value={"/info/{dataSourceId}/expire"}, method={RequestMethod.PUT})
    public Message expireDataSource(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("expireDataSource dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoBrief(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have operation permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u64cd\u4f5c\u6743\u9650]");
            }
            Long expireId = this.dataSourceInfoService.expireDataSource(dataSourceId);
            if (expireId < 0L) {
                return Message.error((String)("Fail to expire data source[\u6570\u636e\u6e90\u8fc7\u671f\u5931\u8d25], [id:" + dataSourceId + "]"));
            }
            return Message.ok().data("expireId", (Object)expireId);
        }, "Fail to expire data source[\u6570\u636e\u6e90\u8fc7\u671f\u5931\u8d25]");
    }

    @ApiOperation(value="getConnectParams(dataSourceId)", notes="get connect params(dataSourceId)", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long")})
    @RequestMapping(value={"/{dataSourceId}/connect-params"}, method={RequestMethod.GET})
    public Message getConnectParams(@PathVariable(value="dataSourceId") Long dataSourceId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getConnectParams dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dataSourceId);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            Map connectParams = dataSource.getConnectParams();
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            RestfulApiHelper.decryptPasswordKey(keyDefinitionList, connectParams);
            return Message.ok().data("connectParams", (Object)connectParams);
        }, "Fail to connect data source[\u8fde\u63a5\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @ApiOperation(value="getConnectParams(dataSourceName)", notes="get connect params(dataSourceName)", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String")})
    @RequestMapping(value={"/name/{dataSourceName}/connect-params"}, method={RequestMethod.GET})
    public Message getConnectParams(@PathVariable(value="dataSourceName") String dataSourceName, HttpServletRequest request) throws UnsupportedEncodingException {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getConnectParams dataSourceName:" + dataSourceName));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dataSourceName);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)userName)) {
                return Message.error((String)"Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            Map connectParams = dataSource.getConnectParams();
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            RestfulApiHelper.decryptPasswordKey(keyDefinitionList, connectParams);
            return Message.ok().data("connectParams", (Object)connectParams);
        }, "Fail to connect data source[\u8fde\u63a5\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @ApiOperation(value="connectDataSource", notes="connect datasource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", required=true, dataType="Long"), @ApiImplicitParam(name="version", required=true, dataType="Long")})
    @RequestMapping(value={"/{dataSourceId}/{version}/op/connect"}, method={RequestMethod.PUT})
    public Message connectDataSource(@PathVariable(value="dataSourceId") Long dataSourceId, @PathVariable(value="version") Long version, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String operator = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("connectDataSource dataSourceId:" + dataSourceId));
            DataSource dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dataSourceId, version);
            if (dataSource == null) {
                return Message.error((String)"No Exists The DataSource [\u4e0d\u5b58\u5728\u8be5\u6570\u636e\u6e90]");
            }
            if (!AuthContext.hasPermission((DataSource)dataSource, (String)operator)) {
                return Message.error((String)"Don't have operation permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u64cd\u4f5c\u6743\u9650]");
            }
            String dataSourceTypeName = dataSource.getDataSourceType().getName();
            String mdRemoteServiceName = (String)MdmConfiguration.METADATA_SERVICE_APPLICATION.getValue();
            Map connectParams = dataSource.getConnectParams();
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
            RestfulApiHelper.decryptPasswordKey(keyDefinitionList, connectParams);
            for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
                hook.beforePersist(connectParams, keyDefinitionList);
            }
            this.metadataOperateService.doRemoteConnect(mdRemoteServiceName, dataSourceTypeName.toLowerCase(), operator, dataSource.getConnectParams());
            return Message.ok().data("ok", (Object)true);
        }, "Fail to connect data source[\u8fde\u63a5\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @ApiOperation(value="queryDataSourceByIds", notes="query datasource by ids", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", required=true, dataType="List")})
    @RequestMapping(value={"/info/ids"}, method={RequestMethod.GET})
    public Message queryDataSource(@RequestParam(value="ids") String idsJson, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("queryDataSourceByIds ids:" + idsJson));
            List ids = (List)new ObjectMapper().readValue(idsJson, List.class);
            List<DataSource> dataSourceList = this.dataSourceInfoService.queryDataSourceInfo(ids);
            return Message.ok().data("queryList", dataSourceList).data("totalPage", (Object)dataSourceList.size());
        }, "Fail to query page of data source[\u67e5\u8be2\u6570\u636e\u6e90\u5931\u8d25]");
    }

    @ApiOperation(value="queryDataSource", notes="query datasource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="system", dataType="String"), @ApiImplicitParam(name="name", dataType="Long"), @ApiImplicitParam(name="typeId", dataType="Long"), @ApiImplicitParam(name="identifies", dataType="String"), @ApiImplicitParam(name="currentPage", dataType="Integer"), @ApiImplicitParam(name="pageSize", dataType="Integer")})
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public Message queryDataSource(@RequestParam(value="system", required=false) String createSystem, @RequestParam(value="name", required=false) String dataSourceName, @RequestParam(value="typeId", required=false) Long dataSourceTypeId, @RequestParam(value="identifies", required=false) String identifies, @RequestParam(value="currentPage", required=false) Integer currentPage, @RequestParam(value="pageSize", required=false) Integer pageSize, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String permissionUser = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"queryDataSource");
            DataSourceVo dataSourceVo = new DataSourceVo(dataSourceName, dataSourceTypeId, identifies, createSystem);
            dataSourceVo.setCurrentPage(null != currentPage ? currentPage : 1);
            dataSourceVo.setPageSize(null != pageSize ? pageSize : 10);
            if (AuthContext.isAdministrator((String)permissionUser)) {
                permissionUser = null;
            }
            dataSourceVo.setPermissionUser(permissionUser);
            PageInfo<DataSource> pageInfo = this.dataSourceInfoService.queryDataSourceInfoPage(dataSourceVo);
            List queryList = pageInfo.getList();
            return Message.ok().data("queryList", (Object)queryList).data("totalPage", (Object)pageInfo.getTotal());
        }, "Fail to query page of data source[\u67e5\u8be2\u6570\u636e\u6e90\u5931\u8d25]");
    }

    private void insertDataSource(DataSource dataSource) throws ErrorException {
        List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
        dataSource.setKeyDefinitions(keyDefinitionList);
        Map connectParams = dataSource.getConnectParams();
        this.formatConnectParams(keyDefinitionList, connectParams);
        for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
            hook.beforePersist(connectParams, keyDefinitionList);
        }
        String parameter = Json.toJson((Object)connectParams, null);
        dataSource.setParameter(parameter);
        this.dataSourceInfoService.saveDataSourceInfo(dataSource);
    }

    private void formatConnectParams(List<DataSourceParamKeyDefinition> keyDefinitionList, Map<String, Object> connectParams) {
        keyDefinitionList.forEach(keyDefinition -> {
            String key = keyDefinition.getKey();
            if (StringUtils.isNotBlank((CharSequence)keyDefinition.getDefaultValue()) && !connectParams.containsKey(key)) {
                connectParams.put(key, keyDefinition.getDefaultValue());
            }
        });
        connectParams.forEach((k, v) -> {
            if (v instanceof String) {
                connectParams.put((String)k, v.toString().trim());
            }
        });
    }
}

