/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.parser;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.contextcache.conf.ContextCacheConf;
import org.apache.linkis.cs.contextcache.parser.ContextKeyValueParser;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultContextKeyValueParser
implements ContextKeyValueParser {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextKeyValueParser.class);
    private ObjectMapper jackson = BDPJettyServerHelper.jacksonJson();

    @PostConstruct
    private void init() {
        logger.info("init keyValueParser");
    }

    @Override
    public Set<String> parse(ContextKeyValue contextKeyValue) {
        HashSet<String> keywordSet;
        block6: {
            keywordSet = new HashSet<String>();
            try {
                if (contextKeyValue == null || contextKeyValue.getContextValue() == null || !StringUtils.isNotBlank((CharSequence)contextKeyValue.getContextValue().getKeywords())) break block6;
                String keywordObj = contextKeyValue.getContextValue().getKeywords();
                try {
                    Set keySet = (Set)this.jackson.readValue(keywordObj, (TypeReference)new TypeReference<Set<String>>(){});
                    keywordSet.addAll(keySet);
                }
                catch (Exception e) {
                    String[] keywords;
                    logger.info("deal Exception", (Throwable)e);
                    for (String keyword : keywords = keywordObj.split(ContextCacheConf.KEYWORD_SPLIT)) {
                        keywordSet.add(keyword);
                    }
                }
                keywordSet.add(contextKeyValue.getContextKey().getKey());
            }
            catch (Exception e) {
                if (null != contextKeyValue && null != contextKeyValue.getContextKey() && StringUtils.isNotBlank((CharSequence)contextKeyValue.getContextKey().getKey())) {
                    logger.error("Failed to parse keywords of " + contextKeyValue.getContextKey().getKey(), (Throwable)e);
                }
                logger.error("Failed to parse keywords of contextKey", (Throwable)e);
            }
        }
        return keywordSet;
    }
}

