/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTableReader
implements IReadableTable.TableReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcTableReader.class);
    private static final String DATABASE_AND_TABLE = "%s.%s";
    private String dbName;
    private String tableName;
    private Connection conn;
    private Statement statement;
    private ResultSet rs;
    private int colCount;

    public JdbcTableReader(JdbcConnector dataSource, TableDesc tableDesc) throws IOException {
        this.dbName = tableDesc.getDatabase();
        this.tableName = tableDesc.getName();
        String sql = dataSource.convertSql(this.generateSelectDataStatement(tableDesc));
        try {
            this.conn = dataSource.getConnection();
            this.statement = this.conn.createStatement();
            this.rs = this.statement.executeQuery(sql);
            this.colCount = this.rs.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            log.error("error when get jdbc tableReader.", (Throwable)e);
            throw new IOException(String.format(Locale.ROOT, "error while exec %s", sql));
        }
    }

    public boolean next() throws IOException {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public String[] getRow() {
        String[] ret = new String[this.colCount];
        for (int i = 1; i <= this.colCount; ++i) {
            try {
                Object o = this.rs.getObject(i);
                String result = null == o || o instanceof byte[] ? null : o.toString();
                ret[i - 1] = result;
                continue;
            }
            catch (Exception e) {
                log.error("Failed to get row", (Throwable)e);
            }
        }
        return ret;
    }

    public void close() throws IOException {
        DBUtils.closeQuietly((ResultSet)this.rs);
        DBUtils.closeQuietly((Statement)this.statement);
        DBUtils.closeQuietly((Connection)this.conn);
    }

    public String toString() {
        return "jdbc table reader for: " + this.dbName + "." + this.tableName;
    }

    private String generateSelectDataStatement(TableDesc tableDesc) {
        ArrayList columns = Lists.newArrayList();
        for (int i = 0; i < tableDesc.getColumns().length; ++i) {
            ColumnDesc columnDesc = tableDesc.getColumns()[i];
            columns.add(String.format(Locale.ROOT, DATABASE_AND_TABLE, tableDesc.getName(), columnDesc.getName()));
        }
        String sep = " ";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT").append(" ").append(StringUtils.join((Iterable)columns, (String)",")).append(" ").append("FROM").append(" ").append(String.format(Locale.ROOT, DATABASE_AND_TABLE, tableDesc.getDatabase(), tableDesc.getName()));
        return sql.toString();
    }
}

