/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import java.util.Locale;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.jdbc.JdbcTableReader;

public class JdbcTable
implements IReadableTable {
    private final JdbcConnector dataSource;
    private final String database;
    private final String tableName;
    private final TableDesc tableDesc;

    public JdbcTable(JdbcConnector dataSource, TableDesc tableDesc) {
        this.dataSource = dataSource;
        this.tableDesc = tableDesc;
        this.database = tableDesc.getDatabase();
        this.tableName = tableDesc.getName();
    }

    public IReadableTable.TableReader getReader() throws IOException {
        return new JdbcTableReader(this.dataSource, this.tableDesc);
    }

    public IReadableTable.TableSignature getSignature() {
        String path = String.format(Locale.ROOT, "%s.%s", this.database, this.tableName);
        return new IReadableTable.TableSignature(path, 0L, System.currentTimeMillis());
    }

    public boolean exists() {
        return true;
    }

    public String toString() {
        return "database=[" + this.database + "], table=[" + this.tableName + "]";
    }
}

