/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ControllerSplitter {
    static File v1dir = new File("src/main/java/org/apache/kylin/rest/controller");
    static File v2dir = new File("src/main/java/org/apache/kylin/rest/controller2");
    static boolean dryRun = false;

    public static void main(String[] args) throws IOException {
        for (File f : v1dir.listFiles()) {
            ControllerSplitter.chopOff(f, "application/vnd.apache.kylin-v2+json");
        }
        for (File f : v2dir.listFiles()) {
            ControllerSplitter.chopOff(f, "application/json");
        }
    }

    private static void chopOff(File f, String annoPtn) throws IOException {
        System.out.println("Processing " + f);
        List lines = new ArrayList(0);
        try (FileInputStream is = new FileInputStream(f);){
            lines = IOUtils.readLines((InputStream)is, (String)"UTF-8");
        }
        ArrayList<String> outLines = new ArrayList<String>(lines.size());
        boolean del = false;
        for (String l : lines) {
            if (l.startsWith("    @") && l.contains(annoPtn)) {
                del = true;
            }
            if (del) {
                System.out.println("x " + l);
            } else {
                outLines.add(l);
            }
            if (!del || !l.startsWith("    }")) continue;
            del = false;
        }
        if (!dryRun && outLines.size() < lines.size()) {
            FileOutputStream os = new FileOutputStream(f);
            IOUtils.writeLines(outLines, (String)"\n", (OutputStream)os, (String)"UTF-8");
            os.close();
            System.out.println("UPDATED " + f);
        } else {
            System.out.println("skipped");
        }
        System.out.println("============================================================================");
    }
}

