/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.update;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Locale;

public class TableSchemaUpdateMapping {
    private String database;
    private String tableName;

    public boolean isDatabaseChanged() {
        return !Strings.isNullOrEmpty((String)this.database);
    }

    public String getDatabase(String dbName) {
        String ret = this.isDatabaseChanged() ? this.database : dbName;
        return ret.toUpperCase(Locale.ROOT);
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean isTableNameChanged() {
        return !Strings.isNullOrEmpty((String)this.tableName);
    }

    public String getTableName(String tblName) {
        String ret = this.isTableNameChanged() ? this.tableName : tblName;
        return ret.toUpperCase(Locale.ROOT);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isTableIdentityChanged() {
        return this.isDatabaseChanged() || this.isTableNameChanged();
    }

    public String getTableIdentity(String tableIdentity) {
        String[] tableNameEs = tableIdentity.split("\\.");
        Preconditions.checkArgument((tableNameEs.length == 2 ? 1 : 0) != 0);
        return this.getTableIdentity(tableNameEs[0], tableNameEs[1]);
    }

    public String getTableIdentity(String database, String tableName) {
        return this.getDatabase(database) + "." + this.getTableName(tableName);
    }
}

