/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security.springacl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SidInfo {
    @JsonProperty(value="sid")
    private String sid;
    @JsonProperty(value="principal")
    private boolean isPrincipal;
    private transient Sid sidObj;

    public SidInfo() {
    }

    public SidInfo(Sid sid) {
        if (sid instanceof PrincipalSid) {
            this.sid = ((PrincipalSid)sid).getPrincipal();
            this.isPrincipal = true;
        } else if (sid instanceof GrantedAuthoritySid) {
            this.sid = ((GrantedAuthoritySid)sid).getGrantedAuthority();
            this.isPrincipal = false;
        } else {
            throw new IllegalStateException();
        }
    }

    public String getSid() {
        return this.sid;
    }

    public boolean isPrincipal() {
        return this.isPrincipal;
    }

    public Sid getSidObj() {
        if (this.sidObj == null) {
            this.sidObj = this.isPrincipal ? new PrincipalSid(this.sid) : new GrantedAuthoritySid(this.sid);
        }
        return this.sidObj;
    }
}

