/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.storage.hbase.util.HBaseRegionSizeCalculator;
import org.apache.kylin.storage.hbase.util.HBaseUnionUtil;

public class HBaseInfoUtil {
    public static HBaseResponse getHBaseInfo(String tableName, KylinConfig config) throws IOException {
        if (!config.getStorageUrl().getScheme().equals("hbase")) {
            return null;
        }
        Connection conn = HBaseUnionUtil.getConnection((KylinConfig)config, (String)tableName);
        HBaseResponse hr = null;
        long tableSize = 0L;
        int regionCount = 0;
        HBaseRegionSizeCalculator cal = new HBaseRegionSizeCalculator(tableName, conn);
        Map sizeMap = cal.getRegionSizeMap();
        Iterator iterator = sizeMap.values().iterator();
        while (iterator.hasNext()) {
            long s = (Long)iterator.next();
            tableSize += s;
        }
        regionCount = sizeMap.size();
        hr = new HBaseResponse();
        hr.setTableSize(tableSize);
        hr.setRegionCount(regionCount);
        return hr;
    }
}

