/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="extFilterService")
public class ExtFilterService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ExtFilterService.class);

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void saveExternalFilter(ExternalFilterDesc desc) throws IOException {
        Message msg = MsgPicker.getMsg();
        if (this.getTableManager().getExtFilterDesc(desc.getName()) != null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getFILTER_ALREADY_EXIST(), desc.getName()));
        }
        this.getTableManager().saveExternalFilter(desc);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void updateExternalFilter(ExternalFilterDesc desc) throws IOException {
        Message msg = MsgPicker.getMsg();
        if (this.getTableManager().getExtFilterDesc(desc.getName()) == null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getFILTER_NOT_FOUND(), desc.getName()));
        }
        this.getTableManager().saveExternalFilter(desc);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeExternalFilter(String name) throws IOException {
        this.getTableManager().removeExternalFilter(name);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void syncExtFilterToProject(String[] filters, String project) throws IOException {
        this.getProjectManager().addExtFilterToProject(filters, project);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeExtFilterFromProject(String filterName, String projectName) throws IOException {
        this.getProjectManager().removeExtFilterFromProject(filterName, projectName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<ExternalFilterDesc> listAllExternalFilters() {
        return this.getTableManager().listAllExternalFilters();
    }
}

