/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.metrics;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.metrics.MetricsManager;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.metrics.lib.impl.RecordEvent;
import org.apache.kylin.metrics.lib.impl.TimedRecordEvent;
import org.apache.kylin.metrics.property.QueryCubePropertyEnum;
import org.apache.kylin.metrics.property.QueryPropertyEnum;
import org.apache.kylin.metrics.property.QueryRPCPropertyEnum;
import org.apache.kylin.query.enumerator.OLAPQuery;
import org.apache.kylin.rest.metrics.QueryMetrics;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@ThreadSafe
public class QueryMetricsFacade {
    private static final Logger logger = LoggerFactory.getLogger(QueryMetricsFacade.class);
    private static final HashFunction hashFunc = Hashing.murmur3_128();
    private static boolean enabled = false;
    private static ConcurrentHashMap<String, QueryMetrics> metricsMap = new ConcurrentHashMap();

    public static void init() {
        enabled = KylinConfig.getInstanceFromEnv().getQueryMetricsEnabled();
        if (!enabled) {
            return;
        }
        DefaultMetricsSystem.initialize((String)"Kylin");
    }

    public static long getSqlHashCode(String sql) {
        return hashFunc.hashString((CharSequence)sql, Charset.forName("UTF-8")).asLong();
    }

    public static void updateMetrics(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        QueryMetricsFacade.updateMetricsToLocal(sqlRequest, sqlResponse);
        QueryMetricsFacade.updateMetricsToReservoir(sqlRequest, sqlResponse);
    }

    private static void updateMetricsToLocal(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (!enabled) {
            return;
        }
        String projectName = sqlRequest.getProject();
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics("Server_Total"), sqlResponse);
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(projectName), sqlResponse);
        String cube = sqlResponse.getCube();
        String cubeName = cube.replace("=", "->");
        String cubeMetricName = projectName + ",sub=" + cubeName;
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(cubeMetricName), sqlResponse);
    }

    private static void updateMetricsToReservoir(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (!KylinConfig.getInstanceFromEnv().isKylinMetricsReporterForQueryEnabled()) {
            return;
        }
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        if (user == null) {
            user = "unknown";
        }
        for (QueryContext.RPCStatistics entry : QueryContextFacade.current().getRpcStatisticsList()) {
            TimedRecordEvent rpcMetricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectQueryRpcCall());
            QueryMetricsFacade.setRPCWrapper((RecordEvent)rpcMetricsEvent, QueryMetricsFacade.norm(sqlRequest.getProject()), entry.getRealizationName(), entry.getRpcServer(), entry.getException());
            QueryMetricsFacade.setRPCStats((RecordEvent)rpcMetricsEvent, entry.getCallTimeMs(), entry.getSkippedRows(), entry.getScannedRows(), entry.getReturnedRows(), entry.getAggregatedRows());
            MetricsManager.getInstance().update((Record)rpcMetricsEvent);
        }
        long sqlHashCode = QueryMetricsFacade.getSqlHashCode(sqlRequest.getSql());
        for (QueryContext.CubeSegmentStatisticsResult contextEntry : sqlResponse.getCubeSegmentStatisticsList()) {
            TimedRecordEvent queryMetricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectQuery());
            QueryMetricsFacade.setQueryWrapper((RecordEvent)queryMetricsEvent, user, sqlHashCode, sqlResponse.isStorageCacheUsed() ? "CACHE" : contextEntry.getQueryType(), QueryMetricsFacade.norm(sqlRequest.getProject()), contextEntry.getRealization(), contextEntry.getRealizationType(), sqlResponse.getThrowable());
            long totalStorageReturnCount = 0L;
            if (contextEntry.getQueryType().equalsIgnoreCase(OLAPQuery.EnumeratorTypeEnum.OLAP.name())) {
                for (Map cubeEntry : contextEntry.getCubeSegmentStatisticsMap().values()) {
                    for (QueryContext.CubeSegmentStatistics segmentEntry : cubeEntry.values()) {
                        TimedRecordEvent cubeSegmentMetricsEvent = new TimedRecordEvent(KylinConfig.getInstanceFromEnv().getKylinMetricsSubjectQueryCube());
                        QueryMetricsFacade.setCubeWrapper((RecordEvent)cubeSegmentMetricsEvent, QueryMetricsFacade.norm(sqlRequest.getProject()), segmentEntry.getCubeName(), segmentEntry.getSegmentName(), segmentEntry.getSourceCuboidId(), segmentEntry.getTargetCuboidId(), segmentEntry.getFilterMask());
                        QueryMetricsFacade.setCubeStats((RecordEvent)cubeSegmentMetricsEvent, segmentEntry.getCallCount(), segmentEntry.getCallTimeSum(), segmentEntry.getCallTimeMax(), segmentEntry.getStorageSkippedRows(), segmentEntry.getStorageScannedRows(), segmentEntry.getStorageReturnedRows(), segmentEntry.getStorageAggregatedRows(), segmentEntry.isIfSuccess(), 1.0 / (double)cubeEntry.size());
                        totalStorageReturnCount += segmentEntry.getStorageReturnedRows();
                        MetricsManager.getInstance().update((Record)cubeSegmentMetricsEvent);
                    }
                }
            } else if (!sqlResponse.getIsException()) {
                totalStorageReturnCount = sqlResponse.getResults().size();
            }
            QueryMetricsFacade.setQueryStats((RecordEvent)queryMetricsEvent, sqlResponse.getDuration(), sqlResponse.getResults() == null ? 0L : (long)sqlResponse.getResults().size(), totalStorageReturnCount);
            MetricsManager.getInstance().update((Record)queryMetricsEvent);
        }
    }

    private static String norm(String project) {
        return project.toUpperCase(Locale.ROOT);
    }

    private static void setRPCWrapper(RecordEvent metricsEvent, String projectName, String realizationName, String rpcServer, Throwable throwable) {
        metricsEvent.put(QueryRPCPropertyEnum.PROJECT.toString(), (Object)projectName);
        metricsEvent.put(QueryRPCPropertyEnum.REALIZATION.toString(), (Object)realizationName);
        metricsEvent.put(QueryRPCPropertyEnum.RPC_SERVER.toString(), (Object)rpcServer);
        metricsEvent.put(QueryRPCPropertyEnum.EXCEPTION.toString(), (Object)(throwable == null ? "NULL" : throwable.getClass().getName()));
    }

    private static void setRPCStats(RecordEvent metricsEvent, long callTimeMs, long skipCount, long scanCount, long returnCount, long aggrCount) {
        metricsEvent.put(QueryRPCPropertyEnum.CALL_TIME.toString(), (Object)callTimeMs);
        metricsEvent.put(QueryRPCPropertyEnum.SKIP_COUNT.toString(), (Object)skipCount);
        metricsEvent.put(QueryRPCPropertyEnum.SCAN_COUNT.toString(), (Object)scanCount);
        metricsEvent.put(QueryRPCPropertyEnum.RETURN_COUNT.toString(), (Object)returnCount);
        metricsEvent.put(QueryRPCPropertyEnum.AGGR_FILTER_COUNT.toString(), (Object)(scanCount - returnCount));
        metricsEvent.put(QueryRPCPropertyEnum.AGGR_COUNT.toString(), (Object)aggrCount);
    }

    private static void setCubeWrapper(RecordEvent metricsEvent, String projectName, String cubeName, String segmentName, long sourceCuboidId, long targetCuboidId, long filterMask) {
        metricsEvent.put(QueryCubePropertyEnum.PROJECT.toString(), (Object)projectName);
        metricsEvent.put(QueryCubePropertyEnum.CUBE.toString(), (Object)cubeName);
        metricsEvent.put(QueryCubePropertyEnum.SEGMENT.toString(), (Object)segmentName);
        metricsEvent.put(QueryCubePropertyEnum.CUBOID_SOURCE.toString(), (Object)sourceCuboidId);
        metricsEvent.put(QueryCubePropertyEnum.CUBOID_TARGET.toString(), (Object)targetCuboidId);
        metricsEvent.put(QueryCubePropertyEnum.IF_MATCH.toString(), (Object)(sourceCuboidId == targetCuboidId ? 1 : 0));
        metricsEvent.put(QueryCubePropertyEnum.FILTER_MASK.toString(), (Object)filterMask);
    }

    private static void setCubeStats(RecordEvent metricsEvent, long callCount, long callTimeSum, long callTimeMax, long skipCount, long scanCount, long returnCount, long aggrCount, boolean ifSuccess, double weightPerHit) {
        metricsEvent.put(QueryCubePropertyEnum.CALL_COUNT.toString(), (Object)callCount);
        metricsEvent.put(QueryCubePropertyEnum.TIME_SUM.toString(), (Object)callTimeSum);
        metricsEvent.put(QueryCubePropertyEnum.TIME_MAX.toString(), (Object)callTimeMax);
        metricsEvent.put(QueryCubePropertyEnum.SKIP_COUNT.toString(), (Object)skipCount);
        metricsEvent.put(QueryCubePropertyEnum.SCAN_COUNT.toString(), (Object)scanCount);
        metricsEvent.put(QueryCubePropertyEnum.RETURN_COUNT.toString(), (Object)returnCount);
        metricsEvent.put(QueryCubePropertyEnum.AGGR_FILTER_COUNT.toString(), (Object)(scanCount - returnCount));
        metricsEvent.put(QueryCubePropertyEnum.AGGR_COUNT.toString(), (Object)aggrCount);
        metricsEvent.put(QueryCubePropertyEnum.IF_SUCCESS.toString(), (Object)ifSuccess);
        metricsEvent.put(QueryCubePropertyEnum.WEIGHT_PER_HIT.toString(), (Object)weightPerHit);
    }

    private static void setQueryWrapper(RecordEvent metricsEvent, String user, long queryHashCode, String queryType, String projectName, String realizationName, int realizationType, Throwable throwable) {
        metricsEvent.put(QueryPropertyEnum.USER.toString(), (Object)user);
        metricsEvent.put(QueryPropertyEnum.ID_CODE.toString(), (Object)queryHashCode);
        metricsEvent.put(QueryPropertyEnum.TYPE.toString(), (Object)queryType);
        metricsEvent.put(QueryPropertyEnum.PROJECT.toString(), (Object)projectName);
        metricsEvent.put(QueryPropertyEnum.REALIZATION.toString(), (Object)realizationName);
        metricsEvent.put(QueryPropertyEnum.REALIZATION_TYPE.toString(), (Object)realizationType);
        metricsEvent.put(QueryPropertyEnum.EXCEPTION.toString(), (Object)(throwable == null ? "NULL" : throwable.getClass().getName()));
    }

    private static void setQueryStats(RecordEvent metricsEvent, long callTimeMs, long returnCountByCalcite, long returnCountByStorage) {
        metricsEvent.put(QueryPropertyEnum.TIME_COST.toString(), (Object)callTimeMs);
        metricsEvent.put(QueryPropertyEnum.CALCITE_RETURN_COUNT.toString(), (Object)returnCountByCalcite);
        metricsEvent.put(QueryPropertyEnum.STORAGE_RETURN_COUNT.toString(), (Object)returnCountByStorage);
        long countAggrAndFilter = returnCountByStorage - returnCountByCalcite;
        if (countAggrAndFilter < 0L) {
            countAggrAndFilter = 0L;
            logger.warn(returnCountByStorage + " rows returned by storage less than " + returnCountByCalcite + " rows returned by calcite");
        }
        metricsEvent.put(QueryPropertyEnum.AGGR_FILTER_COUNT.toString(), (Object)countAggrAndFilter);
    }

    private static void update(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        try {
            QueryMetricsFacade.incrQueryCount(queryMetrics, sqlResponse);
            QueryMetricsFacade.incrCacheHitCount(queryMetrics, sqlResponse);
            if (!sqlResponse.getIsException()) {
                queryMetrics.addQueryLatency(sqlResponse.getDuration());
                queryMetrics.addScanRowCount(sqlResponse.getTotalScanCount());
                queryMetrics.addResultRowCount(sqlResponse.getResults().size());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static void incrQueryCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (!sqlResponse.isHitExceptionCache() && !sqlResponse.getIsException()) {
            queryMetrics.incrQuerySuccessCount();
        } else {
            queryMetrics.incrQueryFailCount();
        }
        queryMetrics.incrQueryCount();
    }

    private static void incrCacheHitCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (sqlResponse.isStorageCacheUsed()) {
            queryMetrics.addCacheHitCount(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryMetrics getQueryMetrics(String name) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int[] intervals = config.getQueryMetricsPercentilesIntervals();
        QueryMetrics queryMetrics = metricsMap.get(name);
        if (queryMetrics != null) {
            return queryMetrics;
        }
        Class<QueryMetricsFacade> clazz = QueryMetricsFacade.class;
        synchronized (QueryMetricsFacade.class) {
            queryMetrics = metricsMap.get(name);
            if (queryMetrics != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return queryMetrics;
            }
            try {
                queryMetrics = new QueryMetrics(intervals).registerWith(name);
                metricsMap.put(name, queryMetrics);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return queryMetrics;
            }
            catch (MetricsException e) {
                logger.warn(name + " register error: ", (Throwable)e);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return queryMetrics;
        }
    }
}

