/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.dict.lookup.IExtLookupTableCache;
import org.apache.kylin.dict.lookup.LookupProviderFactory;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.response.TableDescResponse;
import org.apache.kylin.rest.response.TableSnapshotResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.KafkaConfigService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.StreamingService;
import org.apache.kylin.rest.service.TableSchemaUpdateChecker;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.source.hive.cardinality.HiveColumnCardinalityJob;
import org.apache.kylin.source.hive.cardinality.HiveColumnCardinalityUpdateJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="tableService")
public class TableService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableService.class);
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="streamingMgmtService")
    private StreamingService streamingService;
    @Autowired
    @Qualifier(value="kafkaMgmtService")
    private KafkaConfigService kafkaConfigService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public List<TableDesc> getTableDescByProject(String project, boolean withExt) throws IOException {
        this.aclEvaluate.checkProjectReadPermission(project);
        List<TableDesc> tables = this.getProjectManager().listDefinedTables(project);
        if (null == tables) {
            return Collections.emptyList();
        }
        if (withExt) {
            this.aclEvaluate.checkProjectWritePermission(project);
            tables = this.cloneTableDesc(tables, project);
        }
        return tables;
    }

    public TableDesc getTableDescByName(String tableName, boolean withExt, String prj) {
        this.aclEvaluate.checkProjectReadPermission(prj);
        TableDesc table = this.getTableManager().getTableDesc(tableName, prj);
        if (withExt) {
            this.aclEvaluate.checkProjectWritePermission(prj);
            table = this.cloneTableDesc(table, prj);
        }
        return table;
    }

    public String[] loadHiveTablesToProject(String[] hiveTables, String project) throws Exception {
        this.aclEvaluate.checkProjectAdminPermission(project);
        List<Pair<TableDesc, TableExtDesc>> allMeta = this.extractHiveTableMeta(hiveTables, project);
        return this.loadTablesToProject(allMeta, project);
    }

    public String[] loadTableToProject(TableDesc tableDesc, TableExtDesc extDesc, String project) throws IOException {
        return this.loadTablesToProject(Lists.newArrayList((Object[])new Pair[]{Pair.newPair((Object)tableDesc, (Object)extDesc)}), project);
    }

    private String[] loadTablesToProject(List<Pair<TableDesc, TableExtDesc>> allMeta, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        TableMetadataManager metaMgr = this.getTableManager();
        CubeManager cubeMgr = this.getCubeManager();
        TableSchemaUpdateChecker checker = new TableSchemaUpdateChecker(metaMgr, cubeMgr);
        for (Pair<TableDesc, TableExtDesc> pair : allMeta) {
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            TableSchemaUpdateChecker.CheckResult result = checker.allowReload(tableDesc, project);
            result.raiseExceptionWhenInvalid();
        }
        ArrayList saved = Lists.newArrayList();
        for (Pair<TableDesc, TableExtDesc> pair : allMeta) {
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            TableExtDesc extDesc = (TableExtDesc)pair.getSecond();
            TableDesc origTable = metaMgr.getTableDesc(tableDesc.getIdentity(), project);
            if (origTable == null || origTable.getProject() == null) {
                tableDesc.setUuid(RandomUtil.randomUUID().toString());
                tableDesc.setLastModified(0L);
            } else {
                tableDesc.setUuid(origTable.getUuid());
                tableDesc.setLastModified(origTable.getLastModified());
            }
            metaMgr.saveSourceTable(tableDesc, project);
            if (extDesc != null) {
                TableExtDesc origExt = metaMgr.getTableExt(tableDesc.getIdentity(), project);
                if (origExt == null || origExt.getProject() == null) {
                    extDesc.setUuid(UUID.randomUUID().toString());
                    extDesc.setLastModified(0L);
                } else {
                    extDesc.setUuid(origExt.getUuid());
                    extDesc.setLastModified(origExt.getLastModified());
                }
                extDesc.init(project);
                metaMgr.saveTableExt(extDesc, project);
            }
            saved.add(tableDesc.getIdentity());
        }
        String[] stringArray = saved.toArray(new String[saved.size()]);
        this.addTableToProject(stringArray, project);
        return stringArray;
    }

    public List<Pair<TableDesc, TableExtDesc>> extractHiveTableMeta(String[] tables, String project) throws Exception {
        LinkedHashMultimap db2tables = LinkedHashMultimap.create();
        for (String fullTableName : tables) {
            String[] parts = HadoopUtil.parseHiveTableName((String)fullTableName);
            db2tables.put((Object)parts[0], (Object)parts[1]);
        }
        ArrayList allMeta = Lists.newArrayList();
        ProjectInstance projectInstance = this.getProjectManager().getProject(project);
        ISourceMetadataExplorer explr = SourceManager.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer();
        for (Map.Entry entry : db2tables.entries()) {
            Pair pair = explr.loadTableMetadata((String)entry.getKey(), (String)entry.getValue(), project);
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            Preconditions.checkState((boolean)tableDesc.getDatabase().equals(((String)entry.getKey()).toUpperCase(Locale.ROOT)));
            Preconditions.checkState((boolean)tableDesc.getName().equals(((String)entry.getValue()).toUpperCase(Locale.ROOT)));
            Preconditions.checkState((boolean)tableDesc.getIdentity().equals(((String)entry.getKey()).toUpperCase(Locale.ROOT) + "." + ((String)entry.getValue()).toUpperCase(Locale.ROOT)));
            TableExtDesc extDesc = (TableExtDesc)pair.getSecond();
            Preconditions.checkState((boolean)tableDesc.getIdentity().equals(extDesc.getIdentity()));
            allMeta.add(pair);
        }
        return allMeta;
    }

    private void addTableToProject(String[] tables, String project) throws IOException {
        this.getProjectManager().addTableDescToProject(tables, project);
    }

    protected void removeTableFromProject(String tableName, String projectName) throws IOException {
        tableName = this.normalizeHiveTableName(tableName);
        this.getProjectManager().removeTableDescFromProject(tableName, projectName);
    }

    public boolean unloadHiveTable(String tableName, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        Message msg = MsgPicker.getMsg();
        boolean rtn = false;
        boolean tableType = false;
        tableName = this.normalizeHiveTableName(tableName);
        TableDesc desc = this.getTableManager().getTableDesc(tableName, project);
        if (desc == null || desc.getProject() == null) {
            logger.warn("Unload Table {} in Project {} failed, could not find TableDesc or related Project", (Object)tableName, (Object)project);
            return false;
        }
        if (this.modelService.isTableInModel(desc, project)) {
            List<String> models = this.modelService.getModelsUsingTable(desc, project);
            throw new BadRequestException(String.format(Locale.ROOT, msg.getTABLE_IN_USE_BY_MODEL(), models));
        }
        this.removeTableFromProject(tableName, project);
        rtn = true;
        TableMetadataManager metaMgr = this.getTableManager();
        metaMgr.removeTableExt(tableName, project);
        metaMgr.removeSourceTable(tableName, project);
        SourceManager sourceManager = SourceManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ISource source = sourceManager.getCachedSource((ISourceAware)desc);
        source.unloadTable(tableName, project);
        return rtn;
    }

    public List<String> getSourceDbNames(String project) throws Exception {
        ISourceMetadataExplorer explr = SourceManager.getInstance((KylinConfig)this.getConfig()).getProjectSource(project).getSourceMetadataExplorer();
        return explr.listDatabases();
    }

    public List<String> getSourceTableNames(String project, String database) throws Exception {
        ISourceMetadataExplorer explr = SourceManager.getInstance((KylinConfig)this.getConfig()).getProjectSource(project).getSourceMetadataExplorer();
        return explr.listTables(database);
    }

    private TableDescResponse cloneTableDesc(TableDesc table, String prj) {
        TableExtDesc tableExtDesc = this.getTableManager().getTableExt(table.getIdentity(), prj);
        TableDescResponse rtableDesc = new TableDescResponse(table);
        HashMap<String, Long> cardinality = new HashMap<String, Long>();
        HashMap<String, String> dataSourceProp = new HashMap<String, String>();
        String scard = tableExtDesc.getCardinality();
        if (!StringUtils.isEmpty((String)scard)) {
            String[] cards = StringUtils.split((String)scard, (String)",");
            ColumnDesc[] cdescs = rtableDesc.getColumns();
            for (int i = 0; i < cdescs.length; ++i) {
                ColumnDesc columnDesc = cdescs[i];
                if (cards.length <= i) {
                    logger.error("The result cardinality is not identical with hive table metadata, cardinality : " + scard + " column array length: " + cdescs.length);
                    break;
                }
                cardinality.put(columnDesc.getName(), Long.parseLong(cards[i]));
            }
            rtableDesc.setCardinality(cardinality);
        }
        dataSourceProp.putAll(tableExtDesc.getDataSourceProp());
        rtableDesc.setDescExd(dataSourceProp);
        return rtableDesc;
    }

    private List<TableDesc> cloneTableDesc(List<TableDesc> tables, String prj) throws IOException {
        ArrayList<TableDesc> descs = new ArrayList<TableDesc>();
        for (TableDesc table : tables) {
            TableDescResponse rtableDesc = this.cloneTableDesc(table, prj);
            descs.add(rtableDesc);
        }
        return descs;
    }

    public void calculateCardinalityIfNotPresent(String[] tables, String submitter, String prj) throws Exception {
        TableMetadataManager metaMgr = this.getTableManager();
        ExecutableManager exeMgt = ExecutableManager.getInstance((KylinConfig)this.getConfig());
        for (String table : tables) {
            TableExtDesc tableExtDesc = metaMgr.getTableExt(table, prj);
            String jobID = tableExtDesc.getJodID();
            if (null != jobID && ExecutableState.RUNNING == exeMgt.getOutput(jobID).getState()) continue;
            this.calculateCardinality(table, submitter, prj);
        }
    }

    public void updateSnapshotLocalCache(String project, String tableName, String snapshotID) {
        ExtTableSnapshotInfoManager snapshotInfoManager = ExtTableSnapshotInfoManager.getInstance((KylinConfig)this.getConfig());
        ExtTableSnapshotInfo extTableSnapshotInfo = snapshotInfoManager.getSnapshot(tableName, snapshotID);
        TableDesc tableDesc = this.getTableManager().getTableDesc(tableName, project);
        if (extTableSnapshotInfo == null) {
            throw new IllegalArgumentException("cannot find ext snapshot info for table:" + tableName + " snapshot:" + snapshotID);
        }
        LookupProviderFactory.rebuildLocalCache((TableDesc)tableDesc, (ExtTableSnapshotInfo)extTableSnapshotInfo);
    }

    public void removeSnapshotLocalCache(String tableName, String snapshotID) {
        ExtTableSnapshotInfoManager snapshotInfoManager = ExtTableSnapshotInfoManager.getInstance((KylinConfig)this.getConfig());
        ExtTableSnapshotInfo extTableSnapshotInfo = snapshotInfoManager.getSnapshot(tableName, snapshotID);
        if (extTableSnapshotInfo == null) {
            throw new IllegalArgumentException("cannot find ext snapshot info for table:" + tableName + " snapshot:" + snapshotID);
        }
        LookupProviderFactory.removeLocalCache((ExtTableSnapshotInfo)extTableSnapshotInfo);
    }

    public String getSnapshotLocalCacheState(String tableName, String snapshotID) {
        ExtTableSnapshotInfoManager snapshotInfoManager = ExtTableSnapshotInfoManager.getInstance((KylinConfig)this.getConfig());
        ExtTableSnapshotInfo extTableSnapshotInfo = snapshotInfoManager.getSnapshot(tableName, snapshotID);
        if (extTableSnapshotInfo == null) {
            throw new IllegalArgumentException("cannot find ext snapshot info for table:" + tableName + " snapshot:" + snapshotID);
        }
        IExtLookupTableCache.CacheState cacheState = LookupProviderFactory.getCacheState((ExtTableSnapshotInfo)extTableSnapshotInfo);
        return cacheState.name();
    }

    public List<TableSnapshotResponse> getLookupTableSnapshots(String project, String tableName) throws IOException {
        TableDesc tableDesc = this.getTableManager().getTableDesc(tableName, project);
        IReadableTable hiveTable = SourceManager.createReadableTable((TableDesc)tableDesc, null);
        IReadableTable.TableSignature signature = hiveTable.getSignature();
        return this.internalGetLookupTableSnapshots(tableName, signature);
    }

    List<TableSnapshotResponse> internalGetLookupTableSnapshots(String tableName, IReadableTable.TableSignature signature) throws IOException {
        TableSnapshotResponse response;
        ExtTableSnapshotInfoManager extSnapshotInfoManager = ExtTableSnapshotInfoManager.getInstance((KylinConfig)this.getConfig());
        SnapshotManager snapshotManager = SnapshotManager.getInstance((KylinConfig)this.getConfig());
        List extTableSnapshots = extSnapshotInfoManager.getSnapshots(tableName);
        List metaStoreTableSnapshots = snapshotManager.getSnapshots(tableName, signature);
        Map<String, List<String>> snapshotUsageMap = this.getSnapshotUsages();
        ArrayList result = Lists.newArrayList();
        for (ExtTableSnapshotInfo extTableSnapshot : extTableSnapshots) {
            response = new TableSnapshotResponse();
            response.setSnapshotID(extTableSnapshot.getId());
            response.setSnapshotType("ext");
            response.setLastBuildTime(extTableSnapshot.getLastBuildTime());
            response.setStorageType(extTableSnapshot.getStorageType());
            response.setSourceTableSize(extTableSnapshot.getSignature().getSize());
            response.setSourceTableLastModifyTime(extTableSnapshot.getSignature().getLastModifiedTime());
            response.setCubesAndSegmentsUsage(snapshotUsageMap.get(extTableSnapshot.getResourcePath()));
            result.add(response);
        }
        for (SnapshotTable metaStoreTableSnapshot : metaStoreTableSnapshots) {
            response = new TableSnapshotResponse();
            response.setSnapshotID(metaStoreTableSnapshot.getId());
            response.setSnapshotType("inner");
            response.setLastBuildTime(metaStoreTableSnapshot.getLastBuildTime());
            response.setStorageType("metaStore");
            response.setSourceTableSize(metaStoreTableSnapshot.getSignature().getSize());
            response.setSourceTableLastModifyTime(metaStoreTableSnapshot.getSignature().getLastModifiedTime());
            response.setCubesAndSegmentsUsage(snapshotUsageMap.get(metaStoreTableSnapshot.getResourcePath()));
            result.add(response);
        }
        return result;
    }

    private Map<String, List<String>> getSnapshotUsages() {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.getConfig());
        HashMap snapshotCubeSegmentMap = Maps.newHashMap();
        for (CubeInstance cube : cubeManager.listAllCubes()) {
            Collection cubeSnapshots = cube.getSnapshots().values();
            for (String cubeSnapshot : cubeSnapshots) {
                List usages = (List)snapshotCubeSegmentMap.get(cubeSnapshot);
                if (usages == null) {
                    usages = Lists.newArrayList();
                    snapshotCubeSegmentMap.put(cubeSnapshot, usages);
                }
                usages.add(cube.getName());
            }
            for (CubeSegment segment : cube.getSegments()) {
                Collection segmentSnapshots = segment.getSnapshotPaths();
                for (String segmentSnapshot : segmentSnapshots) {
                    List usages = (List)snapshotCubeSegmentMap.get(segmentSnapshot);
                    if (usages == null) {
                        usages = Lists.newArrayList();
                        snapshotCubeSegmentMap.put(segmentSnapshot, usages);
                    }
                    usages.add(cube.getName() + ":" + segment.getName());
                }
            }
        }
        return snapshotCubeSegmentMap;
    }

    public void calculateCardinality(String tableName, String submitter, String prj) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(prj);
        Message msg = MsgPicker.getMsg();
        tableName = this.normalizeHiveTableName(tableName);
        TableDesc table = this.getTableManager().getTableDesc(tableName, prj);
        TableExtDesc tableExt = this.getTableManager().getTableExt(tableName, prj);
        if (table == null) {
            BadRequestException e = new BadRequestException(String.format(Locale.ROOT, msg.getTABLE_DESC_NOT_FOUND(), tableName));
            logger.error("Cannot find table descriptor " + tableName, (Throwable)e);
            throw e;
        }
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        job.setParam("segmentId", tableName);
        job.setName("Hive Column Cardinality calculation for table '" + tableName + "'");
        job.setSubmitter(submitter);
        String outPath = this.getConfig().getHdfsWorkingDirectory() + "cardinality/" + job.getId() + "/" + tableName;
        String param = "-table " + tableName + " -output " + outPath + " -project " + prj;
        MapReduceExecutable step1 = new MapReduceExecutable();
        step1.setMapReduceJobClass(HiveColumnCardinalityJob.class);
        step1.setMapReduceParams(param);
        step1.setParam("segmentId", tableName);
        job.addTask((AbstractExecutable)step1);
        HadoopShellExecutable step2 = new HadoopShellExecutable();
        step2.setJobClass(HiveColumnCardinalityUpdateJob.class);
        step2.setJobParams(param);
        step2.setParam("segmentId", tableName);
        job.addTask((AbstractExecutable)step2);
        tableExt.setJodID(job.getId());
        this.getTableManager().saveTableExt(tableExt, prj);
        this.getExecutableManager().addJob((AbstractExecutable)job);
    }

    public String normalizeHiveTableName(String tableName) {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        return (dbTableName[0] + "." + dbTableName[1]).toUpperCase(Locale.ROOT);
    }
}

