/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.springframework.stereotype.Component;

@Component(value="encodingService")
public class EncodingService
extends BasicService {
    public List<String> getValidEncodings(DataType dataType) {
        Message msg = MsgPicker.getMsg();
        if (dataType.isIntegerFamily()) {
            return Lists.newArrayList((Object[])new String[]{"boolean", "date", "time", "dict", "integer"});
        }
        if (dataType.isNumberFamily()) {
            return Lists.newArrayList((Object[])new String[]{"dict"});
        }
        if (dataType.isDateTimeFamily()) {
            return Lists.newArrayList((Object[])new String[]{"date", "time", "dict"});
        }
        if (dataType.isStringFamily()) {
            return Lists.newArrayList((Object[])new String[]{"boolean", "dict", "fixed_length", "fixed_length_hex", "integer"});
        }
        throw new BadRequestException(String.format(msg.getVALID_ENCODING_NOT_AVAILABLE(), dataType));
    }
}

