/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.rest.security.ManagedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinUserManager {
    private static final Logger logger = LoggerFactory.getLogger(KylinUserManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<ManagedUser> userMap;
    private CachedCrudAssist<ManagedUser> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public static KylinUserManager getInstance(KylinConfig config) {
        return (KylinUserManager)config.getManager(KylinUserManager.class);
    }

    static KylinUserManager newInstance(KylinConfig config) throws IOException {
        return new KylinUserManager(config);
    }

    public KylinUserManager(KylinConfig config) throws IOException {
        logger.info("Initializing KylinUserManager with config " + config);
        this.config = config;
        this.userMap = new CaseInsensitiveStringCache(config, "user");
        this.crud = new CachedCrudAssist<ManagedUser>(this.getStore(), "/user", "", ManagedUser.class, this.userMap, false){

            protected ManagedUser initEntityAfterReload(ManagedUser user, String resourceName) {
                return user;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance((KylinConfig)config).registerListener((Broadcaster.Listener)new ManagedUserSyncListener(), new String[]{"user"});
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore((KylinConfig)this.config);
    }

    public ManagedUser get(String name) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            ManagedUser managedUser = (ManagedUser)((Object)this.userMap.get((Object)name));
            return managedUser;
        }
    }

    public List<ManagedUser> list() {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            ArrayList<ManagedUser> users = new ArrayList<ManagedUser>();
            users.addAll(this.userMap.values());
            Collections.sort(users, new Comparator<ManagedUser>(){

                @Override
                public int compare(ManagedUser o1, ManagedUser o2) {
                    return o1.getUsername().compareToIgnoreCase(o2.getUsername());
                }
            });
            ArrayList<ManagedUser> arrayList = users;
            return arrayList;
        }
    }

    public void update(ManagedUser user) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            ManagedUser exist = (ManagedUser)((Object)this.userMap.get((Object)user.getUsername()));
            if (exist != null) {
                user.setLastModified(exist.getLastModified());
            }
            this.crud.save((RootPersistentEntity)user);
        }
        catch (IOException e) {
            throw new RuntimeException("Can not update user.", e);
        }
    }

    public void delete(String username) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.delete(username);
        }
        catch (IOException e) {
            throw new RuntimeException("Can not delete user.", e);
        }
    }

    public boolean exists(String username) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            boolean bl = this.userMap.containsKey(username);
            return bl;
        }
    }

    private class ManagedUserSyncListener
    extends Broadcaster.Listener {
        private ManagedUserSyncListener() {
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = KylinUserManager.this.lock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    KylinUserManager.this.userMap.removeLocal((Object)cacheKey);
                } else {
                    KylinUserManager.this.crud.reloadQuietly(cacheKey);
                }
            }
        }
    }
}

