/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.acl.TableACL;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="TableAclService")
public class TableACLService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableACLService.class);
    @Autowired
    private AclEvaluate aclEvaluate;

    private TableACL getTableACLByProject(String project) throws IOException {
        return this.getTableACLManager().getTableACLByCache(project);
    }

    public boolean exists(String project, String name, String type) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).contains(name, type);
    }

    public List<String> getNoAccessList(String project, String table, String type) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).getNoAccessList(table, type);
    }

    public List<String> getCanAccessList(String project, String table, Set<String> allIdentifiers, String type) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).getCanAccessList(table, allIdentifiers, type);
    }

    public void addToTableACL(String project, String name, String table, String type) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().addTableACL(project, name, table, type);
    }

    public void deleteFromTableACL(String project, String name, String table, String type) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACL(project, name, table, type);
    }

    public void deleteFromTableACL(String project, String name, String type) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACL(project, name, type);
    }

    public void deleteFromTableACLByTbl(String project, String table) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACLByTbl(project, table);
    }
}

