/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.broadcaster;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BroadcasterReceiveServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private BroadcasterHandler handler;
    private static final Pattern PATTERN = Pattern.compile("/(.+)/(.+)/(.+)");

    public BroadcasterReceiveServlet(BroadcasterHandler handler) {
        this.handler = handler;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String startString = "/kylin/api/cache";
        String requestURI = req.getRequestURI();
        String substring = requestURI.substring(requestURI.indexOf("/kylin/api/cache") + "/kylin/api/cache".length());
        Matcher matcher = PATTERN.matcher(substring);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String name = matcher.group(2);
            String event = matcher.group(3);
            if (this.handler != null) {
                this.handler.handle(type, name, event);
            }
            resp.getWriter().write("type:" + type + " name:" + name + " event:" + event);
        } else {
            resp.getWriter().write("not valid uri");
        }
        resp.getWriter().close();
    }

    public static interface BroadcasterHandler {
        public void handle(String var1, String var2, String var3);
    }
}

