/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.LinkedList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.util.QueryUtil;

public class CognosParenthesesEscape
implements QueryUtil.IQueryTransformer {
    private static final String S0 = "\\s*";
    private static final String S1 = "\\s";
    private static final String SM = "\\s+";
    private static final String TABLE_OR_COLUMN_NAME = "[\\w\\\"\\'\\.]+";
    private static final String TABLE_NAME_WITH_OPTIONAL_ALIAS = "[\\w\\\"\\'\\.]+((\\s+as)?\\s+[\\w\\\"\\'\\.]+)?";
    private static final String JOIN = "(\\s+inner|\\s+((left|right|full)(\\s+outer)?))?\\s+join";
    private static final String EQUAL_CONDITION = "\\s+[\\w\\\"\\'\\.]+\\s*=\\s*[\\w\\\"\\'\\.]+";
    private static final String PARENTHESE_PATTERN_STR = "\\(\\s*[\\w\\\"\\'\\.]+((\\s+as)?\\s+[\\w\\\"\\'\\.]+)?(\\s+inner|\\s+((left|right|full)(\\s+outer)?))?\\s+join\\s+[\\w\\\"\\'\\.]+((\\s+as)?\\s+[\\w\\\"\\'\\.]+)?\\s+on\\s+[\\w\\\"\\'\\.]+\\s*=\\s*[\\w\\\"\\'\\.]+(\\s+and\\s+[\\w\\\"\\'\\.]+\\s*=\\s*[\\w\\\"\\'\\.]+)*\\s*\\)";
    private static final Pattern PARENTTHESES_PATTERN = Pattern.compile("\\(\\s*[\\w\\\"\\'\\.]+((\\s+as)?\\s+[\\w\\\"\\'\\.]+)?(\\s+inner|\\s+((left|right|full)(\\s+outer)?))?\\s+join\\s+[\\w\\\"\\'\\.]+((\\s+as)?\\s+[\\w\\\"\\'\\.]+)?\\s+on\\s+[\\w\\\"\\'\\.]+\\s*=\\s*[\\w\\\"\\'\\.]+(\\s+and\\s+[\\w\\\"\\'\\.]+\\s*=\\s*[\\w\\\"\\'\\.]+)*\\s*\\)", 2);
    private static int identifierNum = 0;

    @Override
    public String transform(String sql) {
        Matcher m;
        LinkedList<Pair> matches = new LinkedList<Pair>();
        while ((m = PARENTTHESES_PATTERN.matcher(sql)).find()) {
            String oneParentheses = m.group(0);
            String identifier = this.generateRandomName();
            matches.add(new Pair((Object)identifier, (Object)oneParentheses.substring(1, oneParentheses.length() - 1)));
            sql = sql.substring(0, m.start()) + identifier + sql.substring(m.end());
        }
        for (int i = matches.size() - 1; i >= 0; --i) {
            sql = sql.replaceAll((String)((Pair)matches.get(i)).getKey(), (String)((Pair)matches.get(i)).getValue());
        }
        return sql;
    }

    private String generateRandomName() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "_") + "_" + identifierNum++;
    }
}

