/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.exceptions.ResourceLimitExceededException;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.CheckUtil;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.metrics.QueryMetricsFacade;
import org.apache.kylin.rest.model.ColumnMeta;
import org.apache.kylin.rest.model.Query;
import org.apache.kylin.rest.model.SelectedColumnMeta;
import org.apache.kylin.rest.model.TableMeta;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.BadQueryDetector;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CacheService;
import org.apache.kylin.rest.util.QueryUtil;
import org.apache.kylin.rest.util.Serializer;
import org.apache.kylin.rest.util.TableauInterceptor;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="queryService")
public class QueryService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(QueryService.class);
    public static final String USER_QUERY_FAMILY = "q";
    private static final String USER_TABLE_NAME = "_user";
    private static final String USER_QUERY_COLUMN = "c";
    public static final String SUCCESS_QUERY_CACHE = "StorageCache";
    public static final String EXCEPTION_QUERY_CACHE = "ExceptionQueryCache";
    private final Serializer<Query[]> querySerializer = new Serializer<Query[]>(Query[].class);
    private final BadQueryDetector badQueryDetector = new BadQueryDetector();
    private final String hbaseUrl;
    private final String userTableName;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private CacheService cacheService;

    @PostConstruct
    public void init() throws IOException {
        Preconditions.checkNotNull((Object)this.cacheManager, (Object)"cacheManager is not injected yet");
    }

    public QueryService() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String metadataUrl = kylinConfig.getMetadataUrl();
        int cut = metadataUrl.indexOf(64);
        this.hbaseUrl = cut < 0 ? metadataUrl : metadataUrl.substring(cut + 1);
        String tableNameBase = kylinConfig.getMetadataUrlPrefix();
        this.userTableName = tableNameBase + USER_TABLE_NAME;
        this.badQueryDetector.start();
    }

    public List<TableMeta> getMetadata(String project) throws SQLException {
        return this.getMetadata(this.getCubeManager(), project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLResponse query(SQLRequest sqlRequest) throws Exception {
        try {
            String user = SecurityContextHolder.getContext().getAuthentication().getName();
            this.badQueryDetector.queryStart(Thread.currentThread(), sqlRequest, user);
            SQLResponse sQLResponse = this.queryWithSqlMassage(sqlRequest);
            return sQLResponse;
        }
        finally {
            this.badQueryDetector.queryEnd(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveQuery(String creator, Query query) throws IOException {
        List<Query> queries = this.getQueries(creator);
        queries.add(query);
        Query[] queryArray = new Query[queries.size()];
        byte[] bytes = this.querySerializer.serialize(queries.toArray(queryArray));
        Table htable = null;
        try {
            htable = HBaseConnection.get((String)this.hbaseUrl).getTable(TableName.valueOf((String)this.userTableName));
            Put put = new Put(Bytes.toBytes((String)creator));
            put.addColumn(Bytes.toBytes((String)USER_QUERY_FAMILY), Bytes.toBytes((String)USER_QUERY_COLUMN), bytes);
            htable.put(put);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(htable);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)htable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String creator, String id) throws IOException {
        List<Query> queries = this.getQueries(creator);
        Iterator<Query> queryIter = queries.iterator();
        boolean changed = false;
        while (queryIter.hasNext()) {
            Query temp = queryIter.next();
            if (!temp.getId().equals(id)) continue;
            queryIter.remove();
            changed = true;
            break;
        }
        if (!changed) {
            return;
        }
        Query[] queryArray = new Query[queries.size()];
        byte[] bytes = this.querySerializer.serialize(queries.toArray(queryArray));
        Table htable = null;
        try {
            htable = HBaseConnection.get((String)this.hbaseUrl).getTable(TableName.valueOf((String)this.userTableName));
            Put put = new Put(Bytes.toBytes((String)creator));
            put.addColumn(Bytes.toBytes((String)USER_QUERY_FAMILY), Bytes.toBytes((String)USER_QUERY_COLUMN), bytes);
            htable.put(put);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(htable);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)htable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Query> getQueries(String creator) throws IOException {
        if (null == creator) {
            return null;
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        Table htable = null;
        try {
            Connection conn = HBaseConnection.get((String)this.hbaseUrl);
            HBaseConnection.createHTableIfNeeded((Connection)conn, (String)this.userTableName, (String[])new String[]{USER_QUERY_FAMILY});
            htable = HBaseConnection.get((String)this.hbaseUrl).getTable(TableName.valueOf((String)this.userTableName));
            Get get = new Get(Bytes.toBytes((String)creator));
            get.addFamily(Bytes.toBytes((String)USER_QUERY_FAMILY));
            Result result = htable.get(get);
            Query[] query = this.querySerializer.deserialize(result.getValue(Bytes.toBytes((String)USER_QUERY_FAMILY), Bytes.toBytes((String)USER_QUERY_COLUMN)));
            if (null != query) {
                queries.addAll(Arrays.asList(query));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(htable);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)htable);
        return queries;
    }

    public void logQuery(SQLRequest request, SQLResponse response) {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        LinkedList<String> realizationNames = new LinkedList<String>();
        HashSet<Long> cuboidIds = new HashSet<Long>();
        float duration = (float)response.getDuration() / 1000.0f;
        boolean storageCacheUsed = response.isStorageCacheUsed();
        if (!response.isHitExceptionCache() && null != OLAPContext.getThreadLocalContexts()) {
            for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
                Cuboid cuboid = ctx.storageContext.getCuboid();
                if (cuboid != null) {
                    cuboidIds.add(cuboid.getId());
                }
                if (ctx.realization == null) continue;
                realizationNames.add(ctx.realization.getCanonicalName());
            }
        }
        int resultRowCount = 0;
        if (!response.getIsException() && response.getResults() != null) {
            resultRowCount = response.getResults().size();
        }
        String newLine = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(newLine);
        stringBuilder.append("==========================[QUERY]===============================").append(newLine);
        stringBuilder.append("Query Id: ").append(QueryContext.current().getQueryId()).append(newLine);
        stringBuilder.append("SQL: ").append(request.getSql()).append(newLine);
        stringBuilder.append("User: ").append(user).append(newLine);
        stringBuilder.append("Success: ").append(null == response.getExceptionMessage()).append(newLine);
        stringBuilder.append("Duration: ").append(duration).append(newLine);
        stringBuilder.append("Project: ").append(request.getProject()).append(newLine);
        stringBuilder.append("Realization Names: ").append(realizationNames).append(newLine);
        stringBuilder.append("Cuboid Ids: ").append(cuboidIds).append(newLine);
        stringBuilder.append("Total scan count: ").append(response.getTotalScanCount()).append(newLine);
        stringBuilder.append("Total scan bytes: ").append(response.getTotalScanBytes()).append(newLine);
        stringBuilder.append("Result row count: ").append(resultRowCount).append(newLine);
        stringBuilder.append("Accept Partial: ").append(request.isAcceptPartial()).append(newLine);
        stringBuilder.append("Is Partial Result: ").append(response.isPartial()).append(newLine);
        stringBuilder.append("Hit Exception Cache: ").append(response.isHitExceptionCache()).append(newLine);
        stringBuilder.append("Storage cache used: ").append(storageCacheUsed).append(newLine);
        stringBuilder.append("Message: ").append(response.getExceptionMessage()).append(newLine);
        stringBuilder.append("==========================[QUERY]===============================").append(newLine);
        logger.info(stringBuilder.toString());
    }

    public void checkAuthorization(String cubeName) throws AccessDeniedException {
        HybridInstance hybridInstance = this.getHybridManager().getHybridInstance(cubeName);
        if (hybridInstance != null) {
            this.checkHybridAuthorization(hybridInstance);
            return;
        }
        CubeInstance cubeInstance = this.getCubeManager().getCube(cubeName);
        this.checkCubeAuthorization(cubeInstance);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT') or hasPermission(#cube, 'OPERATION') or hasPermission(#cube, 'READ')")
    private void checkCubeAuthorization(CubeInstance cube) throws AccessDeniedException {
    }

    private void checkHybridAuthorization(HybridInstance hybridInstance) throws AccessDeniedException {
        List realizationEntries = hybridInstance.getRealizationEntries();
        for (RealizationEntry realizationEntry : realizationEntries) {
            String reName = realizationEntry.getRealization();
            if (RealizationType.CUBE == realizationEntry.getType()) {
                CubeInstance cubeInstance = this.getCubeManager().getCube(reName);
                this.checkCubeAuthorization(cubeInstance);
                continue;
            }
            if (RealizationType.HYBRID != realizationEntry.getType()) continue;
            HybridInstance innerHybridInstance = this.getHybridManager().getHybridInstance(reName);
            this.checkHybridAuthorization(innerHybridInstance);
        }
    }

    /*
     * Loose catch block
     */
    public SQLResponse doQueryWithCache(SQLRequest sqlRequest) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String serverMode = kylinConfig.getServerMode();
        if (!"query".equals(serverMode.toLowerCase()) && !"all".equals(serverMode.toLowerCase())) {
            throw new InternalErrorException("Query is not allowed in " + serverMode + " mode.");
        }
        if (StringUtils.isBlank((String)sqlRequest.getProject())) {
            throw new InternalErrorException("Project cannot be empty. Please select a project.");
        }
        if (sqlRequest.getBackdoorToggles() != null) {
            BackdoorToggles.addToggles(sqlRequest.getBackdoorToggles());
        }
        QueryContext queryContext = QueryContext.current();
        try {
            try (SetThreadName ignored = new SetThreadName("Query %s", new Object[]{queryContext.getQueryId()});){
                SQLResponse sqlResponse;
                block27: {
                    boolean queryCacheEnabled;
                    String sql = sqlRequest.getSql();
                    String project = sqlRequest.getProject();
                    logger.info("Using project: " + project);
                    logger.info("The original query:  " + sql);
                    if (!sql.toLowerCase().contains("select")) {
                        logger.debug("Directly return exception as not supported");
                        throw new InternalErrorException("Not Supported SQL.");
                    }
                    long startTime = System.currentTimeMillis();
                    sqlResponse = null;
                    boolean bl = CheckUtil.checkCondition((boolean)kylinConfig.isQueryCacheEnabled(), (String)"query cache disabled in KylinConfig", (Object[])new Object[0]) && CheckUtil.checkCondition((!BackdoorToggles.getDisableCache() ? 1 : 0) != 0, (String)"query cache disabled in BackdoorToggles", (Object[])new Object[0]) ? true : (queryCacheEnabled = false);
                    if (queryCacheEnabled) {
                        sqlResponse = this.searchQueryInCache(sqlRequest);
                    }
                    try {
                        if (null == sqlResponse) {
                            sqlResponse = this.query(sqlRequest);
                            long durationThreshold = kylinConfig.getQueryDurationCacheThreshold();
                            long scanCountThreshold = kylinConfig.getQueryScanCountCacheThreshold();
                            long scanBytesThreshold = kylinConfig.getQueryScanBytesCacheThreshold();
                            sqlResponse.setDuration(System.currentTimeMillis() - startTime);
                            logger.info("Stats of SQL response: isException: {}, duration: {}, total scan count {}", new Object[]{String.valueOf(sqlResponse.getIsException()), String.valueOf(sqlResponse.getDuration()), String.valueOf(sqlResponse.getTotalScanCount())});
                            if (CheckUtil.checkCondition((boolean)queryCacheEnabled, (String)"query cache is disabled", (Object[])new Object[0]) && CheckUtil.checkCondition((!sqlResponse.getIsException() ? 1 : 0) != 0, (String)"query has exception", (Object[])new Object[0]) && CheckUtil.checkCondition((sqlResponse.getDuration() > durationThreshold || sqlResponse.getTotalScanCount() > scanCountThreshold || sqlResponse.getTotalScanBytes() > scanBytesThreshold ? 1 : 0) != 0, (String)"query is too lightweight with duration: {} (threshold {}), scan count: {} (threshold {}), scan bytes: {} (threshold {})", (Object[])new Object[]{sqlResponse.getDuration(), durationThreshold, sqlResponse.getTotalScanCount(), scanCountThreshold, sqlResponse.getTotalScanBytes(), scanBytesThreshold}) && CheckUtil.checkCondition((sqlResponse.getResults().size() < kylinConfig.getLargeQueryThreshold() ? 1 : 0) != 0, (String)"query response is too large: {} ({})", (Object[])new Object[]{sqlResponse.getResults().size(), kylinConfig.getLargeQueryThreshold()})) {
                                this.cacheManager.getCache(SUCCESS_QUERY_CACHE).put(new Element((Serializable)sqlRequest, (Serializable)sqlResponse));
                            }
                        } else {
                            sqlResponse.setDuration(System.currentTimeMillis() - startTime);
                            sqlResponse.setTotalScanCount(0L);
                            sqlResponse.setTotalScanBytes(0L);
                        }
                        this.checkQueryAuth(sqlResponse);
                    }
                    catch (Throwable e) {
                        logger.error("Exception when execute sql", e);
                        String errMsg = QueryUtil.makeErrorMsgUserFriendly(e);
                        sqlResponse = new SQLResponse(null, null, 0, true, errMsg);
                        sqlResponse.setTotalScanCount(queryContext.getScannedRows());
                        sqlResponse.setTotalScanBytes(queryContext.getScannedBytes());
                        if (!queryCacheEnabled || e.getCause() == null || !(e.getCause() instanceof ResourceLimitExceededException)) break block27;
                        Cache exceptionCache = this.cacheManager.getCache(EXCEPTION_QUERY_CACHE);
                        exceptionCache.put(new Element((Serializable)sqlRequest, (Serializable)sqlResponse));
                    }
                }
                this.logQuery(sqlRequest, sqlResponse);
                QueryMetricsFacade.updateMetrics(sqlRequest, sqlResponse);
                if (sqlResponse.getIsException()) {
                    throw new InternalErrorException(sqlResponse.getExceptionMessage());
                }
                SQLResponse sQLResponse = sqlResponse;
                return sQLResponse;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            BackdoorToggles.cleanToggles();
            QueryContext.reset();
        }
    }

    public SQLResponse searchQueryInCache(SQLRequest sqlRequest) {
        SQLResponse response = null;
        Cache exceptionCache = this.cacheManager.getCache(EXCEPTION_QUERY_CACHE);
        Cache successCache = this.cacheManager.getCache(SUCCESS_QUERY_CACHE);
        if (exceptionCache.get((Serializable)sqlRequest) != null) {
            logger.info("The sqlResponse is found in EXCEPTION_QUERY_CACHE");
            Element element = exceptionCache.get((Serializable)sqlRequest);
            response = (SQLResponse)element.getObjectValue();
            response.setHitExceptionCache(true);
        } else if (successCache.get((Serializable)sqlRequest) != null) {
            logger.info("The sqlResponse is found in SUCCESS_QUERY_CACHE");
            Element element = successCache.get((Serializable)sqlRequest);
            response = (SQLResponse)element.getObjectValue();
            response.setStorageCacheUsed(true);
        }
        return response;
    }

    protected void checkQueryAuth(SQLResponse sqlResponse) throws AccessDeniedException {
        if (!sqlResponse.getIsException() && KylinConfig.getInstanceFromEnv().isQuerySecureEnabled()) {
            this.checkAuthorization(sqlResponse.getCube());
        }
    }

    private SQLResponse queryWithSqlMassage(SQLRequest sqlRequest) throws Exception {
        String userInfo = SecurityContextHolder.getContext().getAuthentication().getName();
        Collection grantedAuthorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        for (GrantedAuthority grantedAuthority : grantedAuthorities) {
            userInfo = userInfo + ",";
            userInfo = userInfo + grantedAuthority.getAuthority();
        }
        SQLResponse fakeResponse = TableauInterceptor.tableauIntercept(sqlRequest.getSql());
        if (null != fakeResponse) {
            logger.debug("Return fake response, is exception? " + fakeResponse.getIsException());
            return fakeResponse;
        }
        String correctedSql = QueryUtil.massageSql(sqlRequest);
        if (!correctedSql.equals(sqlRequest.getSql())) {
            logger.info("The corrected query: " + correctedSql);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("UserAuthenInfo", userInfo);
        parameters.put("AcceptPartialResult", String.valueOf(sqlRequest.isAcceptPartial()));
        OLAPContext.setParameters(parameters);
        OLAPContext.clearThreadLocalContexts();
        return this.execute(correctedSql, sqlRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TableMeta> getMetadata(CubeManager cubeMgr, String project, boolean cubedOnly) throws SQLException {
        java.sql.Connection conn = null;
        ResultSet columnMeta = null;
        LinkedList<TableMeta> tableMetas = null;
        if (StringUtils.isBlank((String)project)) {
            return Collections.emptyList();
        }
        ResultSet JDBCTableMeta = null;
        try {
            String schemaName;
            String catalogName;
            DataSource dataSource = this.cacheService.getOLAPDataSource(project);
            conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            JDBCTableMeta = metaData.getTables(null, null, null, null);
            tableMetas = new LinkedList<TableMeta>();
            HashMap<String, TableMeta> tableMap = new HashMap<String, TableMeta>();
            while (JDBCTableMeta.next()) {
                catalogName = JDBCTableMeta.getString(1);
                schemaName = JDBCTableMeta.getString(2);
                TableMeta tblMeta = new TableMeta(catalogName == null ? "defaultCatalog" : catalogName, schemaName == null ? "defaultSchema" : schemaName, JDBCTableMeta.getString(3), JDBCTableMeta.getString(4), JDBCTableMeta.getString(5), null, null, null, null, null);
                if (cubedOnly && !this.getProjectManager().isExposedTable(project, schemaName + "." + tblMeta.getTABLE_NAME())) continue;
                tableMetas.add(tblMeta);
                tableMap.put(tblMeta.getTABLE_SCHEM() + "#" + tblMeta.getTABLE_NAME(), tblMeta);
            }
            columnMeta = metaData.getColumns(null, null, null, null);
            while (columnMeta.next()) {
                catalogName = columnMeta.getString(1);
                schemaName = columnMeta.getString(2);
                ColumnMeta colmnMeta = new ColumnMeta(catalogName == null ? "defaultCatalog" : catalogName, schemaName == null ? "defaultSchema" : schemaName, columnMeta.getString(3), columnMeta.getString(4), columnMeta.getInt(5), columnMeta.getString(6), columnMeta.getInt(7), this.getInt(columnMeta.getString(8)), columnMeta.getInt(9), columnMeta.getInt(10), columnMeta.getInt(11), columnMeta.getString(12), columnMeta.getString(13), this.getInt(columnMeta.getString(14)), this.getInt(columnMeta.getString(15)), columnMeta.getInt(16), columnMeta.getInt(17), columnMeta.getString(18), columnMeta.getString(19), columnMeta.getString(20), columnMeta.getString(21), this.getShort(columnMeta.getString(22)), columnMeta.getString(23));
                if (cubedOnly && !this.getProjectManager().isExposedColumn(project, schemaName + "." + colmnMeta.getTABLE_NAME(), colmnMeta.getCOLUMN_NAME())) continue;
                ((TableMeta)tableMap.get(colmnMeta.getTABLE_SCHEM() + "#" + colmnMeta.getTABLE_NAME())).addColumn(colmnMeta);
            }
        }
        catch (Throwable throwable) {
            QueryService.close(columnMeta, null, conn);
            if (JDBCTableMeta != null) {
                JDBCTableMeta.close();
            }
            throw throwable;
        }
        QueryService.close(columnMeta, null, conn);
        if (JDBCTableMeta != null) {
            JDBCTableMeta.close();
        }
        return tableMetas;
    }

    private void processStatementAttr(Statement s, SQLRequest sqlRequest) throws SQLException {
        Integer statementMaxRows = BackdoorToggles.getStatementMaxRows();
        if (statementMaxRows != null) {
            logger.info("Setting current statement's max rows to {}", (Object)statementMaxRows);
            s.setMaxRows(statementMaxRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse execute(String correctedSql, SQLRequest sqlRequest) throws Exception {
        java.sql.Connection conn = null;
        Statement stat = null;
        ResultSet resultSet = null;
        ArrayList results = Lists.newArrayList();
        ArrayList columnMetas = Lists.newArrayList();
        try {
            conn = this.cacheService.getOLAPDataSource(sqlRequest.getProject()).getConnection();
            if (sqlRequest instanceof PrepareSqlRequest) {
                PreparedStatement preparedState = conn.prepareStatement(correctedSql);
                this.processStatementAttr(preparedState, sqlRequest);
                for (int i = 0; i < ((PrepareSqlRequest)sqlRequest).getParams().length; ++i) {
                    this.setParam(preparedState, i + 1, ((PrepareSqlRequest)sqlRequest).getParams()[i]);
                }
                resultSet = preparedState.executeQuery();
            } else {
                stat = conn.createStatement();
                this.processStatementAttr(stat, sqlRequest);
                resultSet = stat.executeQuery(correctedSql);
            }
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                columnMetas.add(new SelectedColumnMeta(metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), metaData.isSearchable(i), metaData.isCurrency(i), metaData.isNullable(i), metaData.isSigned(i), metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), metaData.getSchemaName(i), metaData.getCatalogName(i), metaData.getTableName(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.isReadOnly(i), metaData.isWritable(i), metaData.isDefinitelyWritable(i)));
            }
            while (resultSet.next()) {
                ArrayList oneRow = Lists.newArrayListWithCapacity((int)columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    oneRow.add(resultSet.getString(i + 1));
                }
                results.add(oneRow);
            }
        }
        catch (Throwable throwable) {
            QueryService.close(resultSet, stat, conn);
            throw throwable;
        }
        QueryService.close(resultSet, stat, conn);
        boolean isPartialResult = false;
        String cube = "";
        StringBuilder sb = new StringBuilder("Processed rows for each storageContext: ");
        if (OLAPContext.getThreadLocalContexts() != null) {
            for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
                if (ctx.realization == null) continue;
                isPartialResult |= ctx.storageContext.isPartialResultReturned();
                cube = ctx.realization.getName();
                sb.append(ctx.storageContext.getProcessedRowCount()).append(" ");
            }
        }
        logger.info(sb.toString());
        SQLResponse response = new SQLResponse(columnMetas, results, cube, 0, false, null, isPartialResult);
        response.setTotalScanCount(QueryContext.current().getScannedRows());
        response.setTotalScanBytes(QueryContext.current().getScannedBytes());
        return response;
    }

    private void setParam(PreparedStatement preparedState, int index, PrepareSqlRequest.StateParam param) throws SQLException {
        Class<?> clazz;
        boolean isNull = null == param.getValue();
        try {
            clazz = Class.forName(param.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(clazz);
        switch (rep) {
            case PRIMITIVE_CHAR: 
            case CHARACTER: 
            case STRING: {
                preparedState.setString(index, isNull ? null : String.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_INT: 
            case INTEGER: {
                preparedState.setInt(index, isNull ? 0 : Integer.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                preparedState.setShort(index, isNull ? (short)0 : Short.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_LONG: 
            case LONG: {
                preparedState.setLong(index, isNull ? 0L : Long.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_FLOAT: 
            case FLOAT: {
                preparedState.setFloat(index, isNull ? 0.0f : Float.valueOf(param.getValue()).floatValue());
                break;
            }
            case PRIMITIVE_DOUBLE: 
            case DOUBLE: {
                preparedState.setDouble(index, isNull ? 0.0 : Double.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_BOOLEAN: 
            case BOOLEAN: {
                preparedState.setBoolean(index, !isNull && Boolean.parseBoolean(param.getValue()));
                break;
            }
            case PRIMITIVE_BYTE: 
            case BYTE: {
                preparedState.setByte(index, isNull ? (byte)0 : Byte.valueOf(param.getValue()));
                break;
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_DATE: {
                preparedState.setDate(index, isNull ? null : Date.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIME: {
                preparedState.setTime(index, isNull ? null : Time.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIMESTAMP: {
                preparedState.setTimestamp(index, isNull ? null : Timestamp.valueOf(param.getValue()));
                break;
            }
            default: {
                preparedState.setObject(index, isNull ? null : param.getValue());
            }
        }
    }

    private int getInt(String content) {
        try {
            return Integer.parseInt(content);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private short getShort(String content) {
        try {
            return Short.parseShort(content);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void close(ResultSet resultSet, Statement stat, java.sql.Connection conn) {
        OLAPContext.clearParameter();
        DBUtils.closeQuietly((ResultSet)resultSet);
        DBUtils.closeQuietly((Statement)stat);
        DBUtils.closeQuietly((java.sql.Connection)conn);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

