/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="modelMgmtService")
public class ModelService
extends BasicService {
    @Autowired
    private AccessService accessService;

    @PostFilter(value="hasRole('ROLE_ADMIN') or hasPermission(filterObject, 'READ') or hasPermission(filterObject, 'MANAGEMENT') or hasPermission(filterObject, 'OPERATION') or hasPermission(filterObject, 'ADMINISTRATION')")
    public List<DataModelDesc> listAllModels(String modelName, String projectName) throws IOException {
        ProjectInstance project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        List models = null == project ? this.getMetadataManager().getModels() : this.getMetadataManager().getModels(projectName);
        ArrayList<DataModelDesc> filterModels = new ArrayList<DataModelDesc>();
        for (DataModelDesc modelDesc : models) {
            boolean isModelMatch = null == modelName || modelName.length() == 0 || modelDesc.getName().toLowerCase().equals(modelName.toLowerCase());
            if (!isModelMatch) continue;
            filterModels.add(modelDesc);
        }
        return filterModels;
    }

    public List<DataModelDesc> getModels(String modelName, String projectName, Integer limit, Integer offset) throws IOException {
        List<DataModelDesc> modelDescs = this.listAllModels(modelName, projectName);
        if (limit == null || offset == null) {
            return modelDescs;
        }
        if (modelDescs.size() - offset < limit) {
            return modelDescs.subList(offset, modelDescs.size());
        }
        return modelDescs.subList(offset, offset + limit);
    }

    public DataModelDesc createModelDesc(String projectName, DataModelDesc desc) throws IOException {
        if (this.getMetadataManager().getDataModelDesc(desc.getName()) != null) {
            throw new InternalErrorException("Model name " + desc.getName() + "is duplicated, could not create");
        }
        DataModelDesc createdDesc = null;
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        createdDesc = this.getMetadataManager().createDataModelDesc(desc, projectName, owner);
        this.accessService.init((AclEntity)createdDesc, AclPermission.ADMINISTRATION);
        ProjectInstance project = this.getProjectManager().getProject(projectName);
        this.accessService.inherit((AclEntity)createdDesc, (AclEntity)project);
        return createdDesc;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#desc, 'ADMINISTRATION') or hasPermission(#desc, 'MANAGEMENT')")
    public DataModelDesc updateModelAndDesc(DataModelDesc desc) throws IOException {
        this.getMetadataManager().updateDataModelDesc(desc);
        return desc;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#desc, 'ADMINISTRATION') or hasPermission(#desc, 'MANAGEMENT')")
    public void dropModel(DataModelDesc desc) throws IOException {
        List cubeDescs = this.getCubeDescManager().listAllDesc();
        for (CubeDesc cubeDesc : cubeDescs) {
            if (!cubeDesc.getModelName().equals(desc.getName())) continue;
            throw new InternalErrorException("Model is referenced by Cube: " + cubeDesc.getName() + " , could not drop");
        }
        this.getMetadataManager().dropModel(desc);
        this.accessService.clean((AclEntity)desc, true);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#desc, 'ADMINISTRATION') or hasPermission(#desc, 'MANAGEMENT')")
    public boolean isTableInAnyModel(String tableName) {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        tableName = dbTableName[0] + "." + dbTableName[1];
        return this.getMetadataManager().isTableInAnyModel(tableName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#desc, 'ADMINISTRATION') or hasPermission(#desc, 'MANAGEMENT')")
    public boolean isTableInModel(String tableName, String projectName) throws IOException {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        tableName = dbTableName[0] + "." + dbTableName[1];
        return this.getMetadataManager().isTableInModel(tableName, projectName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#desc, 'ADMINISTRATION') or hasPermission(#desc, 'MANAGEMENT')")
    public List<String> getModelsUsingTable(String tableName, String projectName) throws IOException {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        tableName = dbTableName[0] + "." + dbTableName[1];
        return this.getMetadataManager().getModelsUsingTable(tableName, projectName);
    }
}

